/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.core.modifiers;

import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.core.Easing;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IEasing;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;

public class WidgetModifierScale
extends WidgetModifier
implements IEasing {
    private float x = 1.0f;
    private float y = 1.0f;
    private float z = 1.0f;
    private float X;
    private float Y;
    private float Z;

    public WidgetModifierScale(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void update(float[] values) {
        if (values.length < 3) {
            return;
        }
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
        this.applyEasings();
    }

    @Override
    public void apply(long conditionStates) {
        if (!this.shouldApplyModifier(conditionStates)) {
            return;
        }
        this.applyEasings();
        GlStateManager.func_179152_a((float)this.X, (float)this.Y, (float)this.Z);
    }

    private void applyEasings() {
        this.X = Easing.applyEasing((ArrayList)this.easings.get("x"), this.x);
        this.Y = Easing.applyEasing((ArrayList)this.easings.get("y"), this.y);
        this.Z = Easing.applyEasing((ArrayList)this.easings.get("z"), this.z);
    }

    @Override
    public void revoke(long conditionStates) {
        if (!this.shouldApplyModifier(conditionStates)) {
            return;
        }
        if (this.X > 0.0f) {
            GlStateManager.func_179152_a((float)(1.0f / this.X), (float)1.0f, (float)1.0f);
        }
        if (this.Y > 0.0f) {
            GlStateManager.func_179152_a((float)1.0f, (float)(1.0f / this.Y), (float)1.0f);
        }
        if (this.Z > 0.0f) {
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f / this.Z));
        }
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeFloat(this.x);
        buff.writeFloat(this.y);
        buff.writeFloat(this.z);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.x = buff.readFloat();
        this.y = buff.readFloat();
        this.z = buff.readFloat();
    }

    @Override
    public WidgetModifier.WidgetModifierType getType() {
        return WidgetModifier.WidgetModifierType.SCALE;
    }

    @Override
    public Object[] getValues() {
        this.applyEasings();
        return new Object[]{Float.valueOf(this.X), Float.valueOf(this.Y), Float.valueOf(this.Z)};
    }
}

