/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj;

import ben_mkiv.rendertoolkit.common.widgets.component.wavefrontObj.Vertex;
import java.util.HashMap;
import java.util.List;

public class Face {
    protected String name;
    protected Vertex[] vertexes;

    public Face(Vertex[] vertexes) {
        this.vertexes = vertexes;
        this.setName(null);
    }

    public Face(List<Vertex> vertexes) {
        this(vertexes.toArray(new Vertex[0]));
    }

    public void setName(String name) {
        if (name == null) {
            String[] dirs;
            name = "";
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String dir : dirs = new String[]{"North", "South", "East", "West", "Top", "Bottom"}) {
                map.put(dir, 0);
                for (Vertex v : this.vertexes) {
                    if (!v.name().contains(dir)) continue;
                    map.put(dir, (Integer)map.get(dir) + 1);
                }
                if ((Integer)map.get(dir) != 4) continue;
                name = dir;
            }
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public String toString() {
        String s = this.name() + " {";
        for (Vertex v : this.vertexes) {
            s = s + v.name() + ", ";
        }
        return s + "}";
    }
}

