/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.commons0815.font.FontLoader;
import ben_mkiv.commons0815.font.TrueTypeFont;
import ben_mkiv.commons0815.utils.utilsClient;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IAlignable;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.ITextable;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TextWidget
extends WidgetGLWorld
implements ITextable,
IAlignable {
    String text = "";
    String fontName = "";
    boolean antialias = false;
    float fontSize = 12.0f;
    public float stringWidth;
    public float stringHeight;
    public float offsetX;
    public float offsetY;
    static ArrayList<TrueTypeFont> fontRenderer = new ArrayList();

    @SideOnly(value=Side.CLIENT)
    public void drawString(int currentColor) {
        if (this.getFontName().length() == 0) {
            utilsClient.fontRenderer().func_78276_b(this.getText(), 0, 0, currentColor);
        } else {
            this.getFont(this.getFontName()).drawString(this.getText(), 0.0f, 0.0f, currentColor);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateStringDimensions() {
        if (this.getFontName().length() == 0) {
            FontRenderer fontRender = utilsClient.fontRenderer();
            this.stringWidth = fontRender.func_78256_a(this.getText());
            this.stringHeight = fontRender.field_78288_b;
        } else {
            this.stringWidth = this.getFont(this.getFontName()).getWidth(this.getText());
            this.stringHeight = this.getFont(this.getFontName()).getHeight();
        }
    }

    public void updateAlignments() {
        switch (this.halign) {
            case LEFT: {
                this.offsetX = -this.stringWidth;
                break;
            }
            case CENTER: {
                this.offsetX = -this.stringWidth / 2.0f;
                break;
            }
            case RIGHT: {
                this.offsetX = 0.0f;
            }
        }
        switch (this.valign) {
            case TOP: {
                this.offsetY = -this.stringHeight;
                break;
            }
            case MIDDLE: {
                this.offsetY = -this.stringHeight / 2.0f;
                break;
            }
            case BOTTOM: {
                this.offsetY = 0.0f;
            }
        }
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.text);
        ByteBufUtils.writeUTF8String((ByteBuf)buff, (String)this.fontName);
        buff.writeFloat(this.fontSize);
        buff.writeBoolean(this.antialias);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.setText(ByteBufUtils.readUTF8String((ByteBuf)buff));
        this.setFont(ByteBufUtils.readUTF8String((ByteBuf)buff));
        this.setFontSize(buff.readFloat());
        this.setAntialias(buff.readBoolean());
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public TrueTypeFont getFont(String fontName) {
        for (TrueTypeFont ttf : fontRenderer) {
            if (!ttf.getFontName().equalsIgnoreCase(fontName) || ttf.getFontSize() != this.fontSize || ttf.getAntialias() != this.antialias) continue;
            return ttf;
        }
        fontRenderer.add(FontLoader.loadSystemFont(fontName, this.fontSize, this.antialias));
        return this.getFont(fontName);
    }

    @Override
    public void setFont(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public void setFontSize(float size) {
        this.fontSize = size;
    }

    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setAntialias(boolean state) {
        this.antialias = state;
    }
}

