/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client;

import ben_mkiv.rendertoolkit.client.thermalvision.ShaderHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class OptifineHelper {
    private static int depthBuffer = Integer.MAX_VALUE;
    private static int optifineFramebuffer = Integer.MAX_VALUE;
    private static IntBuffer optifineDrawbuffers;
    private static Program lastShaderProgram;
    private static Class optifineShadersClass;
    private static Class optifineConfigClass;
    private static boolean wasFastRenderEnabled;
    private static MethodHandle isFastRenderMethodHandle;

    public static boolean bindOptifineDepthBuffer() {
        if (OptifineHelper.getOptifineDepthBufferLocation() == Integer.MAX_VALUE) {
            return false;
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)OptifineHelper.getOptifineDepthBufferLocation(), (int)0);
        return true;
    }

    public static void releaseShaderProgram() {
        lastShaderProgram = Shaders.activeProgram;
        Shaders.useProgram((Program)Shaders.ProgramNone);
    }

    public static void rebindShaderProgram() {
        Shaders.useProgram((Program)lastShaderProgram);
    }

    public static void bindOptifineFramebuffer() {
        OptifineHelper.rebindShaderProgram();
        if (OptifineHelper.getOptifineFramebufferLocation() != Integer.MAX_VALUE) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)OptifineHelper.getOptifineFramebufferLocation());
            if (OptifineHelper.getOptifineDrawbuffers() != null) {
                GL20.glDrawBuffers((IntBuffer)OptifineHelper.getOptifineDrawbuffers());
            } else {
                GL20.glDrawBuffers((int)0);
            }
            GL11.glReadBuffer((int)0);
        }
    }

    public static int getOptifineDepthBufferLocation() {
        if (depthBuffer == Integer.MAX_VALUE) {
            try {
                Field field = Shaders.class.getDeclaredField("dfbDepthTextures");
                field.setAccessible(true);
                IntBuffer o = (IntBuffer)field.get(Shaders.class);
                depthBuffer = o.get(0);
            }
            catch (Exception ex) {
                System.out.println("reflection of Optifine Shader class failed for dfbDepthTextures");
            }
        }
        return depthBuffer;
    }

    private static int getOptifineFramebufferLocation() {
        if (optifineFramebuffer == Integer.MAX_VALUE) {
            try {
                Field field = Shaders.class.getDeclaredField("dfb");
                field.setAccessible(true);
                optifineFramebuffer = (Integer)field.get(Shaders.class);
            }
            catch (Exception ex) {
                System.out.println("reflection of Optifine Shader class failed for dfb");
            }
        }
        return optifineFramebuffer;
    }

    private static IntBuffer getOptifineDrawbuffers() {
        if (optifineDrawbuffers == null) {
            try {
                Field dfbDrawBuffers = Shaders.class.getDeclaredField("dfbDrawBuffers");
                dfbDrawBuffers.setAccessible(true);
                optifineDrawbuffers = (IntBuffer)dfbDrawBuffers.get(Shaders.class);
            }
            catch (Exception ex) {
                System.out.println("reflection of Optifine Shader class failed for dfbDrawBuffers");
            }
        }
        return optifineDrawbuffers;
    }

    public static Class getOptifineShadersClass() {
        if (optifineShadersClass == null) {
            try {
                optifineShadersClass = Class.forName("net.optifine.shaders.Shaders");
            }
            catch (Exception ex) {
                System.out.println("failed to retrieve optifine shader class");
            }
        }
        return optifineShadersClass;
    }

    public static Class getOptifineConfigClass() {
        if (optifineConfigClass == null) {
            try {
                optifineConfigClass = Class.forName("Config", true, Shaders.class.getClassLoader());
            }
            catch (Exception ex) {
                System.out.println("failed to retrieve optifine config class");
            }
        }
        return optifineConfigClass;
    }

    public static boolean isShaderActive() {
        return Shaders.shaderPackLoaded;
    }

    public static boolean isShadowPass() {
        return Shaders.isShadowPass;
    }

    public static boolean isFastRenderEnabled() {
        if (isFastRenderMethodHandle == null) {
            try {
                MethodType mt = MethodType.methodType(Boolean.TYPE);
                isFastRenderMethodHandle = MethodHandles.lookup().findStatic(OptifineHelper.getOptifineConfigClass(), "isFastRender", mt);
            }
            catch (Exception ex) {
                System.out.println("reflection of Optifine Shader class failed for isFastRender() method");
                return false;
            }
        }
        try {
            boolean isFastRenderEnabled = isFastRenderMethodHandle.invokeExact();
            if (isFastRenderEnabled != wasFastRenderEnabled) {
                depthBuffer = Integer.MAX_VALUE;
                optifineFramebuffer = Integer.MAX_VALUE;
                optifineDrawbuffers = null;
                ShaderHelper.resetFramebuffers();
                wasFastRenderEnabled = isFastRenderEnabled;
            }
            return isFastRenderEnabled;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        optifineShadersClass = null;
        optifineConfigClass = null;
        wasFastRenderEnabled = false;
        isFastRenderMethodHandle = null;
    }
}

