/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.guitoolkit.common.container.slots;

import ben_mkiv.guitoolkit.common.container.slots.filteredSlot;
import ben_mkiv.ocUtils.CustomDriver;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.driver.item.Container;
import li.cil.oc.common.Tier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpenComputerSlot
extends filteredSlot {
    private int tier = Tier.One();
    private String type = "upgrade";
    public ArrayList<ItemStack> whitelistItems = new ArrayList();
    public ArrayList<ItemStack> blacklistItems = new ArrayList();

    public OpenComputerSlot(IInventory inventory, int index, int xpos, int ypos, int tier, String type) {
        super(inventory, index, xpos, ypos);
        this.tier = tier;
        this.type = type;
    }

    public OpenComputerSlot(IInventory inventory, int index, int xpos, int ypos, @Nonnull ItemStack container) {
        super(inventory, index, xpos, ypos);
        DriverItem driver;
        this.tier = Tier.None();
        this.type = "none";
        if (!container.func_190926_b() && (driver = CustomDriver.driverFor(container)) != null && driver instanceof Container) {
            this.tier = ((Container)driver).providedTier(container);
            this.type = ((Container)driver).providedSlot(container);
        }
    }

    public void func_75218_e() {
        super.func_75218_e();
    }

    public String getSlotType() {
        return this.type;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        if (this.type.equals("none") || this.tier == Tier.None()) {
            return false;
        }
        if (this.whitelistItems.size() > 0) {
            boolean match = false;
            for (ItemStack i : this.whitelistItems) {
                if (!i.func_77973_b().equals(stack.func_77973_b())) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if (this.blacklistItems.size() > 0) {
            for (ItemStack i : this.blacklistItems) {
                if (!i.func_77973_b().equals(stack.func_77973_b())) continue;
                return false;
            }
        }
        if (this.type.equals("any") && this.tier == Tier.Any()) {
            return true;
        }
        DriverItem drv = CustomDriver.driverFor(stack);
        if (drv == null) {
            return false;
        }
        if (!this.type.equals(drv.slot(stack))) {
            return false;
        }
        if (this.tier < drv.tier(stack)) {
            return false;
        }
        return this.field_75224_c.func_94041_b(this.field_75222_d, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_111238_b() {
        return !this.type.equals("none") && this.tier != Tier.None();
    }

    @Override
    public List<String> getTooltip(List<String> tooltip) {
        switch (this.getSlotType()) {
            case "rack_mountable": {
                tooltip.add("Type: Server Slot");
                break;
            }
            case "upgrade": {
                tooltip.add("Type: Upgrade Slot");
                tooltip.add("Tier: " + (this.getTier() + 1));
            }
        }
        return super.getTooltip(tooltip);
    }
}

