/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class ClientProvider {
    private static final RotationHandler rotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return slotId == 4;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 5: {
                        return 8;
                    }
                    case 8: {
                        return 7;
                    }
                    case 7: {
                        return 6;
                    }
                    case 6: {
                        return 3;
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else {
                switch (slotId) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 5;
                    }
                }
            }
            return 0;
        }
    };
    private final ItemStackHandler lastCraftedMatrix = new ItemStackHandler(9);
    private boolean hasLastCraftedMatrix;

    private PlayerControllerMP getController() {
        return Minecraft.func_71410_x().field_71442_b;
    }

    private boolean canBalance(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public void balanceGrid(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        if (!this.canBalance(provider, entityPlayer, container, id)) {
            return;
        }
        ArrayListMultimap balanceSlots = ArrayListMultimap.create();
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)container.field_75151_b.get(i);
            if (!slot.func_75216_d() || (itemStack = slot.func_75211_c()).func_190926_b()) continue;
            balanceSlots.put((Object)(itemStack.func_77973_b().getRegistryName() + "@" + itemStack.func_77952_i()), (Object)slot);
        }
        for (String key : balanceSlots.keySet()) {
            ItemStack itemStack;
            Collection slotList = balanceSlots.get((Object)key);
            int average = 0;
            for (Slot slot : slotList) {
                itemStack = slot.func_75211_c();
                if (itemStack.func_190926_b()) continue;
                average += itemStack.func_190916_E();
            }
            average = (int)Math.floor((float)average / (float)slotList.size());
            for (Slot slot : slotList) {
                if (!slot.func_75216_d() || (itemStack = slot.func_75211_c()).func_190926_b() || itemStack.func_190916_E() <= average) continue;
                int mouseStackSize = itemStack.func_190916_E();
                this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                for (Slot otherSlot : slotList) {
                    int otherStackSize;
                    ItemStack otherStack;
                    if (slot == otherSlot || !otherSlot.func_75216_d() || (otherStack = otherSlot.func_75211_c()).func_190926_b() || (otherStackSize = otherStack.func_190916_E()) >= average) continue;
                    while (otherStackSize < average && mouseStackSize > average) {
                        this.getController().func_187098_a(container.field_75152_c, otherSlot.field_75222_d, 1, ClickType.PICKUP, entityPlayer);
                        --mouseStackSize;
                        ++otherStackSize;
                    }
                }
                this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
            }
        }
    }

    public void spreadGrid(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        int tries = 0;
        while (tries < 9) {
            int i;
            ++tries;
            Slot biggestSlot = null;
            int biggestSlotSize = 1;
            int start = provider.getCraftingGridStart(entityPlayer, container, id);
            int size = provider.getCraftingGridSize(entityPlayer, container, id);
            for (i = start; i < start + size; ++i) {
                Slot slot = (Slot)container.field_75151_b.get(i);
                ItemStack itemStack = slot.func_75211_c();
                if (itemStack.func_190926_b() || itemStack.func_190916_E() <= biggestSlotSize) continue;
                biggestSlot = slot;
                biggestSlotSize = itemStack.func_190916_E();
            }
            if (biggestSlot == null) {
                return;
            }
            this.getController().func_187098_a(container.field_75152_c, biggestSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
            for (i = start; i < start + size; ++i) {
                ItemStack itemStack;
                if (i == biggestSlot.field_75222_d || !(itemStack = ((Slot)container.field_75151_b.get(i)).func_75211_c()).func_190926_b() || biggestSlotSize <= 1) continue;
                this.getController().func_187098_a(container.field_75152_c, i, 1, ClickType.PICKUP, entityPlayer);
                if (--biggestSlotSize == 1) break;
            }
            this.getController().func_187098_a(container.field_75152_c, biggestSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
        }
        this.balanceGrid(provider, entityPlayer, container, id);
    }

    private boolean canClear(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public void clearGrid(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id, boolean forced) {
        if (!this.canClear(provider, entityPlayer, container, id)) {
            return;
        }
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            this.getController().func_187098_a(container.field_75152_c, i, 0, ClickType.QUICK_MOVE, entityPlayer);
            container.func_82846_b(entityPlayer, i);
            if (!forced || !((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
            this.getController().func_187098_a(container.field_75152_c, i, 0, ClickType.THROW, entityPlayer);
        }
    }

    private boolean canRotate(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide() && provider.getCraftingGridSize(entityPlayer, container, id) == 9;
    }

    public void rotateGrid(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id, boolean counterClockwise) {
        if (!this.canRotate(provider, entityPlayer, container, id)) {
            return;
        }
        if (!this.dropOffMouseStack(entityPlayer, container)) {
            return;
        }
        if (this.rotateGridWithBuffer(provider, entityPlayer, container, id, counterClockwise)) {
            return;
        }
        int startSlot = provider.getCraftingGridStart(entityPlayer, container, id);
        this.getController().func_187098_a(container.field_75152_c, startSlot, 0, ClickType.PICKUP, entityPlayer);
        int currentSlot = startSlot;
        do {
            currentSlot = startSlot + rotationHandler.rotateSlotId(currentSlot - startSlot, counterClockwise);
            this.getController().func_187098_a(container.field_75152_c, currentSlot, 0, ClickType.PICKUP, entityPlayer);
        } while (currentSlot != startSlot);
    }

    private boolean rotateGridWithBuffer(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id, boolean counterClockwise) {
        int startSlot;
        int emptyBuffer = 0;
        int[] bufferSlot = new int[2];
        for (Object obj : container.field_75151_b) {
            Slot slot = (Slot)obj;
            if (!(slot.field_75224_c instanceof InventoryPlayer) || slot.func_75216_d()) continue;
            bufferSlot[emptyBuffer] = slot.field_75222_d;
            if (++emptyBuffer < 2) continue;
            break;
        }
        if (emptyBuffer < 2) {
            return false;
        }
        emptyBuffer = 0;
        int currentSlot = startSlot = provider.getCraftingGridStart(entityPlayer, container, id);
        do {
            this.getController().func_187098_a(container.field_75152_c, currentSlot, 0, ClickType.PICKUP, entityPlayer);
            this.getController().func_187098_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, entityPlayer);
            emptyBuffer = (emptyBuffer + 1) % 2;
            this.getController().func_187098_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, entityPlayer);
            this.getController().func_187098_a(container.field_75152_c, currentSlot, 0, ClickType.PICKUP, entityPlayer);
        } while ((currentSlot = startSlot + rotationHandler.rotateSlotId(currentSlot - startSlot, counterClockwise)) != startSlot);
        emptyBuffer = (emptyBuffer + 1) % 2;
        this.getController().func_187098_a(container.field_75152_c, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, entityPlayer);
        this.getController().func_187098_a(container.field_75152_c, startSlot, 0, ClickType.PICKUP, entityPlayer);
        return true;
    }

    private boolean canTransfer(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide();
    }

    public boolean transferIntoGrid(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id, Slot sourceSlot) {
        if (!this.canTransfer(provider, entityPlayer, container, id)) {
            return false;
        }
        if (!(sourceSlot.func_75216_d() && sourceSlot.func_82869_a(entityPlayer) && provider.canTransferFrom(entityPlayer, container, id, sourceSlot))) {
            return false;
        }
        if (!this.dropOffMouseStack(entityPlayer, container)) {
            return false;
        }
        this.getController().func_187098_a(container.field_75152_c, sourceSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
        ItemStack mouseStack = entityPlayer.field_71071_by.func_70445_o();
        if (mouseStack.func_190926_b()) {
            return false;
        }
        boolean itemMoved = false;
        int firstEmptySlot = -1;
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            Slot craftSlot = (Slot)container.field_75151_b.get(i);
            ItemStack craftStack = craftSlot.func_75211_c();
            if (!craftStack.func_190926_b()) {
                int spaceLeft;
                if (!craftStack.func_77969_a(mouseStack) || !ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)mouseStack) || (spaceLeft = Math.min(craftSlot.func_75219_a(), craftStack.func_77976_d()) - craftStack.func_190916_E()) <= 0) continue;
                this.getController().func_187098_a(container.field_75152_c, craftSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                mouseStack = entityPlayer.field_71071_by.func_70445_o();
                if (!mouseStack.func_190926_b()) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot != -1) {
            this.getController().func_187098_a(container.field_75152_c, firstEmptySlot, 0, ClickType.PICKUP, entityPlayer);
            itemMoved = true;
        }
        if (!entityPlayer.field_71071_by.func_70445_o().func_190926_b()) {
            this.getController().func_187098_a(container.field_75152_c, sourceSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
        }
        this.dropOffMouseStack(entityPlayer, container);
        return itemMoved;
    }

    private boolean dropOffMouseStack(EntityPlayer entityPlayer, Container container) {
        return this.dropOffMouseStack(entityPlayer, container, -1);
    }

    private boolean dropOffMouseStack(EntityPlayer entityPlayer, Container container, int ignoreSlot) {
        if (entityPlayer.field_71071_by.func_70445_o().func_190926_b()) {
            return true;
        }
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            if (i == ignoreSlot) continue;
            Slot slot = (Slot)container.field_75151_b.get(i);
            if (slot.field_75224_c != entityPlayer.field_71071_by) continue;
            ItemStack mouseItem = entityPlayer.field_71071_by.func_70445_o();
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack.func_190926_b()) {
                this.getController().func_187098_a(container.field_75152_c, i, 0, ClickType.PICKUP, entityPlayer);
            } else if (mouseItem.func_77973_b() == slotStack.func_77973_b() && (!slotStack.func_77981_g() || slotStack.func_77960_j() == mouseItem.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseItem)) {
                this.getController().func_187098_a(container.field_75152_c, i, 0, ClickType.PICKUP, entityPlayer);
            }
            if (!entityPlayer.field_71071_by.func_70445_o().func_190926_b()) continue;
            return true;
        }
        return entityPlayer.field_71071_by.func_70445_o().func_190926_b();
    }

    private void decompress(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, Slot mouseSlot, CompressType compressType) {
        if (!mouseSlot.func_75216_d() || !this.canClear(provider, entityPlayer, container, 0)) {
            return;
        }
        boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
        this.clearGrid(provider, entityPlayer, container, 0, false);
        int start = provider.getCraftingGridStart(entityPlayer, container, 0);
        int size = provider.getCraftingGridSize(entityPlayer, container, 0);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
            return;
        }
        for (Slot slot : container.field_75151_b) {
            if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.field_75224_c instanceof InventoryPlayer) || !slot.func_75216_d() || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c()) || !ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c())) continue;
            this.getController().func_187098_a(container.field_75152_c, mouseSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
            this.getController().func_187098_a(container.field_75152_c, start, 0, ClickType.PICKUP, entityPlayer);
            for (Slot resultSlot : container.field_75151_b) {
                if (!(resultSlot instanceof SlotCrafting) || !resultSlot.func_75216_d()) continue;
                this.getController().func_187098_a(container.field_75152_c, resultSlot.field_75222_d, 0, decompressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, entityPlayer);
                break;
            }
            this.dropOffMouseStack(entityPlayer, container, mouseSlot.field_75222_d);
            this.getController().func_187098_a(container.field_75152_c, start, 0, ClickType.PICKUP, entityPlayer);
            this.getController().func_187098_a(container.field_75152_c, mouseSlot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, Slot mouseSlot, CompressType compressType) {
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_ONE || compressType == CompressType.DECOMPRESS_STACK) {
            this.decompress(provider, entityPlayer, container, mouseSlot, compressType);
            return;
        }
        if (!mouseSlot.func_75216_d() || !this.canClear(provider, entityPlayer, container, 0)) {
            return;
        }
        boolean compressAll = compressType != CompressType.COMPRESS_ONE;
        this.clearGrid(provider, entityPlayer, container, 0, false);
        int start = provider.getCraftingGridStart(entityPlayer, container, 0);
        int size = provider.getCraftingGridSize(entityPlayer, container, 0);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
            return;
        }
        for (Slot slot : container.field_75151_b) {
            int i;
            ItemStack result;
            if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot || !(slot.field_75224_c instanceof InventoryPlayer) || !slot.func_75216_d() || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c()) || !ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)mouseSlot.func_75211_c())) continue;
            ItemStack mouseStack = slot.func_75211_c();
            if (size == 9 && !mouseStack.func_190926_b() && mouseStack.func_190916_E() >= 9) {
                result = CraftingManager.func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 3, mouseStack), (World)entityPlayer.field_70170_p);
                if (!result.func_190926_b() && !this.isCompressBlacklisted(result)) {
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    for (i = start; i < start + size; ++i) {
                        this.getController().func_187098_a(container.field_75152_c, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    }
                    this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                } else {
                    result = CraftingManager.func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 2, mouseStack), (World)entityPlayer.field_70170_p);
                    if (result.func_190926_b() || this.isCompressBlacklisted(result)) return;
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                }
            } else if (size >= 4 && !mouseStack.func_190926_b() && mouseStack.func_190916_E() >= 4) {
                result = CraftingManager.func_82787_a((InventoryCrafting)new InventoryCraftingCompress(container, 2, mouseStack), (World)entityPlayer.field_70170_p);
                if (result.func_190926_b() || this.isCompressBlacklisted(result)) return;
                this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, entityPlayer);
                if (size == 4) {
                    for (i = start; i < start + size; ++i) {
                        this.getController().func_187098_a(container.field_75152_c, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    }
                } else {
                    this.getController().func_187098_a(container.field_75152_c, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, entityPlayer);
                }
                this.getController().func_187098_a(container.field_75152_c, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, entityPlayer);
                this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
            }
            for (Slot resultSlot : container.field_75151_b) {
                if (!(resultSlot instanceof SlotCrafting) || !resultSlot.func_75216_d()) continue;
                this.getController().func_187098_a(container.field_75152_c, resultSlot.field_75222_d, 0, compressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, entityPlayer);
                break;
            }
            this.dropOffMouseStack(entityPlayer, container, slot.field_75222_d);
            for (i = start; i < start + size; ++i) {
                if (!((Slot)container.field_75151_b.get(i)).func_75216_d()) continue;
                this.getController().func_187098_a(container.field_75152_c, i, 0, ClickType.PICKUP, entityPlayer);
                this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
            }
            this.dropOffMouseStack(entityPlayer, container);
        }
    }

    private static int getDragSplittingButton(int id, int limit) {
        return id & 3 | (limit & 3) << 2;
    }

    private boolean isCompressBlacklisted(ItemStack result) {
        ResourceLocation registryName = result.func_77973_b().getRegistryName();
        return registryName != null && CraftingTweaks.compressBlacklist.contains(registryName.toString());
    }

    public void onItemCrafted(IInventory craftMatrix) {
        if (craftMatrix.func_70302_i_() <= 9) {
            for (int i = 0; i < this.lastCraftedMatrix.getSlots(); ++i) {
                if (i < craftMatrix.func_70302_i_()) {
                    this.lastCraftedMatrix.setStackInSlot(i, craftMatrix.func_70301_a(i).func_77946_l());
                    continue;
                }
                this.lastCraftedMatrix.setStackInSlot(i, ItemStack.field_190927_a);
            }
            this.hasLastCraftedMatrix = true;
        }
    }

    private boolean canRefillLastCrafted(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id) {
        return !provider.requiresServerSide() && this.hasLastCraftedMatrix;
    }

    public void refillLastCrafted(TweakProvider<Container> provider, EntityPlayer entityPlayer, Container container, int id, boolean fullStack) {
        ItemStack itemStack;
        int i;
        if (!this.canRefillLastCrafted(provider, entityPlayer, container, id)) {
            return;
        }
        this.dropOffMouseStack(entityPlayer, container);
        int gridStart = provider.getCraftingGridStart(entityPlayer, container, id);
        int gridSize = provider.getCraftingGridSize(entityPlayer, container, id);
        block0: for (i = 0; i < this.lastCraftedMatrix.getSlots(); ++i) {
            itemStack = this.lastCraftedMatrix.getStackInSlot(i);
            if (!itemStack.func_190926_b()) {
                for (Slot slot : container.field_75151_b) {
                    if (!(slot.field_75224_c instanceof InventoryPlayer) || !slot.func_75216_d() || !ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)slot.func_75211_c(), (ItemStack)itemStack)) continue;
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, gridStart + i, fullStack ? 0 : 1, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, slot.field_75222_d, 0, ClickType.PICKUP, entityPlayer);
                    continue block0;
                }
                continue;
            }
            if (!((Slot)container.field_75151_b.get(gridStart + i)).func_75216_d()) continue;
            this.getController().func_187098_a(container.field_75152_c, gridStart + i, 0, ClickType.PICKUP, entityPlayer);
            if (this.dropOffMouseStack(entityPlayer, container)) continue;
            this.getController().func_187098_a(container.field_75152_c, gridStart + i, 0, ClickType.PICKUP, entityPlayer);
            return;
        }
        if (fullStack) {
            block2: for (i = 0; i < this.lastCraftedMatrix.getSlots(); ++i) {
                itemStack = this.lastCraftedMatrix.getStackInSlot(i);
                if (itemStack.func_190926_b() || ((Slot)container.field_75151_b.get(gridStart + i)).func_75216_d()) continue;
                for (int j = gridStart; j < gridStart + gridSize; ++j) {
                    ItemStack gridStack;
                    if (j == gridStart + i || (gridStack = ((Slot)container.field_75151_b.get(j)).func_75211_c()).func_190916_E() <= 1 || !ItemStack.func_179545_c((ItemStack)gridStack, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)gridStack, (ItemStack)itemStack)) continue;
                    this.getController().func_187098_a(container.field_75152_c, j, 0, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, gridStart + i, 1, ClickType.PICKUP, entityPlayer);
                    this.getController().func_187098_a(container.field_75152_c, j, 0, ClickType.PICKUP, entityPlayer);
                    continue block2;
                }
            }
            this.balanceGrid(provider, entityPlayer, container, id);
        }
        this.dropOffMouseStack(entityPlayer, container);
    }
}

