/*
 * Decompiled with CFR 0.152.
 */
package vfyjxf.gregicprobe.config;

import java.io.File;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class GregicProbeConfig {
    public static Configuration config;
    public static boolean displayItemOutputs;
    public static boolean displayFluidOutputs;
    public static boolean displayBukkit;
    public static boolean displayItemName;
    public static boolean displayFluidName;
    public static boolean displayFluidQuantities;
    public static boolean displayCableAverage;

    public static void initConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        displayItemOutputs = config.getBoolean("DisplayItemOutputs", "general", true, "If true, the item outputs of the current recipe will be displayed");
        displayFluidOutputs = config.getBoolean("DisplayFluidOutputs", "general", true, "If true, the fluid outputs of the current recipe will be displayed");
        displayItemName = config.getBoolean("ShowItemName", "general", true, "If true, the name of the item will be displayed");
        displayFluidName = config.getBoolean("ShowFluidName", "general", true, "If true, the name of the fluid will be displayed");
        displayFluidQuantities = config.getBoolean("ShowFluidQuantities", "general", true, "If true, The quantity of the fluid will be displayed below the fluid, instead of the right, this is useful for removing clutter.");
        displayCableAverage = config.getBoolean("DisplayCableAverages", "general", true, "If true, the average energy and amperage of a cable net will be shown.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("gregicprobe".equals(event.getModID())) {
            ConfigManager.sync((String)"gregicprobe", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        displayItemOutputs = true;
        displayFluidOutputs = true;
        displayBukkit = true;
        displayItemName = true;
        displayFluidName = true;
        displayFluidQuantities = true;
        displayCableAverage = true;
    }
}

