/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import java.util.concurrent.Callable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class GenLayer {
    private long field_75907_b;
    protected GenLayer field_75909_a;
    private long field_75908_c;
    protected long field_75906_d;
    private static final String __OBFID = "CL_00000559";

    public static GenLayer[] initializeAllBiomeGenerators(long par0, WorldType worldType) {
        boolean flag = false;
        GenLayerIsland genlayerisland = new GenLayerIsland(1L);
        GenLayerFuzzyZoom genlayerfuzzyzoom = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayerisland);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayerfuzzyzoom);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland);
        genlayerzoom = new GenLayerZoom(2002L, (GenLayer)genlayerremovetoomuchocean);
        genlayerzoom = new GenLayerZoom(2003L, (GenLayer)genlayerzoom);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, genlayeredge, GenLayerEdge.Mode.SPECIAL);
        genlayeraddisland = new GenLayerAddIsland(4L, (GenLayer)genlayeredge);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer3 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int b0 = 4;
        if (worldType == WorldType.field_77135_d) {
            b0 = 6;
        }
        b0 = GenLayer.getModdedBiomeSize(worldType, (byte)b0);
        GenLayer genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer3, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, genlayer);
        GenLayer object = worldType.getBiomeLayer(par0, genlayer3, ChunkGeneratorSettings.Factory.func_177865_a((String)"").func_177864_b());
        GenLayer genlayer1 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        GenLayerHills genlayerhills = new GenLayerHills(1000L, object, genlayer1);
        genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer, (int)b0);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerriver);
        object = new GenLayerRareBiome(1001L, (GenLayer)genlayerhills);
        for (int j = 0; j < b0; ++j) {
            object = new GenLayerZoom((long)(1000 + j), object);
            if (j == 0) {
                object = new GenLayerAddIsland(3L, object);
            }
            if (j != 1) continue;
            object = new GenLayerShore(1000L, object);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, object);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        return new GenLayer[]{genlayerrivermix, genlayervoronoizoom, genlayerrivermix};
    }

    public GenLayer(long par1) {
        this.field_75906_d = par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
        this.field_75906_d *= this.field_75906_d * 6364136223846793005L + 1442695040888963407L;
        this.field_75906_d += par1;
    }

    public void func_75905_a(long par1) {
        this.field_75907_b = par1;
        if (this.field_75909_a != null) {
            this.field_75909_a.func_75905_a(par1);
        }
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
        this.field_75907_b *= this.field_75907_b * 6364136223846793005L + 1442695040888963407L;
        this.field_75907_b += this.field_75906_d;
    }

    public void func_75903_a(long par1, long par3) {
        this.field_75908_c = this.field_75907_b;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par1;
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += par3;
    }

    protected int func_75902_a(int par1) {
        int j = (int)((this.field_75908_c >> 24) % (long)par1);
        if (j < 0) {
            j += par1;
        }
        this.field_75908_c *= this.field_75908_c * 6364136223846793005L + 1442695040888963407L;
        this.field_75908_c += this.field_75907_b;
        return j;
    }

    public abstract int[] func_75904_a(int var1, int var2, int var3, int var4);

    protected static boolean compareBiomesById(final int p_151616_0_, final int p_151616_1_) {
        if (p_151616_0_ == p_151616_1_) {
            return true;
        }
        if (p_151616_0_ != Biome.func_185362_a((Biome)Biomes.field_150608_ab) && p_151616_0_ != Biome.func_185362_a((Biome)Biomes.field_150607_aa)) {
            try {
                return Biome.func_150568_d((int)p_151616_0_) != null && Biome.func_150568_d((int)p_151616_1_) != null ? Biome.func_150568_d((int)p_151616_0_).equals(Biome.func_150568_d((int)p_151616_1_)) : false;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Comparing biomes");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Biomes being compared");
                crashreportcategory.func_71507_a("Biome A ID", (Object)p_151616_0_);
                crashreportcategory.func_71507_a("Biome B ID", (Object)p_151616_1_);
                crashreportcategory.func_71507_a("Biome A", (Object)new Callable(){
                    private static final String __OBFID = "CL_00000560";

                    public String call() {
                        return String.valueOf(Biome.func_150568_d((int)p_151616_0_));
                    }
                });
                crashreportcategory.func_71507_a("Biome B", (Object)new Callable(){
                    private static final String __OBFID = "CL_00000561";

                    public String call() {
                        return String.valueOf(Biome.func_150568_d((int)p_151616_1_));
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return p_151616_1_ == Biome.func_185362_a((Biome)Biomes.field_150607_aa) || p_151616_1_ == Biome.func_185362_a((Biome)Biomes.field_150608_ab);
    }

    protected static boolean func_151618_b(int p_151618_0_) {
        return p_151618_0_ == Biome.func_185362_a((Biome)Biomes.field_76771_b) || p_151618_0_ == Biome.func_185362_a((Biome)Biomes.field_150575_M) || p_151618_0_ == Biome.func_185362_a((Biome)Biomes.field_76776_l);
    }

    protected int func_151619_a(int ... p_151619_1_) {
        return p_151619_1_[this.func_75902_a(p_151619_1_.length)];
    }

    protected int func_151617_b(int p_151617_1_, int p_151617_2_, int p_151617_3_, int p_151617_4_) {
        return p_151617_2_ == p_151617_3_ && p_151617_3_ == p_151617_4_ ? p_151617_2_ : (p_151617_1_ == p_151617_2_ && p_151617_1_ == p_151617_3_ ? p_151617_1_ : (p_151617_1_ == p_151617_2_ && p_151617_1_ == p_151617_4_ ? p_151617_1_ : (p_151617_1_ == p_151617_3_ && p_151617_1_ == p_151617_4_ ? p_151617_1_ : (p_151617_1_ == p_151617_2_ && p_151617_3_ != p_151617_4_ ? p_151617_1_ : (p_151617_1_ == p_151617_3_ && p_151617_2_ != p_151617_4_ ? p_151617_1_ : (p_151617_1_ == p_151617_4_ && p_151617_2_ != p_151617_3_ ? p_151617_1_ : (p_151617_2_ == p_151617_3_ && p_151617_1_ != p_151617_4_ ? p_151617_2_ : (p_151617_2_ == p_151617_4_ && p_151617_1_ != p_151617_3_ ? p_151617_2_ : (p_151617_3_ == p_151617_4_ && p_151617_1_ != p_151617_2_ ? p_151617_3_ : this.func_151619_a(p_151617_1_, p_151617_2_, p_151617_3_, p_151617_4_))))))))));
    }

    public static byte getModdedBiomeSize(WorldType worldType, byte original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, (int)original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return (byte)event.getNewSize();
    }
}

