/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.ConfigReader;
import com.Zeno410Utils.Mutable;
import com.Zeno410Utils.Streamable;
import com.Zeno410Utils.Trackers;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class Settings
implements Streamable,
ConfigReader {
    private ArrayList<Setting> settings = new ArrayList();
    private HashMap<String, Category> categories = new HashMap();

    @Override
    public void readFrom(Configuration source) {
        for (Setting setting : this.settings) {
            setting.readFrom(source);
        }
    }

    public void readForeignConfigs(File generalConfigDirectory) {
    }

    @Override
    public void copyTo(Configuration target) {
        for (Setting setting : this.settings) {
            setting.copyTo(target);
        }
        for (Category category : this.categories.values()) {
            if (category.description().length() <= 0) continue;
            target.addCustomCategoryComment(category.name, category.description());
        }
    }

    @Override
    public void readFrom(DataInput input) throws IOException {
        for (Setting setting : this.settings) {
            setting.readFrom(input);
        }
    }

    @Override
    public void writeTo(DataOutput output) throws IOException {
        for (Setting setting : this.settings) {
            setting.writeTo(output);
        }
    }

    public Category category(String name) {
        Category result = this.categories.get(name);
        if (result != null) {
            return result;
        }
        result = new Category(name);
        this.categories.put(name, result);
        return result;
    }

    public Category category(String name, String description) {
        Category result = this.categories.get(name);
        if (result != null) {
            result.setDescription(description);
            return result;
        }
        result = new Category(name, description);
        this.categories.put(name, result);
        return result;
    }

    public Category general() {
        return this.category("general");
    }

    protected abstract class Setting<Type>
    implements Mutable<Type>,
    Streamable {
        protected boolean set = false;
        protected Type value;
        protected Type defaultValue;
        final Category category;
        final String key;
        final String comment;
        private final Trackers<Type> trackers = new Trackers();

        Setting(Category category, String key, String comment, Type defaultValue) {
            this.category = category;
            this.key = key;
            this.comment = comment;
            this.defaultValue = defaultValue;
            Settings.this.settings.add(this);
        }

        @Override
        public void set(Type newValue) {
            this.value = newValue;
            this.set = true;
        }

        @Override
        public void set(Mutable<Type> copied) {
            this.value = copied.value();
            this.set = true;
        }

        @Override
        public Type value() {
            if (this.value != null) {
                return this.value;
            }
            return this.defaultValue;
        }

        public void update(Type updated) {
            this.trackers.update(updated);
        }

        @Override
        public void informOnChange(Acceptor<Type> toInform) {
            this.trackers.informOnChange(toInform);
        }

        @Override
        public void stopInforming(Acceptor<Type> dontInform) {
            this.trackers.stopInforming(dontInform);
        }

        public boolean hasBeenSet() {
            return this.set;
        }

        public boolean exists(Configuration tested) {
            return tested.hasKey(this.category.name, this.key);
        }

        public void setValue(Property inFile) {
            Type oldValue = this.value();
            this.set = inFile.wasRead();
            if (this.set) {
                try {
                    this.value = this.dataFrom(inFile);
                }
                catch (NullPointerException e) {
                    this.value = this.value();
                }
            } else {
                this.value = this.value();
            }
            if (oldValue == null && this.value() != null) {
                this.update(this.value());
            } else if (!oldValue.equals(this.value())) {
                this.update(this.value());
            }
        }

        public void readFrom(Configuration source) {
            this.setValue(this.propertyFrom(source));
        }

        public abstract Property propertyFrom(Configuration var1);

        public abstract Type dataFrom(Property var1);

        public abstract void copyTo(Configuration var1);
    }

    public class Category {
        public final String name;
        private String description = "";

        public Category(String name) {
            this.name = name;
        }

        public Category(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String description() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Mutable<Boolean> booleanSetting(String key, String comment, boolean defaultValue) {
            return new BooleanSetting(this, key, comment, defaultValue);
        }

        public Mutable<Boolean> booleanSetting(String key, boolean defaultValue, String comment) {
            return new BooleanSetting(this, key, comment, defaultValue);
        }

        public Mutable<Boolean> booleanSetting(String key, boolean defaultValue) {
            return new BooleanSetting(this, key, "", defaultValue);
        }

        public Mutable<Integer> intSetting(String key, Integer defaultValue, String comment) {
            return new IntSetting(this, key, comment, defaultValue);
        }

        public Mutable<Integer> intSetting(String key, Integer defaultValue) {
            return new IntSetting(this, key, "", defaultValue);
        }

        public Mutable<String> stringSetting(String key, String defaultValue, String comment) {
            return new StringSetting(this, key, comment, defaultValue);
        }

        public Mutable<String> stringSetting(String key, String defaultValue) {
            return new StringSetting(this, key, "", defaultValue);
        }

        public Mutable<Double> doubleSetting(String key, Double defaultValue, String comment) {
            return new DoubleSetting(this, key, comment, defaultValue);
        }
    }

    protected class DoubleSetting
    extends Setting<Double> {
        public DoubleSetting(Category category, String key, String comment, Double defaultValue) {
            super(category, key, comment, defaultValue);
        }

        @Override
        public void copyTo(Configuration target) {
            this.propertyFrom(target).set(((Double)this.value()).doubleValue());
        }

        @Override
        public Property propertyFrom(Configuration source) {
            if (this.comment.equals("")) {
                return source.get(this.category.name, this.key, ((Double)this.value()).doubleValue());
            }
            return source.get(this.category.name, this.key, ((Double)this.value()).doubleValue(), this.comment);
        }

        @Override
        public Double dataFrom(Property source) {
            return source.getDouble(((Double)this.value()).doubleValue());
        }

        @Override
        public void readFrom(DataInput input) throws IOException {
            Double oldValue = (Double)this.value();
            this.set = input.readBoolean();
            this.value = input.readDouble();
            this.defaultValue = input.readDouble();
            if (oldValue == null && this.value() != null || !oldValue.equals(this.value())) {
                this.update((Double)this.value());
            }
        }

        @Override
        public void writeTo(DataOutput output) throws IOException {
            output.writeBoolean(this.set);
            output.writeDouble((Double)this.value);
            output.writeDouble((Double)this.defaultValue);
        }
    }

    protected class StringSetting
    extends Setting<String> {
        public StringSetting(Category category, String key, String comment, String defaultValue) {
            super(category, key, comment, defaultValue);
        }

        @Override
        public void copyTo(Configuration target) {
            this.propertyFrom(target).set((String)this.value());
        }

        @Override
        public Property propertyFrom(Configuration source) {
            if (this.comment.equals("")) {
                return source.get(this.category.name, this.key, (String)this.value());
            }
            return source.get(this.category.name, this.key, (String)this.value(), this.comment);
        }

        @Override
        public String dataFrom(Property source) {
            return source.getString();
        }

        @Override
        public void readFrom(DataInput input) throws IOException {
            String oldValue = (String)this.value();
            this.set = input.readBoolean();
            this.value = input.readUTF();
            this.defaultValue = input.readUTF();
            if (oldValue == null && this.value() != null || !oldValue.equals(this.value())) {
                this.update((String)this.value());
            }
        }

        @Override
        public void writeTo(DataOutput output) throws IOException {
            output.writeBoolean(this.set);
            output.writeUTF((String)this.value);
            output.writeUTF((String)this.defaultValue);
        }
    }

    protected class IntSetting
    extends Setting<Integer> {
        public IntSetting(Category category, String key, String comment, Integer defaultValue) {
            super(category, key, comment, defaultValue);
        }

        @Override
        public void copyTo(Configuration target) {
            this.propertyFrom(target).set(((Integer)this.value()).intValue());
        }

        @Override
        public Property propertyFrom(Configuration source) {
            if (this.comment.equals("")) {
                return source.get(this.category.name, this.key, ((Integer)this.value()).intValue());
            }
            return source.get(this.category.name, this.key, ((Integer)this.value()).intValue(), this.comment);
        }

        @Override
        public Integer dataFrom(Property source) {
            return source.getInt(((Integer)this.value()).intValue());
        }

        @Override
        public void readFrom(DataInput input) throws IOException {
            Integer oldValue = (Integer)this.value();
            this.set = input.readBoolean();
            this.value = input.readInt();
            this.defaultValue = input.readInt();
            if (oldValue == null && this.value() != null || !oldValue.equals(this.value())) {
                this.update((Integer)this.value());
            }
        }

        @Override
        public void writeTo(DataOutput output) throws IOException {
            output.writeBoolean(this.set);
            output.writeInt((Integer)this.value);
            output.writeInt((Integer)this.defaultValue);
        }
    }

    protected class BooleanSetting
    extends Setting<Boolean> {
        public BooleanSetting(Category category, String key, String comment, boolean defaultValue) {
            super(category, key, comment, defaultValue);
        }

        @Override
        public void copyTo(Configuration target) {
            this.propertyFrom(target).set(((Boolean)this.value()).booleanValue());
        }

        @Override
        public Property propertyFrom(Configuration source) {
            if (this.comment.equals("")) {
                return source.get(this.category.name, this.key, ((Boolean)this.value()).booleanValue());
            }
            return source.get(this.category.name, this.key, ((Boolean)this.value()).booleanValue(), this.comment);
        }

        @Override
        public Boolean dataFrom(Property source) {
            return source.getBoolean(((Boolean)this.value()).booleanValue());
        }

        @Override
        public void readFrom(DataInput input) throws IOException {
            Boolean oldValue = (Boolean)this.value();
            this.set = input.readBoolean();
            this.value = input.readBoolean();
            this.defaultValue = input.readBoolean();
            if (oldValue == null && this.value() != null || !oldValue.equals(this.value())) {
                this.update((Boolean)this.value());
            }
        }

        @Override
        public void writeTo(DataOutput output) throws IOException {
            output.writeBoolean(this.set);
            output.writeBoolean((Boolean)this.value);
            output.writeBoolean((Boolean)this.defaultValue);
        }

        @Override
        public void set(Mutable<Boolean> toCopy) {
            this.set(toCopy.value());
        }
    }
}

