/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.Maker;
import com.Zeno410Utils.SelfTrackable;
import com.Zeno410Utils.Streamer;
import com.Zeno410Utils.Trackers;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;

public class ReservationNumbers
implements SelfTrackable<ReservationNumbers> {
    private Trackers<ReservationNumbers> trackers = new Trackers();
    private HashSet<Integer> availableNumbers = new HashSet();
    private HashSet<Integer> reservedNumbers = new HashSet();

    @Override
    public void informOnChange(Acceptor<ReservationNumbers> target) {
        this.trackers.informOnChange(target);
    }

    @Override
    public void stopInforming(Acceptor<ReservationNumbers> target) {
        this.trackers.stopInforming(target);
    }

    private String numberStatus() {
        String result = "";
        result = result + "reserved ";
        for (Integer reserved : this.reservedNumbers) {
            result = result + " " + reserved;
        }
        for (Integer available : this.availableNumbers) {
            result = result + " " + available;
        }
        return result;
    }

    public void release(Integer released) {
        if (!this.reservedNumbers.contains(released)) {
            throw new MissingException(released);
        }
        this.reservedNumbers.remove(released);
        this.availableNumbers.add(released);
        this.trackers.update(this);
    }

    public Integer reserve(Maker<Integer> ifNothingAvailable) {
        Integer result;
        if (this.availableNumbers.size() > 0) {
            result = this.availableNumbers.iterator().next();
            this.availableNumbers.remove(result);
        } else {
            result = ifNothingAvailable.item();
        }
        this.reservedNumbers.add(result);
        this.trackers.update(this);
        return result;
    }

    public void use(Integer used) {
        if (!this.reservedNumbers.contains(used)) {
            throw new MissingException(used);
        }
        this.reservedNumbers.remove(used);
        this.trackers.update(this);
    }

    public void setUnavailable(Integer unavailable) {
        if (this.availableNumbers.contains(unavailable)) {
            this.availableNumbers.remove(unavailable);
        }
    }

    public static Streamer<ReservationNumbers> streamer() {
        return new ReservationNumberStreamer();
    }

    public static class MissingException
    extends RuntimeException {
        public final Integer missingNumber;

        MissingException(Integer missingNumber) {
            this.missingNumber = missingNumber;
        }
    }

    private static class ReservationNumberStreamer
    extends Streamer<ReservationNumbers> {
        private ReservationNumberStreamer() {
        }

        @Override
        public ReservationNumbers readFrom(DataInput input) throws IOException {
            ReservationNumbers result = new ReservationNumbers();
            int available = input.readInt();
            for (int i = 0; i < available; ++i) {
                int number = input.readInt();
                result.availableNumbers.add(number);
            }
            return result;
        }

        @Override
        public void writeTo(ReservationNumbers written, DataOutput output) throws IOException {
            output.writeInt(written.availableNumbers.size() + written.reservedNumbers.size());
            for (Integer number : written.availableNumbers) {
                output.writeInt(number);
            }
            for (Integer number : written.reservedNumbers) {
                output.writeInt(number);
            }
        }
    }
}

