/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyManager {
    private final Properties properties = new Properties();
    private final File associatedFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyManager(File par1File) {
        this.associatedFile = par1File;
        if (par1File.exists()) {
            FileInputStream fileinputstream = null;
            try {
                fileinputstream = new FileInputStream(par1File);
                this.properties.load(fileinputstream);
            }
            catch (Exception exception) {
                this.logMessageAndSave();
            }
            finally {
                if (fileinputstream != null) {
                    try {
                        fileinputstream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            this.logMessageAndSave();
        }
    }

    public void logMessageAndSave() {
        this.saveProperties();
    }

    public void saveProperties() {
        FileOutputStream fileoutputstream = null;
        try {
            fileoutputstream = new FileOutputStream(this.associatedFile);
            this.properties.store(fileoutputstream, "Minecraft server properties");
        }
        catch (Exception exception) {
            this.logMessageAndSave();
        }
        finally {
            if (fileoutputstream != null) {
                try {
                    fileoutputstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getPropertiesFile() {
        return this.associatedFile;
    }

    public String getProperty(String par1Str, String par2Str) {
        if (!this.properties.containsKey(par1Str)) {
            this.properties.setProperty(par1Str, par2Str);
            this.saveProperties();
        }
        return this.properties.getProperty(par1Str, par2Str);
    }

    public int getIntProperty(String par1Str, int par2) {
        try {
            return Integer.parseInt(this.getProperty(par1Str, "" + par2));
        }
        catch (Exception exception) {
            this.properties.setProperty(par1Str, "" + par2);
            return par2;
        }
    }

    public boolean getBooleanProperty(String par1Str, boolean par2) {
        try {
            return Boolean.parseBoolean(this.getProperty(par1Str, "" + par2));
        }
        catch (Exception exception) {
            this.properties.setProperty(par1Str, "" + par2);
            return par2;
        }
    }

    public void setProperty(String par1Str, Object par2Obj) {
        this.properties.setProperty(par1Str, "" + par2Obj);
    }
}

