/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Accessor;
import com.Zeno410Utils.Zeno410Logger;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.commons.Remapper;

public class ObfuscatedAccessor<ObjectType, FieldType>
extends Accessor<ObjectType, FieldType> {
    private Accessor<Remapper, Map<String, Map<String, String>>> fieldAccessor = new Accessor("fieldNameMaps");
    public static Logger logger = new Zeno410Logger("ObfuscatedAccessor").logger();
    Remapper remapper;
    private Accessor<ObjectType, FieldType> deobfuscated;
    private final String fieldName;
    private String deobfuscatedName;

    public ObfuscatedAccessor(String _fieldName) {
        super(_fieldName);
        this.fieldName = _fieldName;
    }

    private Accessor<ObjectType, FieldType> getDeobfuscated(ObjectType objectType) {
        Class<?> objectClass = objectType.getClass();
        Set obfedClasses = FMLDeobfuscatingRemapper.INSTANCE.getObfedClasses();
        for (String readableName : obfedClasses) {
            String obfedName = FMLDeobfuscatingRemapper.INSTANCE.map(readableName);
            logger.info(readableName + " to " + obfedName);
            this.remapper = FMLDeobfuscatingRemapper.INSTANCE;
            Map<String, String> fieldMap = this.fieldAccessor.get(this.remapper).get(readableName);
            if (fieldMap == null) continue;
            for (String key : fieldMap.keySet()) {
                logger.info("     " + key + " " + fieldMap.get(key));
            }
        }
        while (objectClass != null && objectClass != Object.class) {
            String deobfuscatedClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(objectClass.getCanonicalName());
            if (deobfuscatedClassName == null || deobfuscatedClassName.equals("")) continue;
            this.deobfuscatedName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(deobfuscatedClassName, this.fieldName, this.fieldName);
            this.deobfuscated = new Accessor(this.deobfuscatedName);
        }
        throw new RuntimeException("Could not remap field " + this.fieldName + " in class " + objectType.getClass().getCanonicalName());
    }

    private Accessor<ObjectType, FieldType> deobfuscated(ObjectType objectType) {
        if (this.deobfuscated == null) {
            this.deobfuscated = this.getDeobfuscated(objectType);
        }
        return this.deobfuscated;
    }

    @Override
    public FieldType get(ObjectType object) {
        return this.deobfuscated(object).get(object);
    }

    @Override
    public void setField(ObjectType object, FieldType fieldValue) {
        this.deobfuscated(object).setField(object, fieldValue);
    }
}

