/*
 * Decompiled with CFR 0.152.
 */
package climateControl.generator;

import climateControl.api.BiomeSettings;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateControlSettings;
import climateControl.customGenLayer.GenLayerBiomeByClimate;
import climateControl.customGenLayer.GenLayerRandomBiomes;
import climateControl.customGenLayer.GenLayerShoreCC;
import climateControl.customGenLayer.GenLayerSmoothClimate;
import climateControl.customGenLayer.GenLayerSubBiome;
import climateControl.genLayerPack.GenLayerAddIsland;
import climateControl.genLayerPack.GenLayerHillsOneSix;
import climateControl.genLayerPack.GenLayerOneSixBiome;
import climateControl.genLayerPack.GenLayerRareBiome;
import climateControl.genLayerPack.GenLayerRiver;
import climateControl.genLayerPack.GenLayerRiverInit;
import climateControl.genLayerPack.GenLayerSmooth;
import climateControl.genLayerPack.GenLayerSwampRivers;
import climateControl.genLayerPack.GenLayerVoronoiZoom;
import climateControl.genLayerPack.GenLayerZoom;
import climateControl.generator.BiomeSwapper;
import climateControl.generator.SubBiomeChooser;
import climateControl.generator.VillageBiomes;
import com.Zeno410Utils.Accessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.structure.MapGenVillage;

public abstract class AbstractWorldGenerator {
    private final ClimateControlSettings settings;
    protected final SubBiomeChooser subBiomeChooser = new SubBiomeChooser();
    protected final BiomeSwapper mBiomeChooser = new BiomeSwapper();
    private ClimateControlRules rules;

    public ClimateControlSettings settings() {
        return this.settings;
    }

    public AbstractWorldGenerator(ClimateControlSettings settings) {
        this.settings = settings;
        this.setRules();
    }

    protected GenLayer smoothClimates(ClimateControlSettings settings, long worldSeed, GenLayer parent, long masterSeed) {
        return new GenLayerSmoothClimate(masterSeed, parent, settings);
    }

    protected ClimateControlRules rules() {
        return this.rules;
    }

    protected void setRules() {
        ClimateControlRules newRules = new ClimateControlRules();
        Accessor<Biome, Float> biomeTemperature = new Accessor<Biome, Float>("field_76750_F");
        if (this.settings.complexSubbiomes.value().booleanValue()) {
            newRules.setComplexSubBiomes();
            biomeTemperature.setField(Biomes.field_76770_e, Float.valueOf(0.24f));
            biomeTemperature.setField(Biomes.field_76783_v, Float.valueOf(0.24f));
            biomeTemperature.setField(Biomes.field_150580_W, Float.valueOf(0.24f));
            biomeTemperature.setField(Biomes.field_185443_S, Float.valueOf(0.24f));
            biomeTemperature.setField(Biomes.field_185434_af, Float.valueOf(0.24f));
        } else {
            biomeTemperature.setField(Biomes.field_76770_e, Float.valueOf(0.2f));
            biomeTemperature.setField(Biomes.field_76783_v, Float.valueOf(0.2f));
            biomeTemperature.setField(Biomes.field_150580_W, Float.valueOf(0.2f));
            biomeTemperature.setField(Biomes.field_185443_S, Float.valueOf(0.2f));
            biomeTemperature.setField(Biomes.field_185434_af, Float.valueOf(0.2f));
        }
        for (BiomeSettings biomeSettings : this.settings().biomeSettings()) {
            biomeSettings.setRules(newRules);
        }
        ArrayList<Biome> villageSpawnBiomes = new ArrayList<Biome>();
        for (int i = 0; i < 256; ++i) {
            if (!newRules.hasVillages(i)) continue;
            villageSpawnBiomes.add(Biome.func_150568_d((int)i));
        }
        VillageBiomes villageBiomes = new VillageBiomes((List<Biome>)villageSpawnBiomes);
        villageBiomes.reportMembers();
        if (this.settings.controlVillageBiomes.value().booleanValue()) {
            MapGenVillage.field_75055_e = villageBiomes;
        }
        this.rules = newRules;
    }

    abstract GenLayerRiverMix fromSeed(long var1, WorldType var3);

    public int rtgAwareRiverReduction(int baseReduction, WorldType worldType) {
        if (worldType.func_77127_a().equalsIgnoreCase("RTG")) {
            return 100;
        }
        return baseReduction;
    }

    public GenLayerRiverMix vanillaExpansion(long worldSeed, WorldType par2WorldType, GenLayer genlayer3, ClimateControlSettings settings) {
        if (settings.oneSixCompatibility.value().booleanValue()) {
            return this.oneSixExpansion(worldSeed, par2WorldType, genlayer3, settings);
        }
        return this.oneSevenExpansion(worldSeed, par2WorldType, genlayer3, settings);
    }

    public GenLayerRiverMix oneSevenExpansion(long worldSeed, WorldType par2WorldType, GenLayer genlayer3, ClimateControlSettings settings) {
        int b0 = this.settings().biomeSize.value().byteValue();
        GenLayer genlayer = GenLayerZoom.magnify(1000L, genlayer3, 0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, genlayer);
        GenLayer object = null;
        object = this.settings().randomBiomes.value() != false ? new GenLayerRandomBiomes(worldSeed, genlayer3, settings) : new GenLayerBiomeByClimate(worldSeed, genlayer3, settings);
        ((GenLayer)object).func_75905_a(worldSeed);
        object = GenLayerZoom.magnify(1000L, object, 2);
        object = new GenLayerBiomeEdge(1000L, object);
        GenLayer genlayer1 = GenLayerZoom.magnify(1000L, genlayerriverinit, 2);
        for (BiomeSettings setting : settings.biomeSettings()) {
            genlayer1 = setting.subBiomeEdges(1030L, genlayer1, settings.maximumBiomes());
        }
        GenLayerSubBiome genlayerhills = new GenLayerSubBiome(1000L, object, genlayer1, this.subBiomeChooser, this.mBiomeChooser, this.settings().doBoPSubBiomes());
        ((GenLayer)genlayerhills).func_75905_a(worldSeed);
        genlayer = GenLayerZoom.magnify(1000L, genlayerriverinit, 2);
        genlayer = GenLayerZoom.magnify(1000L, genlayer, b0);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayerriver);
        object = new GenLayerRareBiome(1001L, genlayerhills);
        for (int j = 0; j < b0; ++j) {
            object = new GenLayerZoom(1000 + j, object);
            if (j == 0) {
                for (BiomeSettings setting : settings.biomeSettings()) {
                    object = setting.subBiomeEdges(1030L, object, settings.maximumBiomes());
                }
                object = new GenLayerAddIsland(3L, object);
            }
            if (j != 1) continue;
            object = new GenLayerShoreCC(1000L, object, this.rules);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, object);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(worldSeed);
        genlayervoronoizoom.func_75905_a(worldSeed);
        genlayerrivermix.func_75905_a(worldSeed);
        genlayervoronoizoom.func_75905_a(worldSeed);
        return genlayerrivermix;
    }

    public GenLayerRiverMix oneSixExpansion(long worldSeed, WorldType par2WorldType, GenLayer genlayeraddmushroomisland, ClimateControlSettings settings) {
        int b0 = this.settings().biomeSize.value().byteValue();
        GenLayer genlayer = GenLayerZoom.magnify(1000L, genlayeraddmushroomisland, 0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, genlayer);
        genlayer = GenLayerZoom.magnify(1000L, genlayerriverinit, b0 + 2);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayerriver);
        GenLayer genlayer1 = GenLayerZoom.magnify(1000L, genlayeraddmushroomisland, 0);
        GenLayerOneSixBiome genlayerbiome = new GenLayerOneSixBiome(200L, genlayer1, WorldType.field_77137_b);
        genlayer1 = GenLayerZoom.magnify(1000L, genlayerbiome, 2);
        GenLayer object = new GenLayerHillsOneSix(1000L, genlayer1);
        for (int j = 0; j < b0; ++j) {
            object = new GenLayerZoom(1000 + j, object);
            if (j == 0) {
                object = new GenLayerAddIsland(3L, object);
            }
            if (j == 1) {
                object = new GenLayerShoreCC(1000L, object, this.rules);
            }
            if (j != 1) continue;
            object = new GenLayerSwampRivers(1000L, object);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, object);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(worldSeed);
        genlayervoronoizoom.func_75905_a(worldSeed);
        return genlayerrivermix;
    }
}

