/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import biomesoplenty.common.init.ModBiomes;
import climateControl.ClimateControl;
import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.biomeSettings.OceanBiomeSettings;
import climateControl.biomeSettings.VanillaBiomeSettings;
import climateControl.customGenLayer.GenLayerBopBiomeEdge;
import climateControl.generator.SubBiomeChooser;
import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.Mutable;
import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;

public class BoPSettings
extends BiomeSettings {
    public final BiomeSettings.Element alps;
    public final BiomeSettings.Element alpsFoothills;
    public final BiomeSettings.Element bambooForest;
    public final BiomeSettings.Element bayou;
    public final BiomeSettings.Element bog;
    public final BiomeSettings.Element borealForest;
    public final BiomeSettings.Element brushland;
    public final BiomeSettings.Element chaparral;
    public final BiomeSettings.Element cherryBlossomGrove;
    public final BiomeSettings.Element coldDesert;
    public final BiomeSettings.Element coniferousForest;
    public final BiomeSettings.Element coralReef;
    public final BiomeSettings.Element crag;
    public final BiomeSettings.Element deadForest;
    public final BiomeSettings.Element deadSwamp;
    public final BiomeSettings.Element eucalyptusForest;
    public final BiomeSettings.Element fen;
    public final BiomeSettings.Element flowerField;
    public final BiomeSettings.Element flowerIsland;
    public final BiomeSettings.Element glacier;
    public final BiomeSettings.Element grassland;
    public final BiomeSettings.ID gravelBeach;
    public final BiomeSettings.Element grove;
    public final BiomeSettings.Element highland;
    public final BiomeSettings.Element kelpForest;
    public final BiomeSettings.Element landOfLakes;
    public final BiomeSettings.Element lavenderFields;
    public final BiomeSettings.Element lushDesert;
    public final BiomeSettings.Element lushSwamp;
    public final BiomeSettings.Element mangrove;
    public final BiomeSettings.Element mapleWoods;
    public final BiomeSettings.Element marsh;
    public final BiomeSettings.Element meadow;
    public final BiomeSettings.Element moor;
    public final BiomeSettings.Element mountain;
    public final BiomeSettings.Element mountainFoothills;
    public final BiomeSettings.Element mysticGrove;
    public final BiomeSettings.ID oasis;
    public final BiomeSettings.Element ominousWoods;
    public final BiomeSettings.Element orchard;
    public final BiomeSettings.Element originVally;
    public final BiomeSettings.Element outback;
    public final BiomeSettings.Element overgrownCliffs;
    public final BiomeSettings.Element pasture;
    public final BiomeSettings.Element prairie;
    public final BiomeSettings.Element quagmire;
    public final BiomeSettings.Element rainforest;
    public final BiomeSettings.Element redwoodForest;
    public final BiomeSettings.Element redwoodForestEdge;
    public final BiomeSettings.Element sacredSprings;
    public final BiomeSettings.Element seasonalForest;
    public final BiomeSettings.Element shield;
    public final BiomeSettings.Element shrubland;
    public final BiomeSettings.Element snowyConiferousForest;
    public final BiomeSettings.Element snowyForest;
    public final BiomeSettings.Element snowyTundra;
    public final BiomeSettings.Element steppe;
    public final BiomeSettings.Element temperateRainforest;
    public final BiomeSettings.Element tropicalRainforest;
    public final BiomeSettings.Element tropicalIslands;
    public final BiomeSettings.Element tundra;
    public final BiomeSettings.Element volcano;
    public final BiomeSettings.Element wasteland;
    public final BiomeSettings.Element wetland;
    public final BiomeSettings.Element woodland;
    public final BiomeSettings.Element xericShrubland;
    Acceptor<Integer> crashOnZero;
    Acceptor<Integer> crashOnNegative;
    private HashMap<BiomeSettings.ID, BiomeReplacer.Variable> subBiomeSets;
    static final String biomesOnName = "BoPBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "BoP";
    public final Mutable<Boolean> biomesInNewWorlds;

    public BoPSettings() {
        super(configName);
        this.alps = new BiomeSettings.Element((BiomeSettings)this, "Alps", 5, false, Climate.SNOWY.name, "biomesoplenty:alps", "none");
        this.alpsFoothills = new BiomeSettings.Element((BiomeSettings)this, "Alps Foothills", 0, false, Climate.SNOWY.name, "biomesoplenty:alps_foothills", "none");
        this.bambooForest = new BiomeSettings.Element((BiomeSettings)this, "Bamboo Forest", 5, true, "WARM", "biomesoplenty:bamboo_forest", "none");
        this.bayou = new BiomeSettings.Element((BiomeSettings)this, "Bayou", 10, true, "WARM", "biomesoplenty:bayou", "none");
        this.bog = new BiomeSettings.Element((BiomeSettings)this, "Bog", 7, true, "COOL", "biomesoplenty:bog", "biomesoplenty:gravel_beach");
        this.borealForest = new BiomeSettings.Element((BiomeSettings)this, "Boreal Forest", 10, false, "COOL", "biomesoplenty:boreal_forest", "biomesoplenty:gravel_beach");
        this.brushland = new BiomeSettings.Element((BiomeSettings)this, "Brushland", 7, true, "WARM", "biomesoplenty:brushland");
        this.chaparral = new BiomeSettings.Element((BiomeSettings)this, "Chaparral", 10, true, "WARM", "biomesoplenty:chaparral");
        this.cherryBlossomGrove = new BiomeSettings.Element((BiomeSettings)this, "Cherry Blossom Grove", 3, true, "COOL", "biomesoplenty:cherry_blossom_grove");
        this.coldDesert = new BiomeSettings.Element((BiomeSettings)this, "Cold Desert", 10, true, "SNOWY", "biomesoplenty:cold_desert", "minecraft:cold_beach");
        this.coniferousForest = new BiomeSettings.Element((BiomeSettings)this, "Coniferous Forest", 10, false, "WARM", "biomesoplenty:coniferous_forest");
        this.coralReef = new BiomeSettings.Element((BiomeSettings)this, "Coral Reef", 3, false, "OCEAN", "biomesoplenty:coral_reef", false);
        this.crag = new BiomeSettings.Element((BiomeSettings)this, "Crag", 3, false, "MEDIUM", "biomesoplenty:crag", "none");
        this.deadForest = new BiomeSettings.Element((BiomeSettings)this, "Dead Forest", 7, true, "COOL", "biomesoplenty:dead_forest", "biomesoplenty:gravel_beach");
        this.deadSwamp = new BiomeSettings.Element((BiomeSettings)this, "Dead Swamp", 7, true, "WARM", "biomesoplenty:dead_swamp", "none");
        this.eucalyptusForest = new BiomeSettings.Element((BiomeSettings)this, "Eucalyptus Forest", 5, false, "WARM", "biomesoplenty:eucalyptus_forest");
        this.fen = new BiomeSettings.Element((BiomeSettings)this, "Fen", 5, true, "WARM", "biomesoplenty:fen", "biomesoplenty:gravel_beach");
        this.flowerField = new BiomeSettings.Element((BiomeSettings)this, "Flower Field", 3, true, "WARM", "biomesoplenty:flower_field");
        this.flowerIsland = new BiomeSettings.Element((BiomeSettings)this, "Flower Island", 1, true, "DEEP_OCEAN", "biomesoplenty:flower_island");
        this.glacier = new BiomeSettings.Element((BiomeSettings)this, "Glacier", 0, false, "SNOWY", "biomesoplenty:glacier", "none");
        this.grassland = new BiomeSettings.Element((BiomeSettings)this, "Grassland", 5, false, "COOL", "biomesoplenty:grassland", "biomesoplenty:gravel_beach");
        this.gravelBeach = new BiomeSettings.ID((BiomeSettings)this, "Gravel Beach", "biomesoplenty:gravel_beach", false);
        this.grove = new BiomeSettings.Element((BiomeSettings)this, "Grove", 5, false, "COOL", "biomesoplenty:grove");
        this.highland = new BiomeSettings.Element((BiomeSettings)this, "Highland", 5, false, "COOL", "biomesoplenty:highland", "none");
        this.kelpForest = new BiomeSettings.Element((BiomeSettings)this, "Kelp Forest", 0, false, "OCEAN", "biomesoplenty:kelp_forest", false);
        this.landOfLakes = new BiomeSettings.Element((BiomeSettings)this, "Land of Lakes", 7, false, "COOL", "biomesoplenty:land_of_lakes");
        this.lavenderFields = new BiomeSettings.Element((BiomeSettings)this, "Lavender Fields", 3, true, "WARM", "biomesoplenty:lavender_fields");
        this.lushDesert = new BiomeSettings.Element((BiomeSettings)this, "Lush Desert", 3, true, "HOT", "biomesoplenty:lush_desert");
        this.lushSwamp = new BiomeSettings.Element((BiomeSettings)this, "Lush Swamp", 5, true, "WARM", "biomesoplenty:lush_swamp", "none");
        this.mangrove = new BiomeSettings.Element((BiomeSettings)this, "Mangrove", 3, false, "WARM", "biomesoplenty:mangrove", "none");
        this.mapleWoods = new BiomeSettings.Element((BiomeSettings)this, "Maple Woods", 5, false, "COOL", "biomesoplenty:maple_woods", "biomesoplenty:gravel_beach");
        this.marsh = new BiomeSettings.Element((BiomeSettings)this, "Marsh", 7, true, "COOL", "biomesoplenty:marsh", "none");
        this.meadow = new BiomeSettings.Element((BiomeSettings)this, "Meadow", 5, true, "COOL", "biomesoplenty:meadow", "biomesoplenty:gravel_beach");
        this.moor = new BiomeSettings.Element((BiomeSettings)this, "Moor", 5, true, "COOL", "biomesoplenty:moor", "none");
        this.mountain = new BiomeSettings.Element((BiomeSettings)this, "Mountain", 8, false, "WARM", "biomesoplenty:mountain", "none");
        this.mountainFoothills = new BiomeSettings.Element((BiomeSettings)this, "Mountain Foothills", 0, false, "WARM", "biomesoplenty:mountain_foothills", "none");
        this.mysticGrove = new BiomeSettings.Element((BiomeSettings)this, "Mystic Grove", 3, false, "MEDIUM", "biomesoplenty:mystic_grove");
        this.oasis = new BiomeSettings.ID((BiomeSettings)this, "Oasis", "biomesoplenty:oasis", "");
        this.ominousWoods = new BiomeSettings.Element((BiomeSettings)this, "Ominous Woods", 3, false, "COOL", "biomesoplenty:ominous_woods", "none");
        this.orchard = new BiomeSettings.Element((BiomeSettings)this, "Orchard", 5, true, ClimateDistribution.MEDIUM.name(), "biomesoplenty:orchard");
        this.originVally = new BiomeSettings.Element((BiomeSettings)this, "Origin Valley", 1, false, "MEDIUM", "biomesoplenty:origin_island");
        this.outback = new BiomeSettings.Element((BiomeSettings)this, "Outback", 7, true, "HOT", "biomesoplenty:outback", "none");
        this.overgrownCliffs = new BiomeSettings.Element((BiomeSettings)this, "Overgrown Cliffs", 7, true, ClimateDistribution.MEDIUM.name(), "biomesoplenty:overgrown_cliffs", "none");
        this.pasture = new BiomeSettings.Element((BiomeSettings)this, "Pasture", 7, true, "WARM", "biomesoplenty:pasture");
        this.prairie = new BiomeSettings.Element((BiomeSettings)this, "Prairie", 7, true, "WARM", "biomesoplenty:prairie");
        this.quagmire = new BiomeSettings.Element((BiomeSettings)this, "Quagmire", 3, false, "COOL", "biomesoplenty:rainforest", "none");
        this.rainforest = new BiomeSettings.Element((BiomeSettings)this, "Rainforest", 5, false, "WARM", "biomesoplenty:rainforest", "none");
        this.redwoodForest = new BiomeSettings.Element((BiomeSettings)this, "Redwood Forest", 7, false, "COOL", "biomesoplenty:redwood_forest");
        this.redwoodForestEdge = new BiomeSettings.Element((BiomeSettings)this, "Redwood Forest Edge", 0, true, "COOL", "biomesoplenty:redwood_forest_edge");
        this.sacredSprings = new BiomeSettings.Element((BiomeSettings)this, "Sacred Springs", 3, false, ClimateDistribution.MEDIUM.name(), "biomesoplenty:sacred_springs", "none");
        this.seasonalForest = new BiomeSettings.Element((BiomeSettings)this, "Seasonal Forest", 7, true, "COOL", "biomesoplenty:seasonal_forest", "biomesoplenty:gravel_beach");
        this.shield = new BiomeSettings.Element((BiomeSettings)this, "Shield", 7, false, "COOL", "biomesoplenty:shield", "biomesoplenty:gravel_beach");
        this.shrubland = new BiomeSettings.Element((BiomeSettings)this, "Shrubland", 5, true, "COOL", "biomesoplenty:shrubland", "biomesoplenty:gravel_beach");
        this.snowyConiferousForest = new BiomeSettings.Element((BiomeSettings)this, "Snowy Coniferous Forest", 5, false, "SNOWY", "biomesoplenty:snowy_coniferous_forest");
        this.snowyForest = new BiomeSettings.Element((BiomeSettings)this, "Snowy Forest", 7, false, "SNOWY", "biomesoplenty:snowy_forest");
        this.snowyTundra = new BiomeSettings.Element((BiomeSettings)this, "Snowy Tundra", 7, false, "SNOWY", "biomesoplenty:snowy_tundra", "minecraft:cold_beach");
        this.steppe = new BiomeSettings.Element((BiomeSettings)this, "Steppe", 7, true, Climate.COOL.name, "biomesoplenty:steppe", "biomesoplenty:gravel_beach");
        this.temperateRainforest = new BiomeSettings.Element((BiomeSettings)this, "Temperate Rainforest", 5, true, "WARM", "biomesoplenty:temperate_rainforest", "biomesoplenty:gravel_beach");
        this.tropicalRainforest = new BiomeSettings.Element((BiomeSettings)this, "Tropical Rainforest", 5, true, "HOT", "biomesoplenty:tropical_rainforest");
        this.tropicalIslands = new BiomeSettings.Element((BiomeSettings)this, "Tropical Islands", 1, true, "DEEP_OCEAN", "biomesoplenty:tropical_island", "biomesoplenty:white_beach");
        this.tundra = new BiomeSettings.Element((BiomeSettings)this, "Tundra", 7, true, "SNOWY", "biomesoplenty:tundra", "biomesoplenty:gravel_beach");
        this.volcano = new BiomeSettings.Element((BiomeSettings)this, "Volcanic Island", 1, false, "DEEP_OCEAN", "biomesoplenty:volcanic_island", "none");
        this.wasteland = new BiomeSettings.Element((BiomeSettings)this, "Wasteland", 3, false, "HOT", "biomesoplenty:wasteland", "biomesoplenty:gravel_beach");
        this.wetland = new BiomeSettings.Element((BiomeSettings)this, "Wetland", 7, false, "WARM", "biomesoplenty:wetland", "none");
        this.woodland = new BiomeSettings.Element((BiomeSettings)this, "Woodland", 5, false, "WARM", "biomesoplenty:woodland", "biomesoplenty:gravel_beach");
        this.xericShrubland = new BiomeSettings.Element((BiomeSettings)this, "Xeric Shrubland", 5, true, "HOT", "biomesoplenty:xeric_shrubland");
        this.crashOnZero = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket incidence " + accepted);
            }
        };
        this.crashOnNegative = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket ID " + accepted);
            }
        };
        this.subBiomeSets = new HashMap();
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    @Override
    public boolean activeIn(WorldType worldType) {
        ClimateControl.logger.info("Checking for Bop in " + worldType.func_77127_a());
        if (worldType.func_77127_a().equalsIgnoreCase("BIOMESOP")) {
            return true;
        }
        return worldType.func_77127_a().equalsIgnoreCase("RTG");
    }

    private int bopID(Optional<Biome> bopBiome) {
        try {
            return Biome.func_185362_a((Biome)((Biome)bopBiome.get()));
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        super.setNativeBiomeIDs(configDirectory);
    }

    public BiomeReplacer.Variable getCommonSubBiome(BiomeSettings.ID biome) {
        List subBiomeIds = (List)ModBiomes.subBiomesMap.get(biome.biomeID());
        BiomeReplacer.Variable result = new BiomeReplacer.Variable();
        if (subBiomeIds == null || subBiomeIds.size() == 0) {
            result.add(biome, 1);
        } else {
            int n = subBiomeIds.size();
            for (int i = 0; i < n; ++i) {
                result.add(biome, 1);
                result.addByNumber((Integer)subBiomeIds.get(i), 1);
            }
        }
        return result;
    }

    private BiomeReplacer.Variable subBiomeSet(BiomeSettings.ID biome) {
        BiomeReplacer.Variable result = this.subBiomeSets.get(biome);
        if (result == null) {
            result = this.getCommonSubBiome(biome);
            this.subBiomeSets.put(biome, result);
        }
        return result;
    }

    private void addSubBiome(BiomeSettings.ID biome, BiomeSettings.ID subBiome) {
        if (subBiome.active()) {
            this.subBiomeSet(biome).add(subBiome, 1);
            biome.setSubBiomeChooser(this.subBiomeSet(biome));
        }
    }

    @Override
    public void arrangeInteractions(ArrayList<BiomeSettings> biomeSettings) {
        this.subBiomeSets = new HashMap();
        for (BiomeSettings biomeSetting : biomeSettings) {
            BiomeReplacer desertReplacer;
            BiomeReplacer.Variable newReplacer;
            if (biomeSetting instanceof OceanBiomeSettings) {
                OceanBiomeSettings oceanSettings = (OceanBiomeSettings)biomeSetting;
                BiomeReplacer oldReplacer = oceanSettings.coastalOcean.subBiomeChooser();
                newReplacer = new BiomeReplacer.Variable();
                if (this.coralReef.active()) {
                    newReplacer.add(this.coralReef, 1);
                    newReplacer.add(oceanSettings.coastalOcean, 1);
                }
                if (this.kelpForest.active()) {
                    newReplacer.add(this.kelpForest, 1);
                    newReplacer.add(oceanSettings.coastalOcean, 1);
                }
                if (this.coralReef.active() || this.kelpForest.active()) {
                    oceanSettings.coastalOcean.setSubBiomeChooser(newReplacer);
                }
            }
            if (!(biomeSetting instanceof VanillaBiomeSettings)) continue;
            VanillaBiomeSettings vanillaSettings = (VanillaBiomeSettings)biomeSetting;
            BiomeReplacer icePlainsReplacer = vanillaSettings.icePlains.subBiomeChooser();
            if (icePlainsReplacer instanceof BiomeReplacer.Fixed) {
                newReplacer = new BiomeReplacer.Variable();
                newReplacer.add(this.glacier, 1);
                newReplacer.add(vanillaSettings.iceMountains, 1);
                vanillaSettings.icePlains.setSubBiomeChooser(newReplacer);
            }
            if (!((desertReplacer = vanillaSettings.desert.subBiomeChooser()) instanceof BiomeReplacer.Fixed)) continue;
            BiomeReplacer.Variable newReplacer2 = new BiomeReplacer.Variable();
            newReplacer2.add(this.oasis, 1);
            newReplacer2.add(vanillaSettings.desertHills, 3);
            vanillaSettings.desert.setSubBiomeChooser(newReplacer2);
        }
    }

    @Override
    public void update(SubBiomeChooser subBiomeChooser) {
        super.update(subBiomeChooser);
        for (BiomeSettings.Element element : this.elements()) {
            subBiomeChooser.set(element.biomeID().value(), this.subBiomeSet(element));
        }
    }

    @Override
    public void setRules(ClimateControlRules rules) {
        super.setRules(rules);
        rules.noBeaches(this.coralReef.biomeID().value());
        rules.noBeaches(this.kelpForest.biomeID().value());
        rules.disallowRivers(this.alps.biomeID().value());
        rules.disallowRivers(this.alpsFoothills.biomeID().value());
        rules.disallowRivers(this.mountain.biomeID().value());
        rules.disallowRivers(this.mountainFoothills.biomeID().value());
        rules.disallowRivers(this.overgrownCliffs.biomeID().value());
        this.setVillages(rules);
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }

    @Override
    public GenLayer subBiomeEdges(long seed, GenLayer parent, int biomeCount) {
        return new GenLayerBopBiomeEdge(seed, parent, biomeCount);
    }
}

