/*
 * Decompiled with CFR 0.152.
 */
package climateControl;

import climateControl.DimensionAccess;
import climateControl.LockGenLayers;
import climateControl.MinecraftFilesAccess;
import climateControl.SettingsTester;
import climateControl.api.BiomeSettings;
import climateControl.api.CCDimensionSettings;
import climateControl.api.ClimateControlSettings;
import climateControl.api.DimensionalSettingsRegistry;
import climateControl.customGenLayer.GenLayerLowlandRiverMix;
import climateControl.customGenLayer.GenLayerRiverMixWrapper;
import climateControl.genLayerPack.GenLayerPack;
import climateControl.generator.CorrectedContinentsGenerator;
import climateControl.generator.OneSixCompatibleGenerator;
import climateControl.generator.TestGeneratorPair;
import climateControl.generator.VanillaCompatibleGenerator;
import climateControl.utils.BiomeConfigManager;
import com.Zeno410Utils.Accessor;
import com.Zeno410Utils.Maybe;
import com.Zeno410Utils.Named;
import com.Zeno410Utils.PlaneLocation;
import com.Zeno410Utils.Settings;
import com.Zeno410Utils.Zeno410Logger;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.init.Biomes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DimensionManager {
    public static Logger logger = new Zeno410Logger("DimensionManager").logger();
    private Accessor<GenLayerRiverMix, GenLayerPack> riverMixBiome = new Accessor("field_75910_b");
    private final ClimateControlSettings newSettings;
    private final CCDimensionSettings dimensionSettings;
    private final Named<ClimateControlSettings> masterSettings;
    private HashMap<Integer, ClimateControlSettings> dimensionalSettings = new HashMap();
    private HashMap<Integer, GenLayerRiverMixWrapper> wrappers = new HashMap();
    private final File suggestedConfigFile;
    private final File configDirectory;
    private BiomeConfigManager addonConfigManager = new BiomeConfigManager("GeographiCraft");
    private GenLayer original;
    private HashSet<Integer> dimensionsDone = new HashSet();
    PlaneLocation lastTry = new PlaneLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public DimensionManager(Named<ClimateControlSettings> masterSettings, CCDimensionSettings dimensionSettings, MinecraftServer server) {
        this.masterSettings = masterSettings;
        this.newSettings = (ClimateControlSettings)masterSettings.object;
        this.dimensionSettings = dimensionSettings;
        if (server == null) {
            this.configDirectory = null;
            this.suggestedConfigFile = null;
            return;
        }
        this.configDirectory = server.func_71209_f("config");
        this.suggestedConfigFile = new File(this.configDirectory, "geographicraft.cfg");
    }

    private GenLayerRiverMix patchedGenLayer(ClimateControlSettings settings, WorldType worldType, long worldSeed) {
        for (BiomeSettings biomeSettings : settings.biomeSettings()) {
        }
        if (this.ignore(worldType, settings)) {
            return null;
        }
        if (settings.noGenerationChanges.value().booleanValue()) {
            if (settings.oneSixCompatibility.value().booleanValue()) {
                return new OneSixCompatibleGenerator(settings).fromSeed(worldSeed, worldType);
            }
            return null;
        }
        new SettingsTester().test(settings);
        GenLayerRiverMix newMix = null;
        newMix = settings.vanillaLandAndClimate.value() != false ? new VanillaCompatibleGenerator(settings).fromSeed(worldSeed, worldType) : new CorrectedContinentsGenerator(settings, this.configDirectory.getParentFile()).fromSeed(worldSeed, worldType);
        GenLayer oldGen = null;
        GenLayer newGen = this.riverMixBiome.get(newMix);
        TestGeneratorPair pair = new TestGeneratorPair(oldGen, newGen);
        while (pair.hasNext()) {
            pair = pair.next();
        }
        if (newMix instanceof GenLayerLowlandRiverMix) {
            ((GenLayerLowlandRiverMix)newMix).setMaxChasm(settings.maxRiverChasm.value().floatValue());
        }
        for (BiomeSettings biomeSettings : settings.biomeSettings()) {
        }
        return newMix;
    }

    private ClimateControlSettings newSettings() {
        return this.newSettings;
    }

    private ClimateControlSettings defaultSettings(MinecraftFilesAccess dimension, boolean newWorld, WorldType worldType) {
        ClimateControlSettings result = this.defaultSettings(newWorld, worldType);
        if (!dimension.baseDirectory().exists()) {
            dimension.baseDirectory().mkdir();
            if (!dimension.baseDirectory().exists()) {
                // empty if block
            }
        }
        Named<Settings> dimensionSetting = Named.from(this.masterSettings.name, result);
        this.addonConfigManager.updateConfig(dimensionSetting, this.configDirectory, dimension.configDirectory());
        this.addonConfigManager.saveConfigs(this.configDirectory, dimension.configDirectory(), dimensionSetting);
        for (Named<Settings> named : result.registeredBiomeSettings()) {
            this.addonConfigManager.initializeConfig(named, this.configDirectory);
            this.addonConfigManager.updateConfig(named, this.configDirectory, dimension.configDirectory());
            if (!newWorld) continue;
            ((BiomeSettings)named.object).onNewWorld();
            this.addonConfigManager.saveConfigs(this.configDirectory, dimension.configDirectory(), named);
        }
        return result;
    }

    private ClimateControlSettings defaultSettings(boolean newWorld, WorldType worldType) {
        ClimateControlSettings result = new ClimateControlSettings(worldType);
        Named<ClimateControlSettings> namedResult = Named.from("geographicraft.cfg", result);
        this.addonConfigManager.initializeConfig(namedResult, this.configDirectory);
        result.setDefaults(this.configDirectory);
        for (Named<BiomeSettings> addonSetting : result.registeredBiomeSettings()) {
            if (newWorld) {
                ((BiomeSettings)addonSetting.object).onNewWorld();
            }
            this.addonConfigManager.initializeConfig(addonSetting, this.configDirectory);
            if (newWorld) {
                ((BiomeSettings)addonSetting.object).onNewWorld();
            }
            ((BiomeSettings)addonSetting.object).setNativeBiomeIDs(this.configDirectory);
        }
        return result;
    }

    private ClimateControlSettings dimensionalSettings(DimensionAccess dimension, boolean newWorld, WorldType worldType) {
        ClimateControlSettings result = this.dimensionalSettings.get(dimension.dimension);
        if (result == null) {
            result = this.defaultSettings(dimension, newWorld, worldType);
            DimensionalSettingsRegistry.instance.modify(dimension.dimension, result);
            this.dimensionalSettings.put(dimension.dimension, result);
        }
        return result;
    }

    public void onBiomeGenInit(WorldTypeEvent.InitBiomeGens event) {
        ClimateControlSettings generationSettings = this.defaultSettings(true, event.getWorldType());
        generationSettings.onNewWorld();
        if (this.ignore(event.getWorldType(), this.newSettings)) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            this.original = event.getOriginalBiomeGens()[0];
            return;
        }
        boolean newWorld = true;
        for (WorldServer worldServer : server.field_71305_c) {
            if (worldServer.func_82737_E() <= 0L) continue;
            newWorld = false;
        }
        this.original = event.getOriginalBiomeGens()[0];
        GenLayerRiverMixWrapper result = new GenLayerRiverMixWrapper(event.getSeed(), this.original, this);
        if (generationSettings.noGenerationChanges.value().booleanValue()) {
            event.setNewBiomeGens(result.modifiedGenerators());
            event.setResult(Event.Result.ALLOW);
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            GenLayerRiverMix patched = this.patchedGenLayer(generationSettings, event.getWorldType(), event.getSeed());
            event.setNewBiomeGens(result.modifiedGenerators());
            event.setResult(Event.Result.ALLOW);
        }
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        new HashMap();
        this.dimensionalSettings = new HashMap();
    }

    private boolean ignore(WorldType considered, ClimateControlSettings settings) {
        if (considered == null) {
            return true;
        }
        if (!settings.suppressInStandardWorlds.value().booleanValue()) {
            if (considered.equals(WorldType.field_151360_e)) {
                return false;
            }
            if (considered.equals(WorldType.field_77137_b)) {
                return false;
            }
            if (considered.equals(WorldType.field_77136_e)) {
                return false;
            }
            if (considered.equals(WorldType.field_77135_d)) {
                return false;
            }
        }
        if (settings.interveneInCustomizedWorlds.value().booleanValue() && considered.equals(WorldType.field_180271_f)) {
            return false;
        }
        if (considered.equals(WorldType.field_77138_c)) {
            return true;
        }
        if (considered.func_77127_a().equalsIgnoreCase("TerrainControl")) {
            return false;
        }
        if (settings.interveneInBOPWorlds.value().booleanValue() && considered.func_77127_a().equalsIgnoreCase("BIOMESOP")) {
            return false;
        }
        if (settings.interveneInHighlandsWorlds.value().booleanValue()) {
            if (considered.func_77127_a().equalsIgnoreCase("Highlands")) {
                return false;
            }
            if (considered.func_77127_a().equalsIgnoreCase("HighlandsLB")) {
                return false;
            }
        }
        if (considered.func_77127_a().equalsIgnoreCase("FWG")) {
            return false;
        }
        return !considered.func_77127_a().equalsIgnoreCase("RTG");
    }

    public void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        WorldServer world = (WorldServer)event.getWorld();
        if (this.ignore(world.func_175624_G(), this.newSettings)) {
            return;
        }
        int dimension = world.field_73011_w.getDimension();
        if (!this.dimensionSettings.ccOnIn(dimension) && !DimensionalSettingsRegistry.instance.useCCIn(dimension)) {
            return;
        }
        this.onWorldLoad(event.getWorld());
        this.salvageSpawn(event.getWorld());
        if (event.getSettings().func_77167_c()) {
            Random rand = new Random(world.func_72905_C());
            WorldGeneratorBonusChest worldgeneratorbonuschest = new WorldGeneratorBonusChest();
            for (int i = 0; i < 100; ++i) {
                int j = world.func_72912_H().func_76079_c() + rand.nextInt(6 + i / 10) - rand.nextInt(6 + i / 10);
                int k = world.func_72912_H().func_76074_e() + rand.nextInt(6 + i / 10) - rand.nextInt(6 + i / 10);
                BlockPos topBlockSpot = new BlockPos(j, world.func_72940_L() - 1, k);
                while (!world.func_180495_p(topBlockSpot).isSideSolid((IBlockAccess)world, topBlockSpot, EnumFacing.UP)) {
                    topBlockSpot = topBlockSpot.func_177977_b();
                }
                BlockPos above = topBlockSpot.func_177984_a();
                if (world.func_180495_p(above).func_177230_c().isAir(world.func_180495_p(above), (IBlockAccess)world, above) && worldgeneratorbonuschest.func_180709_b((World)world, rand, above)) break;
            }
        }
        event.setCanceled(true);
    }

    public void onWorldLoad(World world) {
    }

    public Maybe<GenLayerRiverMix> getGeographicraftGenlayers(WorldServer world, int dimension, GenLayer original) {
        if (this.ignore(world.func_175624_G(), this.newSettings)) {
            return Maybe.unknown();
        }
        if (!this.dimensionSettings.ccOnIn(dimension) && !DimensionalSettingsRegistry.instance.useCCIn(dimension)) {
            return Maybe.unknown();
        }
        DimensionAccess dimensionAccess = new DimensionAccess(dimension, world);
        long worldSeed = world.func_72905_C();
        if (world instanceof WorldServer && worldSeed != 0L) {
            ClimateControlSettings currentSettings = null;
            boolean newWorld = false;
            if (world.func_72912_H().func_82573_f() < 100L) {
                newWorld = true;
            }
            currentSettings = this.dimensionalSettings(dimensionAccess, newWorld, world.func_175624_G());
            try {
                GenLayerRiverMix patched = this.patchedGenLayer(currentSettings, world.func_175624_G(), worldSeed);
                if (patched != null) {
                    Accessor riverMixBiome = new Accessor("field_75910_b");
                    GenLayer lockable = (GenLayer)riverMixBiome.get(patched);
                    new LockGenLayers().lock(lockable, dimension, (World)world, currentSettings);
                    return Maybe.definitely(patched);
                }
                LockGenLayers biomeLocker = new LockGenLayers();
                Accessor riverMixBiome = new Accessor("field_75910_b");
                original = (GenLayer)riverMixBiome.get((GenLayerRiverMix)original);
                biomeLocker.lock(original, dimension, (World)world, currentSettings);
                return Maybe.unknown();
            }
            catch (Exception e) {
                logger.info(e.toString());
                logger.info(e.getMessage());
                return Maybe.unknown();
            }
            catch (Error e) {
                logger.info(e.toString());
                logger.info(e.getMessage());
                return Maybe.unknown();
            }
        }
        return Maybe.unknown();
    }

    private String controllingGenLayer(World world) {
        BiomeProvider chunkManager = world.func_72959_q();
        Accessor worldGenLayer = new Accessor("field_76944_d");
        return ((GenLayer)worldGenLayer.get(chunkManager)).toString();
    }

    private void salvageSpawn(World world) {
        WorldInfo info = world.func_72912_H();
        int x = info.func_76079_c() / 16 * 16 + this.newSettings().xSpawnOffset.value();
        int z = info.func_76074_e() / 16 * 16 + this.newSettings().zSpawnOffset.value();
        int move = 0;
        int ring = 0;
        int xMove = 0;
        int zMove = 0;
        int spawnX = 0;
        int spawnZ = 0;
        int spawnY = 0;
        Biome checkSpawn = world.getBiomeForCoordsBody(new BlockPos(x, 64, z));
        int nextTry = 50;
        int nextTryIncrement = 80;
        int nextTryStretch = 20;
        IChunkProvider chunkManager = world.func_72863_F();
        ChunkProviderServer chunkServer = null;
        chunkServer = (ChunkProviderServer)chunkManager;
        int checked = 0;
        int rescueTries = 0;
        while (spawnY < 64) {
            if (this.newSettings.rescueSearchLimit.value() == rescueTries++) {
                return;
            }
            if (checked > 50) {
                if (chunkServer != null) {
                    chunkServer.func_73240_a();
                    chunkServer.field_73247_e.func_75818_b();
                }
                checked = 0;
            }
            if (chunkServer != null) {
                // empty if block
            }
            ++checked;
            if (++move > ring * (ring + 1) * 4) {
                ++ring;
            }
            if (move < nextTry) continue;
            nextTry += (nextTryIncrement += nextTryStretch++);
            int inRing = move - (ring - 1) * ring * 4;
            if (inRing > ring * 6) {
                xMove = -ring;
                zMove = ring - (inRing - ring * 6) + 1;
            } else if (inRing > ring * 4) {
                zMove = ring;
                xMove = ring - (inRing - ring * 4) + 1;
            } else if (inRing > ring * 2) {
                xMove = ring;
                zMove = -ring + (inRing - ring * 2) - 1;
            } else {
                zMove = -ring;
                xMove = -ring + inRing - 1;
            }
            IntCache.func_76446_a();
            logger.info("checking for spawn at " + (x + xMove * 16) + "," + (z + zMove * 16) + "move " + move + " ring " + ring + " inRing " + inRing + " caches " + IntCache.func_85144_b() + " dimension " + world.field_73011_w.getDimension());
            checkSpawn = world.getBiomeForCoordsBody(new BlockPos(x + xMove * 16, 64, z + zMove * 16));
            spawnX = x + xMove * 16;
            spawnZ = z + zMove * 16;
            logger.info("setting spawn at " + spawnX + "," + spawnZ);
            if (checkSpawn == Biomes.field_76789_p) continue;
            spawnY = world.func_175672_r(new BlockPos(spawnX, 64, spawnZ)).func_177956_o() + 1;
            PlaneLocation newLocation = new PlaneLocation(spawnX, spawnZ);
            if (!newLocation.equals(this.lastTry)) continue;
            break;
        }
        world.func_175652_B(new BlockPos(spawnX, spawnY, spawnZ));
    }

    private String levelSavePath(WorldServer world) {
        String result = "";
        result = world.getChunkSaveLocation().getAbsolutePath();
        return result;
    }

    private boolean hasOnlySea(Chunk tested) {
        byte[] biomes;
        for (byte biome : biomes = tested.func_76605_m()) {
            if (biome == 0 || biome == Biome.func_185362_a((Biome)Biomes.field_150575_M)) continue;
            return false;
        }
        return true;
    }

    private boolean isSea(Biome tested) {
        if (tested == Biomes.field_76771_b) {
            return true;
        }
        if (tested == Biomes.field_150575_M) {
            return true;
        }
        return tested == Biomes.field_76789_p;
    }
}

