/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.worldgen.feature;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.worldgen.ModuleWorldGenConfig;
import com.codetaylor.mc.pyrotech.modules.worldgen.feature.spi.IWorldGenFeature;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WorldGenGloamberryBush
implements IWorldGenFeature {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private Set<Biome> allowedBiomeSet;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockXPos = chunkX << 4;
        int blockZPos = chunkZ << 4;
        Biome biome = world.func_180494_b((BlockPos)this.pos.func_181079_c(blockXPos, 0, blockZPos));
        if (!this.isAllowed(biome)) {
            return;
        }
        if ((double)random.nextFloat() > ModuleWorldGenConfig.GLOAMBERRY_BUSH.CLUSTER_FREQUENCY) {
            return;
        }
        double density = ModuleWorldGenConfig.GLOAMBERRY_BUSH.DENSITY;
        for (int i = 0; i < ModuleWorldGenConfig.GLOAMBERRY_BUSH.CHANCES_TO_SPAWN; ++i) {
            int posX = blockXPos + random.nextInt(16) + 8;
            int posY = world.func_189649_b(blockXPos, blockZPos);
            int posZ = blockZPos + random.nextInt(16) + 8;
            BlockHelper.forBlocksInCube((World)world, (BlockPos)new BlockPos(posX, posY, posZ), (int)4, (int)4, (int)4, (w, p, bs) -> {
                if (w.func_175623_d(p) && (double)random.nextFloat() < density && this.canSpawnOnTopOf(w, p.func_177977_b(), w.func_180495_p(p.func_177977_b()))) {
                    world.func_180501_a(p, ModuleCore.Blocks.GLOAMBERRY_BUSH.withAge(random.nextInt(3) + 4), 18);
                }
                return true;
            });
        }
    }

    @Override
    public boolean isAllowed(int dimensionId) {
        return ModuleWorldGenConfig.GLOAMBERRY_BUSH.ENABLED && ModuleWorldGenConfig.GLOAMBERRY_BUSH.CHANCES_TO_SPAWN > 0 && ModuleWorldGenConfig.GLOAMBERRY_BUSH.CLUSTER_FREQUENCY > 0.0 && this.isAllowedDimension(dimensionId, ModuleWorldGenConfig.GLOAMBERRY_BUSH.DIMENSION_WHITELIST, ModuleWorldGenConfig.GLOAMBERRY_BUSH.DIMENSION_BLACKLIST);
    }

    private boolean isAllowed(Biome biome) {
        if (this.allowedBiomeSet == null) {
            String[] allowedBiomes = ModuleWorldGenConfig.GLOAMBERRY_BUSH.ALLOWED_BIOMES;
            this.allowedBiomeSet = new HashSet<Biome>(allowedBiomes.length);
            for (String allowedBiome : allowedBiomes) {
                Biome biomeLookup = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(allowedBiome));
                if (biomeLookup != null) {
                    this.allowedBiomeSet.add(biomeLookup);
                    continue;
                }
                ModuleCore.LOGGER.error("Missing biome registration for " + allowedBiome + " in Pyroberry Bush config");
            }
        }
        return this.allowedBiomeSet.contains(biome);
    }

    private boolean canSpawnOnTopOf(World world, BlockPos pos, IBlockState blockState) {
        if (!blockState.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        return ModuleCore.Blocks.GLOAMBERRY_BUSH.isValidBlock(blockState);
    }
}

