/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tool.item.api;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.block.spi.BlockOreDenseRedstoneBase;
import com.codetaylor.mc.pyrotech.modules.tool.ModuleToolConfig;
import com.codetaylor.mc.pyrotech.modules.tool.item.spi.IRedstoneTool;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class RedstoneToolDelegate {
    public static long ticksToMillis(long ticks) {
        return ticks * 50L;
    }

    public static long getExpirationTimestamp(long ticks) {
        return System.currentTimeMillis() + RedstoneToolDelegate.ticksToMillis(ticks);
    }

    public static boolean isActive(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof IRedstoneTool)) {
            return false;
        }
        NBTTagCompound compound = StackHelper.getTagSafe((ItemStack)itemStack);
        if (!compound.func_74764_b("Pyrotech")) {
            return false;
        }
        NBTTagCompound pyrotech = compound.func_74775_l("Pyrotech");
        if (!pyrotech.func_74764_b("RedstoneToolActiveExpiresTimestamp")) {
            return false;
        }
        return pyrotech.func_74763_f("RedstoneToolActiveExpiresTimestamp") > System.currentTimeMillis();
    }

    public static void setActive(ItemStack itemStack, int durationTicks) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof IRedstoneTool)) {
            return;
        }
        NBTTagCompound compound = StackHelper.getTagSafe((ItemStack)itemStack);
        NBTTagCompound pyrotech = compound.func_74775_l("Pyrotech");
        pyrotech.func_74772_a("RedstoneToolActiveExpiresTimestamp", RedstoneToolDelegate.getExpirationTimestamp(durationTicks));
        compound.func_74782_a("Pyrotech", (NBTBase)pyrotech);
    }

    public static void setDamage(IRedstoneTool item, @Nonnull ItemStack itemStack, int damage) {
        boolean damaged = item.getRedstoneToolDamage(itemStack) < damage;
        boolean active = item.isRedstoneToolActive(itemStack);
        if (active && damaged) {
            if ((double)RandomHelper.random().nextFloat() < ModuleToolConfig.REDSTONE_TOOLS.ACTIVE_DAMAGE_CHANCE) {
                item.setRedstoneToolDamage(itemStack, damage);
            }
        } else {
            item.setRedstoneToolDamage(itemStack, damage);
        }
        if (active || damaged) {
            double activationChance;
            double d = activationChance = active ? ModuleToolConfig.REDSTONE_TOOLS.ACTIVE_ACTIVATION_CHANCE : ModuleToolConfig.REDSTONE_TOOLS.INACTIVE_ACTIVATION_CHANCE;
            if ((double)RandomHelper.random().nextFloat() < activationChance) {
                item.activateRedstoneTool(itemStack);
            }
        }
    }

    public static void activateNearbyDenseRedstoneOre(ItemStack itemStack, World world, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        if (player.func_184614_ca() != itemStack) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IRedstoneTool) {
            BlockPos pos = player.func_180425_c();
            BlockHelper.forBlocksInCubeShuffled((World)world, (BlockPos)pos, (int)4, (int)4, (int)4, (w, p, bs) -> {
                if (bs.func_177230_c() instanceof BlockOreDenseRedstoneBase) {
                    BlockOreDenseRedstoneBase block = (BlockOreDenseRedstoneBase)bs.func_177230_c();
                    block.activate(w, p);
                    RedstoneToolDelegate.activateAndHealTool(itemStack, world, (IRedstoneTool)item, pos, block.getProximityRepairAmount());
                    return (double)world.field_73012_v.nextFloat() < 0.32;
                }
                if (bs.func_177230_c() == Blocks.field_150450_ax) {
                    world.func_175656_a(p, Blocks.field_150439_ay.func_176223_P());
                    ModuleCore.Blocks.ORE_DENSE_REDSTONE_LARGE.playSound(world, p);
                    RedstoneToolDelegate.activateAndHealTool(itemStack, world, (IRedstoneTool)item, pos, 1);
                    return (double)world.field_73012_v.nextFloat() < 0.16;
                }
                return true;
            });
        }
    }

    public static void playActivationSound(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, pos, RedstoneToolDelegate.selectSoundEvent(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void playActivationSound() {
        float pitchVariance = (RandomHelper.random().nextFloat() * 2.0f - 1.0f) * 0.05f;
        ModPyrotech.PROXY.playSound(RedstoneToolDelegate.selectSoundEvent(), SoundCategory.PLAYERS, 1.0f, 1.0f + pitchVariance, false);
    }

    private static SoundEvent selectSoundEvent() {
        SoundEvent[] soundEvents = new SoundEvent[]{ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_00, ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_01, ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_02, ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_03, ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_04, ModuleCore.Sounds.REDSTONE_TOOL_ACTIVATE_05};
        return soundEvents[RandomHelper.random().nextInt(soundEvents.length)];
    }

    private static void activateAndHealTool(ItemStack itemStack, World world, IRedstoneTool item, BlockPos pos, int amount) {
        if (!item.isRedstoneToolActive(itemStack)) {
            item.activateRedstoneTool(itemStack);
        }
        if ((double)world.field_73012_v.nextFloat() < ModuleToolConfig.REDSTONE_TOOLS.PROXIMITY_REPAIR_CHANCE) {
            itemStack.func_77964_b(itemStack.func_77952_i() - amount);
        }
    }

    private RedstoneToolDelegate() {
    }
}

