/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@Config(modid="pyrotech", name="pyrotech/module.Tool")
public class ModuleToolConfig {
    public static CrudeShield CRUDE_SHIELD = new CrudeShield();
    public static DurableShield DURABLE_SHIELD = new DurableShield();
    public static QuartzTools QUARTZ_TOOLS = new QuartzTools();
    public static RedstoneTools REDSTONE_TOOLS = new RedstoneTools();
    @Config.Comment(value={"The durability of the vanilla type tools, excluding hammers.", "To change the durability of hammers, see the hammers section in core.cfg."})
    public static Map<String, Integer> DURABILITY = new LinkedHashMap<String, Integer>();
    @Config.Comment(value={"The harvest levels of each tool material, excluding hammers.", "To change the harvest level of hammers, see the hammers section in core.cfg."})
    public static Map<String, Integer> HARVEST_LEVEL;
    @Config.Comment(value={"The durability of the shears.", "For reference, the durability of the vanilla shears is 238."})
    public static Map<String, Integer> SHEARS_DURABILITY;
    @Config.Comment(value={"The durability of the crude fishing rod.", "Default: 16"})
    @Config.RangeInt(min=1, max=32767)
    public static int CRUDE_FISHING_ROD_DURABILITY;
    @Config.Comment(value={"Chance that the crude fishing rod will break when damaged.", "The chance to break increases linearly as the rod takes damage.", "This is the maximum chance when the rod is at 100% damage.", "chance = (damage / maxDamage) * configChance", "Default: 0.65"})
    public static double CRUDE_FISHING_ROD_BREAK_CHANCE;
    public static BoneToolRepairKit BONE_TOOL_REPAIR_KIT;
    public static FlintToolRepairKit FLINT_TOOL_REPAIR_KIT;

    public static int getHarvestLevel(String type) {
        return HARVEST_LEVEL.getOrDefault(type, -1);
    }

    static {
        DURABILITY.put("crude", 32);
        DURABILITY.put("bone", 150);
        DURABILITY.put("bone_durable", 600);
        DURABILITY.put("flint", 150);
        DURABILITY.put("flint_durable", 600);
        DURABILITY.put("redstone", 200);
        DURABILITY.put("quartz", 350);
        DURABILITY.put("obsidian", 1400);
        HARVEST_LEVEL = new LinkedHashMap<String, Integer>();
        HARVEST_LEVEL.put("crude", 0);
        HARVEST_LEVEL.put("bone", 1);
        HARVEST_LEVEL.put("bone_durable", 1);
        HARVEST_LEVEL.put("flint", 1);
        HARVEST_LEVEL.put("flint_durable", 1);
        HARVEST_LEVEL.put("redstone", 1);
        HARVEST_LEVEL.put("quartz", 1);
        HARVEST_LEVEL.put("obsidian", 2);
        SHEARS_DURABILITY = new LinkedHashMap<String, Integer>();
        SHEARS_DURABILITY.put("clay", 60);
        SHEARS_DURABILITY.put("stone", 90);
        SHEARS_DURABILITY.put("bone", 120);
        SHEARS_DURABILITY.put("flint", 120);
        SHEARS_DURABILITY.put("gold", 30);
        SHEARS_DURABILITY.put("diamond", 952);
        SHEARS_DURABILITY.put("obsidian", 852);
        CRUDE_FISHING_ROD_DURABILITY = 16;
        CRUDE_FISHING_ROD_BREAK_CHANCE = 0.65;
        BONE_TOOL_REPAIR_KIT = new BoneToolRepairKit();
        FLINT_TOOL_REPAIR_KIT = new FlintToolRepairKit();
    }

    public static class FlintToolRepairKit {
        @Config.Comment(value={"The number of uses per repair kit.", "Default: 4"})
        public int USES = 4;
        @Config.Comment(value={"The damage applied to the hammer when repairing with a kit.", "Default: 4"})
        public int HAMMER_REPAIR_DAMAGE = 4;
        @Config.Comment(value={"The percentage of durability repaired.", "Default: 0.25"})
        public double PERCENTAGE_DURABILITY_REPAIRED = 0.25;
    }

    public static class BoneToolRepairKit {
        @Config.Comment(value={"The number of uses per repair kit.", "Default: 4"})
        public int USES = 4;
        @Config.Comment(value={"The damage applied to the hammer when repairing with a kit.", "Default: 4"})
        public int HAMMER_REPAIR_DAMAGE = 4;
        @Config.Comment(value={"The percentage of durability repaired.", "Default: 0.25"})
        public double PERCENTAGE_DURABILITY_REPAIRED = 0.25;
    }

    public static class RedstoneTools {
        @Config.Comment(value={"The duration of the redstone tools' special abilities in ticks.", "Default: 200"})
        public int ACTIVE_DURATION_TICKS = 200;
        @Config.Comment(value={"The chance that the tool will take damage when it is active.", "For example, if the value is 0.25, there will be a 75% chance", "that the tool will not take damage when damaged.", "Default: 0.125"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double ACTIVE_DAMAGE_CHANCE = 0.125;
        @Config.Comment(value={"The chance that the tool will activate when damaged while inactive.", "Default: 0.05"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double INACTIVE_ACTIVATION_CHANCE = 0.05;
        @Config.Comment(value={"The chance that the tool will activate when damaged while active.", "Default: 0.25"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double ACTIVE_ACTIVATION_CHANCE = 0.25;
        @Config.Comment(value={"The speed multiplier that is applied when the tool is active.", "Default: 2"})
        @Config.RangeDouble(min=1.0)
        public double ACTIVE_HARVEST_SPEED_SCALAR = 2.0;
        @Config.Comment(value={"The damage multiplier that is applied when the sword is active.", "Default: 2"})
        @Config.RangeDouble(min=1.0)
        public double ACTIVE_SWORD_DAMAGE_SCALAR = 2.0;
        @Config.Comment(value={"Chance to restore durability when near redstone ore and dense redstone ore.", "Default: 0.125"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double PROXIMITY_REPAIR_CHANCE = 0.125;
        @Config.Comment(value={"The amount of repair for each size variant: rocks, small, large.", "Default: [1, 2, 3]"})
        public int[] PROXIMITY_REPAIR_AMOUNTS = new int[]{1, 2, 3};
    }

    public static class QuartzTools {
        @Config.Comment(value={"The speed multiplier that is applied when the tool is active.", "Default: 3"})
        @Config.RangeDouble(min=1.0)
        public double ACTIVE_HARVEST_SPEED_SCALAR = 3.0;
        @Config.Comment(value={"The damage multiplier that is applied when the sword is active.", "Default: 4"})
        @Config.RangeDouble(min=1.0)
        public double ACTIVE_SWORD_DAMAGE_SCALAR = 3.0;
    }

    public static class DurableShield {
        @Config.Comment(value={"Durability of the item.", "Default: 200"})
        public int DURABILITY = 200;
    }

    public static class CrudeShield {
        @Config.Comment(value={"Durability of the item.", "Default: 50"})
        public int DURABILITY = 50;
    }
}

