/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi;

import com.codetaylor.mc.pyrotech.library.util.FloodFill;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarDrain;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileActivePile;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarCollectorBase;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarTankBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public abstract class TileTarDrainBase
extends TileTarTankBase {
    public TileTarDrainBase() {
        this.fluidTank.setCanFill(false);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            EnumFacing tileFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTarDrain.FACING);
            return facing == tileFacing || facing == tileFacing.func_176734_d();
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing tileFacing;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == (tileFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTarDrain.FACING)) || facing == tileFacing.func_176734_d())) {
            return (T)((Object)this.fluidTank);
        }
        return null;
    }

    @Override
    protected Set<BlockPos> getCollectionSourcePositions(World world, BlockPos origin) {
        IBlockState blockState = world.func_180495_p(origin);
        if (blockState.func_177230_c() != ModuleTechRefractory.Blocks.TAR_DRAIN) {
            return Collections.emptySet();
        }
        EnumFacing facing = ((EnumFacing)blockState.func_177229_b((IProperty)BlockTarDrain.FACING)).func_176734_d();
        int drainRange = this.getDrainRange();
        BlockPos offset = origin.func_177967_a(facing, 1 + drainRange);
        HashSet<BlockPos> eligiblePos = new HashSet<BlockPos>(9);
        HashSet<BlockPos> result = new HashSet<BlockPos>(9);
        for (int x = -drainRange; x <= drainRange; ++x) {
            for (int z = -drainRange; z <= drainRange; ++z) {
                eligiblePos.add(offset.func_177982_a(x, 0, z));
            }
        }
        BlockPos start = origin.func_177972_a(facing);
        FloodFill.ICandidatePredicate candidatePredicate = (w, p) -> eligiblePos.contains(p) && this.getCollectionSourceFluidHandler(w, p) != null;
        FloodFill.IAction action = (w, p) -> {
            boolean isFluidSource;
            boolean bl = isFluidSource = this.getFluidBlockHandler(w, p) != null;
            if (isFluidSource && p.equals((Object)start)) {
                result.add(p);
                return false;
            }
            if (!isFluidSource) {
                result.add(p);
            }
            return true;
        };
        FloodFill.apply(world, start, candidatePredicate, action, eligiblePos.size());
        return result;
    }

    protected abstract int getDrainRange();

    protected abstract boolean allowSourceDrain();

    protected abstract boolean allowTileDrain();

    @Override
    @Nullable
    protected IFluidHandler getCollectionSourceFluidHandler(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            IFluidHandler fluidHandler;
            if (tileEntity instanceof TileTarCollectorBase) {
                return ((TileTarCollectorBase)tileEntity).getFluidTank();
            }
            if (tileEntity instanceof TileActivePile) {
                return ((TileActivePile)tileEntity).getFluidTank();
            }
            if (this.allowTileDrain() && (fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
                return fluidHandler;
            }
        }
        return this.getFluidBlockHandler(world, pos);
    }

    private IFluidHandler getFluidBlockHandler(World world, BlockPos pos) {
        if (!this.allowSourceDrain()) {
            return null;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, pos);
        }
        return null;
    }
}

