/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi;

import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileActivePile;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarTankBase;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileTarCollectorBase
extends TileTarTankBase {
    private static final int DEFAULT_TICKS_TO_EXTINGUISH = 100;
    private boolean burning = false;
    private int burnTicksRemaining;
    private int extinguishTicksRemaining = 100;
    private boolean firstLightCheck;

    public void setBurning(boolean burning) {
        this.burning = burning;
        if (!this.field_145850_b.field_72995_K) {
            BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)((Object)this.fluidTank);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected Set<BlockPos> getCollectionSourcePositions(World world, BlockPos origin) {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    protected IFluidHandler getCollectionSourceFluidHandler(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileActivePile) {
            return ((TileActivePile)tileEntity).getFluidTank();
        }
        return null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.firstLightCheck) {
            this.firstLightCheck = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                this.spawnParticles();
            }
            return;
        }
        if (this.isBurning()) {
            if (this.shouldExtinguish()) {
                --this.extinguishTicksRemaining;
                if (this.extinguishTicksRemaining <= 0) {
                    this.burnTicksRemaining = 0;
                    this.setBurning(false);
                    this.removeFire(this.field_145850_b, this.field_174879_c.func_177984_a());
                    this.extinguishTicksRemaining = 100;
                    return;
                }
            } else {
                this.extinguishTicksRemaining = 100;
            }
            --this.burnTicksRemaining;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.tryCatchFire(this.field_145850_b, this.field_174879_c.func_177972_a(facing.func_176734_d()), 100, Util.RANDOM, facing);
            }
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (this.burnTicksRemaining <= 0) {
                this.tryConsumeFuel(fluidStack);
            }
            if (this.burnTicksRemaining > 0) {
                this.assertFire(this.field_145850_b, this.field_174879_c.func_177984_a());
            } else {
                this.setBurning(false);
            }
        }
    }

    private void removeFire(World world, BlockPos up) {
        if (world.func_180495_p(up).func_177230_c() == Blocks.field_150480_ab) {
            world.func_175698_g(up);
        }
    }

    private boolean shouldExtinguish() {
        BlockPos up = this.field_174879_c.func_177984_a();
        IBlockState blockState = this.field_145850_b.func_180495_p(up);
        return blockState.isSideSolid((IBlockAccess)this.field_145850_b, up, EnumFacing.DOWN) && !blockState.func_177230_c().isFlammable((IBlockAccess)this.field_145850_b, up, EnumFacing.DOWN);
    }

    protected abstract int getSmokeParticlesPerTick();

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        double centerX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double centerY = this.field_174879_c.func_177956_o() + 1;
        double centerZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        for (int i = 0; i < this.getSmokeParticlesPerTick(); ++i) {
            this.spawnParticles(centerX, centerY, centerZ, EnumParticleTypes.SMOKE_LARGE);
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == Blocks.field_150480_ab) {
            this.spawnParticles(centerX, centerY, centerZ, EnumParticleTypes.LAVA);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(double centerX, double centerY, double centerZ, EnumParticleTypes particleType) {
        this.field_145850_b.func_175688_a(particleType, centerX + (Util.RANDOM.nextDouble() - 0.5), centerY, centerZ + (Util.RANDOM.nextDouble() - 0.5), 0.0, 0.1 + (double)(Util.RANDOM.nextFloat() * 2.0f - 1.0f) * 0.05, 0.0, new int[0]);
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, EnumFacing face) {
        TileTarCollectorBase collector;
        TileEntity tileEntity;
        int i = worldIn.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                worldIn.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.func_175698_g(pos);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.TRUE));
            }
        }
        if ((tileEntity = this.field_145850_b.func_175625_s(pos)) instanceof TileTarCollectorBase && !(collector = (TileTarCollectorBase)tileEntity).isBurning() && collector.isFlammable()) {
            collector.setBurning(true);
        }
    }

    private void tryConsumeFuel(FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        int burnTicksPerMilliBucket = this.getBurnTicksPerMilliBucket(fluidStack.getFluid());
        if (burnTicksPerMilliBucket > 0) {
            this.burnTicksRemaining = burnTicksPerMilliBucket;
            this.fluidTank.drainInternal(1, true);
        }
    }

    private void assertFire(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
            return;
        }
        if (Util.canSetFire(this.field_145850_b, pos)) {
            this.field_145850_b.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3);
        }
    }

    public boolean isFlammable() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        return this.getBurnTicksPerMilliBucket(fluidStack.getFluid()) > 0;
    }

    private int getBurnTicksPerMilliBucket(Fluid fluid) {
        Integer value = ModuleTechRefractoryConfig.REFRACTORY.FLUID_BURN_TICKS.get(fluid.getName());
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("burning", this.burning);
        compound.func_74768_a("burnTicksRemaining", this.burnTicksRemaining);
        return compound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burning = compound.func_74767_n("burning");
        this.burnTicksRemaining = compound.func_74762_e("burnTicksRemaining");
    }
}

