/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.init;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.athenaeum.util.Injector;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.library.util.BlockMetaMatcher;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.ignition.ModuleIgnition;
import com.codetaylor.mc.pyrotech.modules.ignition.block.BlockIgniter;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarCollector;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarDrain;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.event.ItemTooltipEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.recipe.PitBurnRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public final class RegistryInitializer {
    public static void createRegistries() {
        new RegistryBuilder().setName(new ResourceLocation("pyrotech", "pit_recipe")).setType(PitBurnRecipe.class).allowModification().create();
        Injector injector = new Injector();
        injector.inject(ModuleTechRefractory.Registries.class, "BURN_RECIPE", (Object)GameRegistry.findRegistry(PitBurnRecipe.class));
    }

    public static void initializeRefractoryBlocks() {
        RecipeItemParser parser = new RecipeItemParser();
        ArrayList<BlockMetaMatcher> blockMetaMatcherList = new ArrayList<BlockMetaMatcher>();
        blockMetaMatcherList.add(new BlockMetaMatcher(ModuleTechRefractory.Blocks.ACTIVE_PILE, 0));
        blockMetaMatcherList.add(new BlockMetaMatcher(ModuleTechRefractory.Blocks.PIT_ASH_BLOCK, 0));
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleIgnition.class)) {
            blockMetaMatcherList.addAll(Arrays.asList(new BlockMetaMatcher(ModuleIgnition.Blocks.IGNITER, RegistryInitializer.getIgniterMeta(EnumFacing.NORTH)), new BlockMetaMatcher(ModuleIgnition.Blocks.IGNITER, RegistryInitializer.getIgniterMeta(EnumFacing.EAST)), new BlockMetaMatcher(ModuleIgnition.Blocks.IGNITER, RegistryInitializer.getIgniterMeta(EnumFacing.SOUTH)), new BlockMetaMatcher(ModuleIgnition.Blocks.IGNITER, RegistryInitializer.getIgniterMeta(EnumFacing.WEST))));
            ItemTooltipEventHandler.VALID_REFRACTORY_ITEM_BLOCKS.addAll(Lists.newArrayList((Object[])new ParseResult[]{new ParseResult("pyrotech", "igniter", BlockIgniter.EnumType.BRICK.getMeta())}));
        }
        blockMetaMatcherList.addAll(Arrays.asList(new BlockMetaMatcher(ModuleCore.Blocks.REFRACTORY_BRICK, 0), new BlockMetaMatcher(ModuleCore.Blocks.REFRACTORY_GLASS, Short.MAX_VALUE), new BlockMetaMatcher(ModuleTechRefractory.Blocks.TAR_COLLECTOR, BlockTarCollector.EnumType.BRICK.getMeta()), new BlockMetaMatcher(ModuleTechRefractory.Blocks.TAR_DRAIN, RegistryInitializer.getTarDrainMeta(EnumFacing.NORTH)), new BlockMetaMatcher(ModuleTechRefractory.Blocks.TAR_DRAIN, RegistryInitializer.getTarDrainMeta(EnumFacing.EAST)), new BlockMetaMatcher(ModuleTechRefractory.Blocks.TAR_DRAIN, RegistryInitializer.getTarDrainMeta(EnumFacing.SOUTH)), new BlockMetaMatcher(ModuleTechRefractory.Blocks.TAR_DRAIN, RegistryInitializer.getTarDrainMeta(EnumFacing.WEST)), new BlockMetaMatcher((Block)ModuleCore.Blocks.REFRACTORY_BRICK_SLAB_DOUBLE, 0)));
        ItemTooltipEventHandler.VALID_REFRACTORY_ITEM_BLOCKS.addAll(Lists.newArrayList((Object[])new ParseResult[]{new ParseResult("pyrotech", "refractory_brick_block", 0), new ParseResult("pyrotech", "refractory_glass", 0), new ParseResult("pyrotech", "tar_drain", BlockTarDrain.EnumType.BRICK.getMeta()), new ParseResult("pyrotech", "tar_collector", BlockTarCollector.EnumType.BRICK.getMeta()), new ParseResult("pyrotech", "refractory_door", 0)}));
        for (String blockString : ModuleTechRefractoryConfig.REFRACTORY.REFRACTORY_BRICKS) {
            try {
                blockMetaMatcherList.add(Util.parseBlockStringWithWildcard(blockString, parser));
            }
            catch (MalformedRecipeItemException e) {
                ModuleTechRefractory.LOGGER.error("", (Throwable)e);
            }
        }
        for (String itemString : ModuleTechRefractoryConfig.CLIENT.VALID_REFRACTORY_TOOLTIP) {
            try {
                ItemTooltipEventHandler.VALID_REFRACTORY_ITEM_BLOCKS.add(RecipeItemParser.INSTANCE.parse(itemString));
            }
            catch (MalformedRecipeItemException e) {
                ModuleTechRefractory.LOGGER.error("", (Throwable)e);
            }
        }
        Injector injector = new Injector();
        injector.inject(ModuleTechRefractory.Registries.class, "REFRACTORY_BLOCK_LIST", Collections.unmodifiableList(blockMetaMatcherList));
    }

    private static int getTarDrainMeta(EnumFacing facing) {
        return ModuleTechRefractory.Blocks.TAR_DRAIN.func_176201_c(ModuleTechRefractory.Blocks.TAR_DRAIN.func_176223_P().func_177226_a(BlockTarDrain.VARIANT, (Comparable)((Object)BlockTarDrain.EnumType.BRICK)).func_177226_a((IProperty)BlockTarDrain.FACING, (Comparable)facing));
    }

    private static int getIgniterMeta(EnumFacing facing) {
        return ModuleIgnition.Blocks.IGNITER.func_176201_c(ModuleIgnition.Blocks.IGNITER.func_176223_P().func_177226_a(BlockIgniter.VARIANT, (Comparable)((Object)BlockIgniter.EnumType.BRICK)).func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)facing));
    }

    private RegistryInitializer() {
    }
}

