/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.block;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.FluidUtilFix;
import com.codetaylor.mc.pyrotech.library.util.Tooltips;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.block.BlockTarCollector;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileBrickTarDrain;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileStoneTarDrain;
import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTarDrain
extends Block
implements IBlockVariant<EnumType> {
    public static final String NAME = "tar_drain";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockTarDrain() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.STONE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH));
    }

    @ParametersAreNonnullByDefault
    public void func_190948_a(ItemStack itemStack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (itemStack.func_77960_j() == BlockTarCollector.EnumType.STONE.getMeta()) {
            Tooltips.addCapacity(tooltip, ModuleTechRefractoryConfig.STONE_TAR_DRAIN.CAPACITY, 1);
            Tooltips.addHotFluids(tooltip, ModuleTechRefractoryConfig.STONE_TAR_DRAIN.HOLDS_HOT_FLUIDS, 2);
            Tooltips.addRange(tooltip, ModuleTechRefractoryConfig.STONE_TAR_DRAIN.RANGE, 3);
        } else if (itemStack.func_77960_j() == BlockTarCollector.EnumType.BRICK.getMeta()) {
            Tooltips.addCapacity(tooltip, ModuleTechRefractoryConfig.BRICK_TAR_DRAIN.CAPACITY, 1);
            Tooltips.addHotFluids(tooltip, ModuleTechRefractoryConfig.BRICK_TAR_DRAIN.HOLDS_HOT_FLUIDS, 2);
            Tooltips.addRange(tooltip, ModuleTechRefractoryConfig.BRICK_TAR_DRAIN.RANGE, 3);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta & 3))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[meta >> 2 & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta() | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    @ParametersAreNonnullByDefault
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta))).func_177226_a((IProperty)FACING, (Comparable)opposite);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.STONE) {
            return new TileStoneTarDrain();
        }
        if (type == EnumType.BRICK) {
            return new TileBrickTarDrain();
        }
        return null;
    }

    @Nonnull
    public String getModelName(ItemStack itemStack) {
        return EnumType.fromMeta(itemStack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        if (fluidHandler == null) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        return FluidUtilFix.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)fluidHandler) || FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum EnumType implements IVariant
    {
        STONE(0, "stone"),
        BRICK(1, "brick");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

