/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.refractory.block;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.FluidUtilFix;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentFire;
import com.codetaylor.mc.pyrotech.library.spi.block.IBlockIgnitableAdjacentIgniterBlock;
import com.codetaylor.mc.pyrotech.library.util.Tooltips;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractoryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileBrickTarCollector;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.TileStoneTarCollector;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.tile.spi.TileTarCollectorBase;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockTarCollector
extends Block
implements IBlockVariant<EnumType>,
IBlockIgnitableAdjacentFire,
IBlockIgnitableAdjacentIgniterBlock {
    public static final String NAME = "tar_collector";
    public static final IProperty<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockTarCollector() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.STONE)));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @ParametersAreNonnullByDefault
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTarCollectorBase) {
            TileTarCollectorBase tile = (TileTarCollectorBase)tileEntity;
            FluidTank fluidTank = tile.getFluidTank();
            FluidStack fluid = fluidTank.getFluid();
            int fluidAmount = fluidTank.getFluidAmount();
            if (fluid != null && fluidAmount > 0) {
                int luminosity = fluid.getFluid().getLuminosity(fluid);
                return MathHelper.func_76125_a((int)luminosity, (int)0, (int)15);
            }
        }
        return super.getLightValue(state, world, pos);
    }

    @ParametersAreNonnullByDefault
    public void func_190948_a(ItemStack itemStack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (itemStack.func_77960_j() == EnumType.STONE.getMeta()) {
            Tooltips.addCapacity(tooltip, ModuleTechRefractoryConfig.STONE_TAR_COLLECTOR.CAPACITY, 1);
            Tooltips.addHotFluids(tooltip, ModuleTechRefractoryConfig.STONE_TAR_COLLECTOR.HOLDS_HOT_FLUIDS, 2);
        } else if (itemStack.func_77960_j() == EnumType.BRICK.getMeta()) {
            Tooltips.addCapacity(tooltip, ModuleTechRefractoryConfig.BRICK_TAR_COLLECTOR.CAPACITY, 1);
            Tooltips.addHotFluids(tooltip, ModuleTechRefractoryConfig.BRICK_TAR_COLLECTOR.HOLDS_HOT_FLUIDS, 2);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    @ParametersAreNonnullByDefault
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    public String getModelName(ItemStack stack) {
        return EnumType.fromMeta(stack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return VARIANT;
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.STONE) {
            return new TileStoneTarCollector();
        }
        if (type == EnumType.BRICK) {
            return new TileBrickTarCollector();
        }
        return null;
    }

    @Override
    public void igniteWithAdjacentFire(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        FluidTank fluidTank;
        TileEntity tileEntity;
        if (facing == EnumFacing.UP && (tileEntity = world.func_175625_s(pos)) instanceof TileTarCollectorBase && (fluidTank = ((TileTarCollectorBase)tileEntity).getFluidTank()).getFluidAmount() > 0) {
            ((TileTarCollectorBase)tileEntity).setBurning(true);
        }
    }

    @Override
    public void igniteWithAdjacentIgniterBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        TileEntity tileEntity;
        if (Util.canSetFire(world, pos.func_177984_a()) && (tileEntity = world.func_175625_s(pos)) instanceof TileTarCollectorBase && ((TileTarCollectorBase)tileEntity).isFlammable()) {
            ((TileTarCollectorBase)tileEntity).setBurning(true);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        if (fluidHandler == null) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        return FluidUtilFix.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)fluidHandler) || FluidUtil.getFluidHandler((ItemStack)heldItem) != null;
    }

    @ParametersAreNonnullByDefault
    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTarCollectorBase) {
            return side == EnumFacing.UP && ((TileTarCollectorBase)tileEntity).isBurning();
        }
        return super.isFireSource(world, pos, side);
    }

    public static enum EnumType implements IVariant
    {
        STONE(0, "stone"),
        BRICK(1, "brick");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

