/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.LargeDynamicStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInItemOutBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneItemInBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileCombustionWorkerStoneItemInItemOutBase<E extends MachineRecipeItemInItemOutBase<E>>
extends TileCombustionWorkerStoneItemInBase<E> {
    private final OutputStackHandler outputStackHandler = new OutputStackHandler(9);

    public TileCombustionWorkerStoneItemInItemOutBase() {
        this.outputStackHandler.addObserver((handler, slot) -> {
            this.resetDormantCounter();
            this.func_70296_d();
        });
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.outputStackHandler)});
        this.addInteractions(new IInteraction[]{new Interaction(this, new ItemStackHandler[]{this.getInputStackHandler(), this.outputStackHandler})});
    }

    public OutputStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    @Override
    public boolean allowInsertInput(ItemStack stack, E recipe) {
        return this.outputStackHandler.getStackInSlot(0).func_190926_b();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return false;
        }
        return facing == EnumFacing.DOWN && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputStackHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void onRecipeComplete() {
        ItemStack input = this.getInputStackHandler().getStackInSlot(0);
        MachineRecipeItemInItemOutBase recipe = (MachineRecipeItemInItemOutBase)this.getRecipe(input);
        if (recipe != null) {
            this.getInputStackHandler().setStackInSlot(0, ItemStack.field_190927_a);
            List<ItemStack> outputItems = this.getRecipeOutput(recipe, input, new ArrayList<ItemStack>());
            for (ItemStack outputItem : outputItems) {
                this.outputStackHandler.insertItem(outputItem, false);
            }
        }
    }

    protected abstract List<ItemStack> getRecipeOutput(E var1, ItemStack var2, ArrayList<ItemStack> var3);

    @Override
    protected float workerCalculateProgress(int taskIndex) {
        ItemStack itemStack = this.getInputStackHandler().getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return 0.0f;
        }
        MachineRecipeItemInItemOutBase recipe = (MachineRecipeItemInItemOutBase)this.getRecipe(itemStack);
        if (recipe == null) {
            return 0.0f;
        }
        return 1.0f - (float)this.getRemainingRecipeTimeTicks() / (float)recipe.getTimeTicks();
    }

    @Override
    public void dropContents() {
        Object stackHandler = this.getInputStackHandler();
        ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getStackInSlot(0).func_190916_E(), false);
        if (!itemStack.func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c);
        }
        stackHandler = this.getOutputStackHandler();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            itemStack = stackHandler.extractItem(i, stackHandler.getStackInSlot(i).func_190916_E(), false);
            if (itemStack.func_190926_b()) continue;
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c);
        }
        super.dropContents();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
    }

    public static class OutputStackHandler
    extends LargeDynamicStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler(int size) {
            super(size);
        }
    }

    private static class Interaction<E extends MachineRecipeBase<E>>
    extends InteractionItemStack<TileCombustionWorkerStoneBase<E>> {
        private final TileCombustionWorkerStoneBase<E> tile;

        Interaction(TileCombustionWorkerStoneBase<E> tile, ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, tile.getInputInteractionSides(), tile.getInputInteractionBoundsTop(), new Transform(Transform.translate((double)0.5, (double)1.2, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.getRecipe(itemStack) != null;
        }

        protected boolean doExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos tilePos) {
            ItemStackHandler outputStackHandler = this.stackHandlers[1];
            int slots = outputStackHandler.getSlots();
            for (int i = 1; i < slots; ++i) {
                ItemStack extractItem = outputStackHandler.extractItem(i, outputStackHandler.getStackInSlot(i).func_190916_E(), world.field_72995_K);
                if (extractItem.func_190926_b() || world.field_72995_K) continue;
                StackHelper.addToInventoryOrSpawn((World)world, (EntityPlayer)player, (ItemStack)extractItem, (BlockPos)tilePos, (double)1.0, (boolean)false, (type == IInteraction.EnumType.MouseClick ? 1 : 0) != 0);
            }
            return super.doExtract(type, world, player, tilePos);
        }
    }
}

