/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.IObservableStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.util.FluidHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInFluidOutBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneItemInBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileCombustionWorkerStoneItemInFluidOutBase<E extends MachineRecipeItemInFluidOutBase<E>>
extends TileCombustionWorkerStoneItemInBase<E> {
    private final OutputFluidTank outputFluidTank = new OutputFluidTank(this, this.getOutputFluidTankSize());

    public TileCombustionWorkerStoneItemInFluidOutBase() {
        this.outputFluidTank.addObserver((handler, slot) -> {
            this.resetDormantCounter();
            this.func_70296_d();
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        });
        this.registerTileDataForNetwork(new ITileData[]{new TileDataFluidTank((FluidTank)this.outputFluidTank)});
        this.addInteractions(new IInteraction[]{new Interaction(this, new ItemStackHandler[]{this.getInputStackHandler()})});
    }

    protected abstract int getHotFluidTemperature();

    protected abstract boolean canHoldHotFluids();

    public FluidTank getOutputFluidTank() {
        return this.outputFluidTank;
    }

    protected int getOutputFluidTankSize() {
        return 4000;
    }

    @Override
    public boolean allowInsertInput(ItemStack stack, E recipe) {
        FluidStack fluid = this.outputFluidTank.getFluid();
        if (fluid != null && ((MachineRecipeItemInFluidOutBase)recipe).getOutput().getFluid() != fluid.getFluid()) {
            return false;
        }
        return fluid == null || fluid.amount == 0;
    }

    @Override
    protected int getAllowedRecipeInputQuantity(ItemStack insertedItems, E recipe) {
        ItemStack stackInSlot = this.getInputStackHandler().getStackInSlot(0);
        FluidStack output = ((MachineRecipeItemInFluidOutBase)recipe).getOutput();
        int outputAmount = output.amount;
        int result = 0;
        for (int i = 0; i < insertedItems.func_190916_E(); ++i) {
            output.amount = outputAmount * stackInSlot.func_190916_E() + outputAmount * (i + 1);
            if (this.getOutputFluidTank().fill(output, false) != output.amount) break;
            result = i + 1;
        }
        return result;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return false;
        }
        return facing != EnumFacing.UP && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return null;
        }
        if (facing != EnumFacing.UP && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.outputFluidTank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void onRecipeComplete() {
        ItemStackHandler inputStackHandler = this.getInputStackHandler();
        ItemStack input = inputStackHandler.getStackInSlot(0);
        MachineRecipeItemInFluidOutBase recipe = (MachineRecipeItemInFluidOutBase)this.getRecipe(input);
        if (recipe != null) {
            FluidStack recipeOutput;
            if (this.processAsynchronous()) {
                inputStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
                recipeOutput = this.getRecipeOutput(recipe, input);
                this.outputFluidTank.fill(recipeOutput, true);
            } else {
                StackHelper.decreaseStackInSlot((ItemStackHandler)inputStackHandler, (int)0, (int)1, (boolean)false);
                recipeOutput = this.getRecipeOutput(recipe, input);
                this.outputFluidTank.fill(recipeOutput, true);
            }
            FluidStack fluid = this.outputFluidTank.getFluid();
            if (fluid != null) {
                FluidHelper.playFluidFillSoundServer((Fluid)fluid.getFluid(), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
        }
    }

    protected abstract FluidStack getRecipeOutput(E var1, ItemStack var2);

    public boolean processAsynchronous() {
        return true;
    }

    @Override
    protected float workerCalculateProgress(int taskIndex) {
        ItemStack itemStack = this.getInputStackHandler().getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return 0.0f;
        }
        MachineRecipeItemInFluidOutBase recipe = (MachineRecipeItemInFluidOutBase)this.getRecipe(itemStack);
        if (recipe == null) {
            return 0.0f;
        }
        return 1.0f - (float)this.getRemainingRecipeTimeTicks() / (float)recipe.getTimeTicks();
    }

    @Override
    public void dropContents() {
        ItemStackHandler stackHandler = this.getInputStackHandler();
        ItemStack itemStack = stackHandler.extractItem(0, stackHandler.getStackInSlot(0).func_190916_E(), false);
        if (!itemStack.func_190926_b()) {
            StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)this.field_174879_c);
        }
        super.dropContents();
    }

    @Override
    protected IObservableStackHandler.IContentsChangedEventHandler getInputStackHandlerObserver() {
        if (this.processAsynchronous()) {
            return super.getInputStackHandlerObserver();
        }
        return (handler, slot) -> {
            this.recalculateRemainingTime(handler.getStackInSlot(slot));
            this.func_70296_d();
        };
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("outputFluidTank", (NBTBase)this.outputFluidTank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.outputFluidTank.readFromNBT(compound.func_74775_l("outputFluidTank"));
    }

    private class OutputFluidTank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileCombustionWorkerStoneItemInFluidOutBase<E> tile;

        OutputFluidTank(TileCombustionWorkerStoneItemInFluidOutBase<E> tile, int size) {
            super(size);
            this.tile = tile;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int filled = super.fillInternal(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        world.func_175698_g(pos.func_177984_a());
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }
    }

    private static class Interaction<E extends MachineRecipeItemInFluidOutBase<E>>
    extends InteractionItemStack<TileCombustionWorkerStoneItemInFluidOutBase<E>> {
        private final TileCombustionWorkerStoneItemInFluidOutBase<E> tile;

        Interaction(TileCombustionWorkerStoneItemInFluidOutBase<E> tile, ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, tile.getInputInteractionSides(), tile.getInputInteractionBoundsTop(), new Transform(Transform.translate((double)0.5, (double)1.2, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            MachineRecipeItemInFluidOutBase recipe = (MachineRecipeItemInFluidOutBase)this.tile.getRecipe(itemStack);
            if (recipe == null) {
                return false;
            }
            int quantity = this.tile.getAllowedRecipeInputQuantity(itemStack, recipe);
            return quantity > 0;
        }
    }
}

