/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.IObservableStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.ParticleHelper;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileCombustionWorkerStoneItemInBase<E extends MachineRecipeItemInBase<E>>
extends TileCombustionWorkerStoneBase<E> {
    private final InputStackHandler inputStackHandler = new InputStackHandler(this, 1);

    public TileCombustionWorkerStoneItemInBase() {
        this.inputStackHandler.addObserver(this.getInputStackHandlerObserver());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.inputStackHandler)});
    }

    protected IObservableStackHandler.IContentsChangedEventHandler getInputStackHandlerObserver() {
        return new Observer(this);
    }

    @Override
    public boolean hasInput() {
        return !this.inputStackHandler.getStackInSlot(0).func_190926_b();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return false;
        }
        return facing == EnumFacing.UP && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.allowAutomation()) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)((Object)this.inputStackHandler);
        }
        return super.getCapability(capability, facing);
    }

    public ItemStackHandler getInputStackHandler() {
        return this.inputStackHandler;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputStackHandler", (NBTBase)this.inputStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputStackHandler.deserializeNBT(compound.func_74775_l("inputStackHandler"));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && ModuleCoreConfig.CLIENT.SHOW_RECIPE_PROGRESSION_PARTICLES && this.workerIsActive() && !this.getInputStackHandler().getStackInSlot(0).func_190926_b() && this.field_145850_b.func_82737_E() % 40L == 0L) {
            ParticleHelper.spawnProgressParticlesClient((int)1, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)((double)this.field_174879_c.func_177956_o() + 1.625), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (double)0.25, (double)0.25, (double)0.25);
        }
    }

    protected int getAllowedRecipeInputQuantity(ItemStack insertedItems, E recipe) {
        return insertedItems.func_190916_E();
    }

    protected abstract int getInputSlotSize();

    public static class Observer<E extends MachineRecipeBase<E>>
    implements IObservableStackHandler.IContentsChangedEventHandler {
        private final TileCombustionWorkerStoneBase<E> tile;
        private int lastItemCount;

        private Observer(TileCombustionWorkerStoneBase<E> tile) {
            this.tile = tile;
            this.lastItemCount = -1;
        }

        public void onContentsChanged(ItemStackHandler handler, int slot) {
            if (this.lastItemCount <= 0 && handler.getStackInSlot(slot).func_190916_E() > 0) {
                this.tile.recalculateRemainingTime(handler.getStackInSlot(slot));
            }
            this.tile.func_70296_d();
            this.lastItemCount = handler.getStackInSlot(slot).func_190916_E();
        }
    }

    private class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileCombustionWorkerStoneItemInBase<E> tile;

        InputStackHandler(TileCombustionWorkerStoneItemInBase<E> tile, int size) {
            super(size);
            this.tile = tile;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return MathHelper.func_76125_a((int)TileCombustionWorkerStoneItemInBase.this.getInputSlotSize(), (int)1, (int)64);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remainingItems = super.insertItem(slot, stack, true);
            if (remainingItems.func_190916_E() == stack.func_190916_E()) {
                return stack;
            }
            MachineRecipeItemInBase recipe = (MachineRecipeItemInBase)this.tile.getRecipe(stack);
            if (recipe == null) {
                return stack;
            }
            ItemStack insertedItems = stack.func_77946_l();
            insertedItems.func_190920_e(stack.func_190916_E() - remainingItems.func_190916_E());
            if (!this.tile.allowInsertInput(insertedItems, recipe)) {
                return stack;
            }
            int quantity = this.tile.getAllowedRecipeInputQuantity(insertedItems, recipe);
            if (quantity == 0) {
                return stack;
            }
            if (quantity < insertedItems.func_190916_E()) {
                insertedItems.func_190920_e(quantity);
            }
            super.insertItem(slot, insertedItems, simulate);
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(stack.func_190916_E() - insertedItems.func_190916_E());
            return toReturn;
        }
    }
}

