/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi;

import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.TickCounter;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.client.render.InteractionCogRenderer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileCogWorkerBase
extends TileEntityDataBase
implements ITickable,
ITileInteractable {
    private final CogStackHandler cogStackHandler;
    private final TickCounter updateTickCounter = new TickCounter(this.getUpdateIntervalTicks());
    private final TileDataBoolean triggered;
    private final TileDataItemStackHandler<CogStackHandler> tileDataItemStackHandler;
    private IInteraction<?>[] interactions;
    private boolean ready;
    @SideOnly(value=Side.CLIENT)
    private ClientRenderData clientRenderData;

    public TileCogWorkerBase(ITileDataService tileDataService) {
        super(tileDataService);
        this.cogStackHandler = new CogStackHandler(this);
        this.cogStackHandler.addObserver((handler, slot) -> {
            this.updateTickCounter.reset();
            this.func_70296_d();
        });
        this.triggered = new TileDataBoolean(false);
        this.tileDataItemStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.cogStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataItemStackHandler, this.triggered});
        this.interactions = new IInteraction[]{new InteractionCog(this, (ItemStackHandler)this.cogStackHandler, this.getCogInteractionBounds(), this.getCogInteractionTransform())};
    }

    protected void addInteractions(IInteraction<?>[] interactions) {
        this.interactions = (IInteraction[])ArrayHelper.combine(this.interactions, interactions);
    }

    protected Transform getCogInteractionTransform() {
        return new Transform(Transform.translate((double)0.5, (double)0.4375, (double)0.125), Transform.rotate(), Transform.scale((double)0.75, (double)0.75, (double)2.0));
    }

    protected AxisAlignedBB getCogInteractionBounds() {
        return AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ClientRenderData getClientRenderData() {
        if (this.clientRenderData == null) {
            this.clientRenderData = new ClientRenderData();
        }
        return this.clientRenderData;
    }

    public CogStackHandler getCogStackHandler() {
        return this.cogStackHandler;
    }

    protected abstract boolean isValidCog(ItemStack var1);

    protected abstract int getUpdateIntervalTicks();

    protected ItemStack getCog() {
        return this.cogStackHandler.getStackInSlot(0);
    }

    protected abstract int doWork(ItemStack var1);

    protected abstract boolean isPowered();

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack cog = this.cogStackHandler.getStackInSlot(0);
        if (cog.func_190926_b()) {
            return;
        }
        if (this.updateTickCounter != null && this.updateTickCounter.increment()) {
            this.ready = true;
        }
        if (this.isPowered()) {
            return;
        }
        if (this.ready) {
            this.updateTickCounter.reset();
            this.ready = false;
            int cogDamage = this.doWork(cog);
            if (cogDamage >= 0) {
                ItemStack actualCog = this.cogStackHandler.extractItem(0, 1, false);
                if (!ModuleTechMachineConfig.isCogIndestructible(actualCog.func_77973_b()) && (actualCog.func_96631_a(cogDamage, RandomHelper.random(), null) || actualCog.func_77952_i() == actualCog.func_77958_k())) {
                    SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.BLOCKS);
                } else {
                    this.cogStackHandler.insertItem(0, actualCog, false);
                }
                this.triggered.set(true);
                return;
            }
        }
        this.triggered.set(false);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("cogStackHandler", (NBTBase)this.cogStackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cogStackHandler.deserializeNBT(compound.func_74775_l("cogStackHandler"));
    }

    @SideOnly(value=Side.CLIENT)
    public void onTileDataUpdate() {
        ClientRenderData data = this.getClientRenderData();
        if (this.triggered.isDirty() && this.triggered.get()) {
            this.onClientAnimationTriggered(data);
        }
        if (this.tileDataItemStackHandler.isDirty() && this.cogStackHandler.getStackInSlot(0).func_190926_b()) {
            this.onClientCogAnimationReset(data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void onClientAnimationTriggered(ClientRenderData data) {
        data.remainingAnimationTime = data.totalAnimationTime = (double)Math.min(this.getUpdateIntervalTicks(), 40);
        data.cogRotationStage = (data.cogRotationStage + 1) % 8;
    }

    @SideOnly(value=Side.CLIENT)
    protected void onClientCogAnimationReset(ClientRenderData data) {
        data.remainingAnimationTime = -1.0;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientRenderData {
        public double remainingAnimationTime;
        public double totalAnimationTime;
        public int cogRotationStage;
    }

    public static class CogStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileCogWorkerBase tile;

        CogStackHandler(TileCogWorkerBase tile) {
            super(1);
            this.tile = tile;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.tile.isValidCog(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    public static class InteractionCog
    extends InteractionItemStack<TileCogWorkerBase> {
        private final TileCogWorkerBase tile;

        InteractionCog(TileCogWorkerBase tile, ItemStackHandler stackHandler, AxisAlignedBB bounds, Transform transform) {
            super(new ItemStackHandler[]{stackHandler}, 0, EnumFacing.field_82609_l, bounds, transform);
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isValidCog(itemStack);
        }

        public TileCogWorkerBase getTile() {
            return this.tile;
        }

        @SideOnly(value=Side.CLIENT)
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            InteractionCogRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return InteractionCogRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

