/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.FacingHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.spi.TileAnvilBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.client.render.InteractionTripHammerToolRenderer;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileTripHammer
extends TileCogWorkerBase {
    private final ToolStackHandler toolStackHandler = new ToolStackHandler(this);
    private final TileDataItemStackHandler<ToolStackHandler> tileDataToolStackHandler;
    @SideOnly(value=Side.CLIENT)
    private double remainingToolAnimationTime;
    @SideOnly(value=Side.CLIENT)
    private double totalToolAnimationTime;

    public TileTripHammer() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
        this.toolStackHandler.addObserver((stackHandler, slotIndex) -> this.func_70296_d());
        this.tileDataToolStackHandler = new TileDataItemStackHandler((ItemStackHandler)this.toolStackHandler);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataToolStackHandler});
        this.addInteractions(new IInteraction[]{new InteractionTool(this, (ItemStackHandler)this.toolStackHandler)});
    }

    @SideOnly(value=Side.CLIENT)
    public double getRemainingToolAnimationTime() {
        return this.remainingToolAnimationTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRemainingToolAnimationTime(double remainingToolAnimationTime) {
        this.remainingToolAnimationTime = remainingToolAnimationTime;
    }

    @SideOnly(value=Side.CLIENT)
    public double getTotalToolAnimationTime() {
        return this.totalToolAnimationTime;
    }

    private boolean isValidTool(ItemStack itemStack) {
        return AnvilRecipe.getTypeFromItemStack(itemStack) != null;
    }

    public ItemStackHandler getToolStackHandler() {
        return this.toolStackHandler;
    }

    @Override
    protected boolean isValidCog(ItemStack itemStack) {
        return ModuleTechMachineConfig.TRIP_HAMMER.isValidCog(itemStack.func_77973_b().getRegistryName());
    }

    @Override
    protected int getUpdateIntervalTicks() {
        return Math.max(ModuleTechMachineConfig.TRIP_HAMMER.INTERVAL_TICKS, 40);
    }

    @Override
    protected boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    @Override
    protected Transform getCogInteractionTransform() {
        return new Transform(Transform.translate((double)0.0, (double)0.5, (double)0.5), Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)90.0), Transform.scale((double)0.75, (double)0.75, (double)2.0));
    }

    @Override
    protected AxisAlignedBB getCogInteractionBounds() {
        return AABBHelper.create((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    }

    @Override
    protected int doWork(ItemStack cog) {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing tileFacing = this.getTileFacing(this.field_145850_b, this.field_174879_c, blockState);
        BlockPos anvilPos = this.field_174879_c.func_177972_a(tileFacing);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(anvilPos);
        if (!(tileEntity instanceof TileAnvilBase)) {
            return -1;
        }
        ItemStack toolItemStack = this.toolStackHandler.getStackInSlot(0);
        AnvilRecipe.EnumType type = AnvilRecipe.getTypeFromItemStack(toolItemStack);
        if (toolItemStack.func_190926_b() || type == null) {
            return -1;
        }
        TileAnvilBase tileAnvil = (TileAnvilBase)tileEntity;
        ItemStack inputItemStack = tileAnvil.getStackHandler().getStackInSlot(0);
        if (inputItemStack.func_190926_b()) {
            return -1;
        }
        AnvilRecipe recipe = AnvilRecipe.getRecipe(inputItemStack, tileAnvil.getRecipeTier(), type);
        if (recipe == null) {
            return -1;
        }
        List<ItemStack> itemStackList = tileAnvil.doInteraction(toolItemStack, null, 0.5f, 0.375f, 0.5f);
        if (toolItemStack.func_96631_a(1, RandomHelper.random(), null)) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.75f, (float)(1.0 + Util.RANDOM.nextGaussian() * (double)0.4f));
            toolItemStack.func_190918_g(1);
            this.toolStackHandler.setStackInSlot(0, toolItemStack);
        }
        if (itemStackList.isEmpty()) {
            return 1;
        }
        EnumFacing storageFacing = FacingHelper.rotateFacingCW((EnumFacing)tileFacing);
        BlockPos storagePos = this.field_174879_c.func_177972_a(storageFacing);
        TileEntity tileStorage = this.field_145850_b.func_175625_s(storagePos);
        if (tileStorage == null) {
            for (ItemStack itemStack : itemStackList) {
                StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)anvilPos, (double)0.0);
            }
        } else {
            IItemHandler capability = (IItemHandler)tileStorage.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, storageFacing.func_176734_d());
            if (capability == null) {
                for (ItemStack itemStack : itemStackList) {
                    StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)anvilPos, (double)0.0);
                }
            } else {
                for (ItemStack itemStack : itemStackList) {
                    for (int i = 0; i < capability.getSlots() && !(itemStack = capability.insertItem(i, itemStack, false)).func_190926_b(); ++i) {
                    }
                    if (itemStack.func_190926_b()) continue;
                    StackHelper.spawnStackOnTop((World)this.field_145850_b, (ItemStack)itemStack, (BlockPos)anvilPos, (double)0.0);
                }
            }
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void onClientAnimationTriggered(TileCogWorkerBase.ClientRenderData data) {
        super.onClientAnimationTriggered(data);
        this.remainingToolAnimationTime = this.totalToolAnimationTime = (double)Math.max(this.getUpdateIntervalTicks(), 80);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("toolStackHandler", (NBTBase)this.toolStackHandler.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.toolStackHandler.deserializeNBT(compound.func_74775_l("toolStackHandler"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onTileDataUpdate() {
        super.onTileDataUpdate();
        if (this.tileDataToolStackHandler.isDirty() && this.toolStackHandler.getStackInSlot(0).func_190926_b()) {
            this.remainingToolAnimationTime = -1.0;
        }
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechMachineConfig.STAGES_TRIP_HAMMER;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.TRIP_HAMMER) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }

    private static class ToolStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        private final TileTripHammer tile;

        public ToolStackHandler(TileTripHammer tile) {
            super(1);
            this.tile = tile;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.tile.isValidTool(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }

    public static class InteractionTool
    extends InteractionItemStack<TileTripHammer> {
        private final TileTripHammer tile;

        InteractionTool(TileTripHammer tile, ItemStackHandler stackHandler) {
            super(new ItemStackHandler[]{stackHandler}, 0, new EnumFacing[]{EnumFacing.NORTH, EnumFacing.UP}, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)1.25, (double)0.25), Transform.rotate((double)0.0, (double)1.0, (double)0.0, (double)270.0).multLocal(Transform.rotate((double)0.0, (double)0.0, (double)1.0, (double)45.0)), Transform.scale((double)1.0, (double)1.0, (double)1.0)));
            this.tile = tile;
        }

        public TileTripHammer getTile() {
            return this.tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return this.tile.isValidTool(itemStack);
        }

        @SideOnly(value=Side.CLIENT)
        public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
            InteractionTripHammerToolRenderer.INSTANCE.renderSolidPass(this, world, renderItem, pos, blockState, partialTicks);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
            return InteractionTripHammerToolRenderer.INSTANCE.renderAdditivePass(this, world, renderItem, hitSide, hitVec, hitPos, blockState, heldItemMainHand, partialTicks);
        }
    }
}

