/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.block.BlockMechanicalHopper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCogWorkerBase;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileStoneHopper
extends TileCogWorkerBase {
    public TileStoneHopper() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
    }

    protected int getTransferAmount(ItemStack cog) {
        return ModuleTechMachineConfig.STONE_HOPPER.getCogTransferAmount(cog.func_77973_b().getRegistryName());
    }

    @Override
    protected int getUpdateIntervalTicks() {
        return ModuleTechMachineConfig.STONE_HOPPER.TRANSFER_INTERVAL_TICKS;
    }

    @Override
    protected boolean isValidCog(ItemStack itemStack) {
        return ModuleTechMachineConfig.STONE_HOPPER.getCogTransferAmount(itemStack.func_77973_b().getRegistryName()) > -1;
    }

    @Override
    protected int doWork(ItemStack cog) {
        TileEntity tileSource = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        BlockMechanicalHopper.EnumType type = (BlockMechanicalHopper.EnumType)((Object)blockState.func_177229_b(BlockMechanicalHopper.TYPE));
        if (type == BlockMechanicalHopper.EnumType.Down) {
            facing = EnumFacing.UP;
        }
        TileEntity tileTarget = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
        if (tileSource == null || tileTarget == null) {
            return -1;
        }
        IItemHandler handlerSource = (IItemHandler)tileSource.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        IItemHandler handlerTarget = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        if (handlerSource == null || handlerTarget == null) {
            return -1;
        }
        int amount = Math.min(cog.func_77958_k() - cog.func_77952_i(), this.getTransferAmount(cog));
        int totalInserted = 0;
        for (int slotSource = 0; slotSource < handlerSource.getSlots(); ++slotSource) {
            int slotTarget;
            boolean canTransfer = false;
            ItemStack stackSource = handlerSource.extractItem(slotSource, amount, true);
            int initialCount = stackSource.func_190916_E();
            if (stackSource != ItemStack.field_190927_a) {
                for (slotTarget = 0; slotTarget < handlerTarget.getSlots(); ++slotTarget) {
                    int before = stackSource.func_190916_E();
                    stackSource = handlerTarget.insertItem(slotTarget, stackSource, true);
                    totalInserted += before - stackSource.func_190916_E();
                    if (stackSource.func_190926_b()) {
                        canTransfer = true;
                        break;
                    }
                    if (stackSource.func_190916_E() == initialCount) continue;
                    canTransfer = true;
                }
            }
            if (!canTransfer) continue;
            stackSource = handlerSource.extractItem(slotSource, totalInserted, false);
            initialCount = stackSource.func_190916_E();
            for (slotTarget = 0; slotTarget < handlerTarget.getSlots() && !(stackSource = handlerTarget.insertItem(slotTarget, stackSource, false)).func_190926_b(); ++slotTarget) {
            }
            SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)SoundEvents.field_187715_dR, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f);
            int cogDamage = 1;
            if (ModuleTechMachineConfig.STONE_HOPPER.COG_DAMAGE_TYPE == ModuleTechMachineConfig.StoneHopper.EnumCogDamageType.PerItem) {
                cogDamage = initialCount - stackSource.func_190916_E();
            }
            return cogDamage;
        }
        return -1;
    }

    @Override
    protected boolean isPowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechMachineConfig.STAGES_MECHANICAL_HOPPER;
    }

    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.STONE_HOPPER) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return super.getTileFacing(world, pos, blockState);
    }
}

