/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.GameStages;
import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataBase;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.IAirflowConsumerCapability;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;

public class TileBellows
extends TileEntityDataBase
implements ITickable {
    private final TileDataFloat progress = new TileDataFloat(0.0f, 1);
    private float time;

    public TileBellows() {
        super(ModuleTechMachine.TILE_DATA_SERVICE);
        this.registerTileDataForNetwork(new ITileData[]{this.progress});
    }

    public float getProgress() {
        return Math.max(0.0f, Math.min(1.0f, this.progress.get()));
    }

    protected float getProgressIncrementDown() {
        return 1.0f / (float)this.getTotalTicksDown();
    }

    protected float getProgressIncrementUp() {
        return -1.0f / (float)this.getTotalTicksUp();
    }

    protected int getTotalTicksDown() {
        return ModuleTechMachineConfig.BELLOWS.TRAVEL_TIME_DOWN_TICKS;
    }

    protected int getTotalTicksUp() {
        return ModuleTechMachineConfig.BELLOWS.TRAVEL_TIME_UP_TICKS;
    }

    protected float getAirflow() {
        float baseAirflow = this.getBaseAirflow();
        float time = MathHelper.func_76131_a((float)this.time, (float)0.0f, (float)1.0f);
        float modulatedAirflow = (double)time < 0.25 ? (float)((double)baseAirflow * (512.0 * Math.pow(time, 5.0))) : (float)((double)baseAirflow * (4.0 * Math.pow((double)time - 0.75, 3.0) + 1.0));
        return modulatedAirflow * 2.0f;
    }

    protected float getBaseAirflow() {
        return (float)ModuleTechMachineConfig.BELLOWS.BASE_AIRFLOW;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.shouldProgress()) {
            if (this.progress.get() < 1.0f) {
                this.progress.add(this.getProgressIncrementDown());
                if (this.progress.get() > 1.0f) {
                    this.progress.set(1.0f);
                }
                List<BlockPos> airflowPushPositions = this.getAirflowPushPositions(new ArrayList<BlockPos>(3));
                List<EnumFacing> airflowPushFacings = this.getAirflowPushFacings(new ArrayList<EnumFacing>(3));
                for (int i = 0; i < airflowPushPositions.size(); ++i) {
                    BlockPos blockPos = airflowPushPositions.get(i);
                    EnumFacing facing = i >= airflowPushFacings.size() ? EnumFacing.NORTH : airflowPushFacings.get(i);
                    this.pushAirflow(blockPos, facing);
                }
            }
            this.time += this.getProgressIncrementDown();
            if (this.time > 1.0f) {
                this.time = 1.0f;
            }
        } else {
            if (this.progress.get() > 0.0f) {
                this.progress.add(this.getProgressIncrementUp());
                if (this.progress.get() < 0.0f) {
                    this.progress.set(0.0f);
                }
            }
            this.time = 0.0f;
        }
    }

    protected void pushAirflow(BlockPos blockPos, EnumFacing facing) {
        IAirflowConsumerCapability airflowConsumer;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
        if (tileEntity != null && (airflowConsumer = (IAirflowConsumerCapability)tileEntity.getCapability(ModuleCore.CAPABILITY_AIRFLOW_CONSUMER, facing.func_176734_d())) != null) {
            airflowConsumer.consumeAirflow(this.getAirflow(), false);
        }
    }

    protected List<BlockPos> getAirflowPushPositions(List<BlockPos> result) {
        result.add(this.field_174879_c.func_177972_a(this.getFacing()));
        return result;
    }

    protected List<EnumFacing> getAirflowPushFacings(List<EnumFacing> result) {
        result.add(this.getFacing());
        return result;
    }

    protected EnumFacing getFacing() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState.func_177230_c() == ModuleTechMachine.Blocks.BELLOWS) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return EnumFacing.NORTH;
    }

    protected boolean shouldProgress() {
        AxisAlignedBB bounds = new AxisAlignedBB(this.field_174879_c).func_72317_d(0.0, 1.0 - (double)this.getProgress() * 0.5, 0.0);
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, bounds);
        if (!entities.isEmpty()) {
            for (EntityLivingBase entity : entities) {
                double bellowsHeight = (double)(1 + this.field_174879_c.func_177956_o()) - (double)this.getProgress() * 0.5;
                if (entity.field_70163_u < bellowsHeight) {
                    entity.field_70163_u = bellowsHeight + (double)0.001f;
                }
                if (!(entity instanceof EntityPlayer) || !(entity.field_70163_u - 0.05 < bellowsHeight)) continue;
                if (Loader.isModLoaded((String)"gamestages")) {
                    return GameStages.allowed((EntityPlayer)((EntityPlayer)entity), (Stages)this.getStages());
                }
                return true;
            }
        }
        return false;
    }

    private Stages getStages() {
        return ModuleTechMachineConfig.STAGES_BELLOWS;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("progress", this.progress.get());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progress.set(compound.func_74760_g("progress"));
    }
}

