/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.waila.provider;

import com.codetaylor.mc.pyrotech.library.spi.plugin.waila.BodyProviderAdapter;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.library.util.plugin.waila.WailaUtil;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.waila.delegate.CombustionMachineItemInItemOutProviderDelegate;
import com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.waila.delegate.CombustionMachineProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.spi.MachineRecipeItemInItemOutBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCapabilityDelegateMachineTop;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileCombustionWorkerStoneItemInItemOutBase;
import com.codetaylor.mc.pyrotech.modules.tech.machine.tile.spi.TileSawmillBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class SawmillProvider
extends BodyProviderAdapter
implements CombustionMachineItemInItemOutProviderDelegate.ICombustionMachineItemInItemOutDisplay {
    private final CombustionMachineProviderDelegateBase<CombustionMachineItemInItemOutProviderDelegate.ICombustionMachineItemInItemOutDisplay, TileCombustionWorkerStoneItemInItemOutBase, MachineRecipeItemInItemOutBase> delegate = new CombustionMachineItemInItemOutProviderDelegate(this);
    private List<String> tooltip;
    private TileSawmillBase tile;

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileSawmillBase || tileEntity instanceof TileCapabilityDelegateMachineTop) {
            TileSawmillBase tile = null;
            if (tileEntity instanceof TileSawmillBase) {
                tile = (TileSawmillBase)tileEntity;
            } else {
                World world = tileEntity.func_145831_w();
                TileEntity candidate = world.func_175625_s(tileEntity.func_174877_v().func_177977_b());
                if (candidate instanceof TileSawmillBase) {
                    tile = (TileSawmillBase)candidate;
                }
            }
            if (tile == null) {
                return tooltip;
            }
            this.tile = tile;
            this.tooltip = tooltip;
            this.delegate.display(tile);
            this.tile = null;
            this.tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void setRecipeProgress(ItemStack input, ItemStack fuel, MachineRecipeItemInItemOutBase recipe, int progress, int maxProgress) {
        TileSawmillBase.BladeStackHandler bladeStackHandler = this.tile.getBladeStackHandler();
        ItemStack blade = bladeStackHandler.getStackInSlot(0);
        StringBuilder renderString = new StringBuilder();
        renderString.append(WailaUtil.getStackRenderString(input));
        if (!blade.func_190926_b()) {
            renderString.append(WailaUtil.getStackRenderString(blade));
        }
        if (!fuel.func_190926_b()) {
            renderString.append(WailaUtil.getStackRenderString(fuel));
        }
        if (recipe != null) {
            ItemStack recipeOutput = recipe.getOutput();
            recipeOutput.func_190920_e(recipeOutput.func_190916_E() * input.func_190916_E());
            renderString.append(WailaUtil.getProgressRenderString(progress, maxProgress));
            renderString.append(WailaUtil.getStackRenderString(recipeOutput));
        }
        this.tooltip.add(renderString.toString());
    }

    @Override
    public void setRecipeDuration(String langKey, String duration) {
        this.tooltip.add(Util.translateFormatted(langKey, duration));
    }

    @Override
    public void setOutputItems(ItemStackHandler outputStackHandler) {
        TileSawmillBase.BladeStackHandler bladeStackHandler = this.tile.getBladeStackHandler();
        ItemStack blade = bladeStackHandler.getStackInSlot(0);
        StringBuilder renderString = new StringBuilder();
        if (!blade.func_190926_b()) {
            renderString.append(WailaUtil.getStackRenderString(blade));
        }
        for (int i = 0; i < outputStackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = outputStackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            renderString.append(WailaUtil.getStackRenderString(stackInSlot));
        }
        this.tooltip.add(renderString.toString());
    }

    @Override
    public void optionalNoInputNoOutput() {
        TileSawmillBase.BladeStackHandler bladeStackHandler = this.tile.getBladeStackHandler();
        ItemStack blade = bladeStackHandler.getStackInSlot(0);
        if (!blade.func_190926_b()) {
            this.tooltip.add(WailaUtil.getStackRenderString(blade));
        }
    }

    @Override
    public void optionalPreBurnTimeInfo() {
        TileSawmillBase.BladeStackHandler bladeStackHandler = this.tile.getBladeStackHandler();
        ItemStack blade = bladeStackHandler.getStackInSlot(0);
        if (!blade.func_190926_b()) {
            this.tooltip.add(Util.translateFormatted("gui.pyrotech.waila.sawmill.blade", blade.func_77973_b().func_77653_i(blade)));
        }
    }

    @Override
    public void setBurnTime(@Nullable TextFormatting formatting, String langKey, String burnTimeString) {
        String formattingString = formatting != null ? formatting.toString() : "";
        this.tooltip.add(formattingString + Util.translateFormatted(langKey, burnTimeString));
    }

    @Override
    public void setFuel(String langKey, ItemStack fuel, String count) {
        this.tooltip.add(Util.translateFormatted(langKey, fuel.func_82833_r(), count));
    }
}

