/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.athenaeum.util.RecipeHelper;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.core.plugin.crafttweaker.ZenStages;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.init.recipe.BrickSawmillRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.StoneSawmillRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.StoneSawmill")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/stone_sawmill.example.md"})
@ZenClass(value="mods.pyrotech.StoneSawmill")
public class ZenStoneSawmill {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="burnTimeTicks", info="recipe duration in ticks"), @ZenDocArg(arg="blade", info="blade(s) used"), @ZenDocArg(arg="woodChips", info="amount of wood chips produced per recipe"), @ZenDocArg(arg="inherited", info="true if the recipe should be inherited")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int burnTimeTicks, IIngredient blade, @Optional(valueLong=0L) int woodChips, @Optional boolean inherited) {
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getIngredient((IIngredient)input), burnTimeTicks, CraftTweakerMC.getIngredient((IIngredient)blade), woodChips, inherited));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(IIngredient output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(CraftTweakerMC.getIngredient((IIngredient)output)));
    }

    @ZenDocMethod(order=3)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<StoneSawmillRecipe>(ModuleTechMachine.Registries.STONE_SAWMILL_RECIPES, "stone sawmill"));
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="stages", info="game stages")}, description={"Sets game stage logic required to use the device."})
    @ZenMethod
    public static void setGameStages(ZenStages stages) {
        ModuleTechMachineConfig.STAGES_STONE_SAWMILL = stages.getStages();
    }

    public static class AddRecipe
    implements IAction {
        private final String name;
        private final ItemStack output;
        private final Ingredient input;
        private final int burnTimeTicks;
        private final Ingredient blade;
        private final int woodChips;
        private final boolean inherited;

        public AddRecipe(String name, ItemStack output, Ingredient input, int burnTimeTicks, Ingredient blade, int woodChips, boolean inherited) {
            this.name = name;
            this.input = input;
            this.output = output;
            this.burnTimeTicks = burnTimeTicks;
            this.blade = blade;
            this.woodChips = woodChips;
            this.inherited = inherited;
        }

        public void apply() {
            StoneSawmillRecipe recipe = new StoneSawmillRecipe(this.output, this.input, this.burnTimeTicks, this.blade, this.woodChips);
            ModuleTechMachine.Registries.STONE_SAWMILL_RECIPES.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
            if (this.inherited) {
                RecipeHelper.inherit((String)"stone_sawmill", ModuleTechMachine.Registries.BRICK_SAWMILL_RECIPES, BrickSawmillRecipesAdd.INHERIT_TRANSFORMER, (IForgeRegistryEntry)recipe);
            }
        }

        public String describe() {
            return "Adding stone sawmill recipe for " + this.output + ", inherited=" + this.inherited;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final Ingredient output;

        public RemoveRecipe(Ingredient output) {
            this.output = output;
        }

        public void apply() {
            StoneSawmillRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing stone sawmill recipes for " + this.output;
        }
    }
}

