/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.core.plugin.crafttweaker.ZenStages;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachineConfig;
import com.codetaylor.mc.pyrotech.modules.tech.machine.recipe.BrickKilnRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.BrickKiln")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/brick_kiln.example.md"})
@ZenClass(value="mods.pyrotech.BrickKiln")
public class ZenBrickKiln {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="burnTimeTicks", info="recipe duration in ticks")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int burnTimeTicks) {
        ZenBrickKiln.addRecipe(name, output, input, burnTimeTicks, 0.0f, new IItemStack[0]);
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="burnTimeTicks", info="recipe duration in ticks"), @ZenDocArg(arg="failureChance", info="chance for item to fail conversion"), @ZenDocArg(arg="failureItems", info="array of randomly chosen failure items")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, int burnTimeTicks, float failureChance, IItemStack[] failureItems) {
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getIngredient((IIngredient)input), burnTimeTicks, failureChance, CraftTweakerMC.getItemStacks((IItemStack[])failureItems)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(IIngredient output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(CraftTweakerMC.getIngredient((IIngredient)output)));
    }

    @ZenDocMethod(order=4)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<BrickKilnRecipe>(ModuleTechMachine.Registries.BRICK_KILN_RECIPES, "brick kiln"));
    }

    @ZenDocMethod(order=5, args={@ZenDocArg(arg="stages", info="game stages")}, description={"Sets game stage logic required to use the device."})
    @ZenMethod
    public static void setGameStages(ZenStages stages) {
        ModuleTechMachineConfig.STAGES_BRICK_KILN = stages.getStages();
    }

    public static class AddRecipe
    implements IAction {
        private final ItemStack output;
        private final String name;
        private final Ingredient input;
        private final int burnTimeTicks;
        private final float failureChance;
        private final ItemStack[] failureItems;

        public AddRecipe(String name, ItemStack output, Ingredient input, int burnTimeTicks, float failureChance, ItemStack[] failureItems) {
            this.name = name;
            this.input = input;
            this.output = output;
            this.burnTimeTicks = burnTimeTicks;
            this.failureChance = failureChance;
            this.failureItems = failureItems;
        }

        public void apply() {
            BrickKilnRecipe recipe = new BrickKilnRecipe(this.output, this.input, this.burnTimeTicks, this.failureChance, this.failureItems);
            ModuleTechMachine.Registries.BRICK_KILN_RECIPES.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        public String describe() {
            return "Adding brick kiln recipe for " + this.output;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final Ingredient output;

        public RemoveRecipe(Ingredient output) {
            this.output = output;
        }

        public void apply() {
            BrickKilnRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing brick kiln recipes for " + this.output;
        }
    }
}

