/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.machine;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.pyrotech.modules.tech.machine.ModuleTechMachine;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Config;

@Config(modid="pyrotech", name="pyrotech/module.tech.Machine")
public class ModuleTechMachineConfig {
    @Config.Ignore
    public static Stages STAGES_BRICK_CRUCIBLE = null;
    @Config.Ignore
    public static Stages STAGES_BRICK_KILN = null;
    @Config.Ignore
    public static Stages STAGES_BRICK_OVEN = null;
    @Config.Ignore
    public static Stages STAGES_BRICK_SAWMILL = null;
    @Config.Ignore
    public static Stages STAGES_STONE_CRUCIBLE = null;
    @Config.Ignore
    public static Stages STAGES_STONE_KILN = null;
    @Config.Ignore
    public static Stages STAGES_STONE_OVEN = null;
    @Config.Ignore
    public static Stages STAGES_STONE_SAWMILL = null;
    @Config.Ignore
    public static Stages STAGES_MECHANICAL_HOPPER = null;
    @Config.Ignore
    public static Stages STAGES_MECHANICAL_MULCHER = null;
    @Config.Ignore
    public static Stages STAGES_TRIP_HAMMER = null;
    @Config.Ignore
    public static Stages STAGES_BELLOWS = null;
    @Config.Ignore
    public static Stages STAGES_MECHANICAL_BELLOWS = null;
    public static General GENERAL = new General();
    public static SawmillSounds SAWMILL_SOUNDS = new SawmillSounds();
    public static SawmillBlades SAWMILL_BLADES = new SawmillBlades();
    public static Cogs COGS = new Cogs();
    public static StoneHopper STONE_HOPPER = new StoneHopper();
    public static Bellows BELLOWS = new Bellows();
    public static TripHammer TRIP_HAMMER = new TripHammer();
    public static MechanicalBellows MECHANICAL_BELLOWS = new MechanicalBellows();
    public static MechanicalCompactingBin MECHANICAL_COMPACTING_BIN = new MechanicalCompactingBin();
    public static MechanicalMulchSpreader MECHANICAL_MULCH_SPREADER = new MechanicalMulchSpreader();
    public static StoneKiln STONE_KILN = new StoneKiln();
    public static BrickKiln BRICK_KILN = new BrickKiln();
    public static StoneOven STONE_OVEN = new StoneOven();
    public static BrickOven BRICK_OVEN = new BrickOven();
    public static StoneSawmill STONE_SAWMILL = new StoneSawmill();
    public static BrickSawmill BRICK_SAWMILL = new BrickSawmill();
    public static StoneCrucible STONE_CRUCIBLE = new StoneCrucible();
    public static BrickCrucible BRICK_CRUCIBLE = new BrickCrucible();

    public static boolean isSawbladeIndestructible(Item item) {
        ResourceLocation resourceLocation = item.getRegistryName();
        if (resourceLocation == null) {
            return false;
        }
        return ArrayHelper.contains((Object[])ModuleTechMachineConfig.SAWMILL_BLADES.INDESTRUCTIBLE_SAWBLADES, (Object)resourceLocation.toString());
    }

    public static boolean isCogIndestructible(Item item) {
        ResourceLocation resourceLocation = item.getRegistryName();
        if (resourceLocation == null) {
            return false;
        }
        return ArrayHelper.contains((Object[])ModuleTechMachineConfig.COGS.INDESTRUCTIBLE_COGS, (Object)resourceLocation.toString());
    }

    public static class BrickCrucible {
        @Config.Comment(value={"If true, the device will use a skin that looks like parts of it are made", "from iron. Making the device from iron fits with the default mod progression,", "but may not fit with your modpack. Disabling this will use a different", "skin that looks like only the refractory bricks."})
        public boolean USE_IRON_SKIN = true;
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: true"})
        public boolean KEEP_HEAT = true;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 2.0"})
        public double FUEL_BURN_TIME_MODIFIER = 2.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 32"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 32;
        @Config.Comment(value={"Controls the size of the output tank in millibuckets.", "Default: 8000"})
        @Config.RangeInt(min=1)
        public int OUTPUT_TANK_SIZE = 8000;
        @Config.Comment(value={"If true, the machine will process all input items at the same time.", "If false, the machine will process one recipe at a time.", "Default: true"})
        public boolean ASYNCHRONOUS_OPERATION = true;
        @Config.Comment(value={"If true, all the stone tier recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_STONE_TIER_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited recipes.", "Default: 1.0"})
        public double INHERITED_STONE_TIER_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"The temperature that the container considers hot.", "The temperature of lava is 1300 and water is 300", "Default: 450"})
        @Config.RangeInt
        public int HOT_TEMPERATURE = 450;
        @Config.Comment(value={"If false, the container will break when a hot fluid is placed inside,", "and the fluid will spawn in the world where the tank was.", "Default: true"})
        public boolean HOLDS_HOT_FLUIDS = true;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.5"})
        public double AIRFLOW_MODIFIER = 1.5;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.01;
    }

    public static class StoneCrucible {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: false"})
        public boolean KEEP_HEAT = false;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 1.0"})
        public double FUEL_BURN_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 16;
        @Config.Comment(value={"Controls the size of the output tank in millibuckets.", "Default: 4000"})
        @Config.RangeInt(min=1)
        public int OUTPUT_TANK_SIZE = 4000;
        @Config.Comment(value={"If true, the machine will process all input items at the same time.", "If false, the machine will process one recipe at a time.", "Default: true"})
        public boolean ASYNCHRONOUS_OPERATION = true;
        @Config.Comment(value={"The temperature that the container considers hot.", "The temperature of lava is 1300 and water is 300", "Default: 450"})
        @Config.RangeInt
        public int HOT_TEMPERATURE = 450;
        @Config.Comment(value={"If false, the container will break when a hot fluid is placed inside,", "and the fluid will spawn in the world where the tank was.", "Default: false"})
        public boolean HOLDS_HOT_FLUIDS = false;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.0"})
        public double AIRFLOW_MODIFIER = 1.0;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.02;
    }

    public static class BrickSawmill {
        @Config.Comment(value={"If true, the device will use a skin that looks like parts of it are made", "from iron. Making the device from iron fits with the default mod progression,", "but may not fit with your modpack. Disabling this will use a different", "skin that looks like only the refractory bricks."})
        public boolean USE_IRON_SKIN = true;
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: true"})
        public boolean KEEP_HEAT = true;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 2.0"})
        public double FUEL_BURN_TIME_MODIFIER = 2.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 32"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 32;
        @Config.Comment(value={"Controls how much damage a spinning blade will do to an entity.", "Default: 3"})
        @Config.RangeDouble(min=0.0)
        public double ENTITY_DAMAGE_FROM_BLADE = 3.0;
        @Config.Comment(value={"Set to false to disable damaging blades.", "Default: true"})
        public boolean DAMAGE_BLADES = true;
        @Config.Comment(value={"If true, all the stone tier recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_STONE_TIER_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited recipes.", "Default: 1.0"})
        public double INHERITED_STONE_TIER_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"Valid sawmill blades.", "NOTE: Items listed here are assumed to have durability.", "Item string format is (domain):(path)"})
        public String[] SAWMILL_BLADES = new String[]{"pyrotech:sawmill_blade_stone", "pyrotech:sawmill_blade_flint", "pyrotech:sawmill_blade_bone", "pyrotech:sawmill_blade_iron", "pyrotech:sawmill_blade_gold", "pyrotech:sawmill_blade_diamond", "pyrotech:sawmill_blade_obsidian"};
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.5"})
        public double AIRFLOW_MODIFIER = 1.5;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.01;
    }

    public static class StoneSawmill {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: false"})
        public boolean KEEP_HEAT = false;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 1.0"})
        public double FUEL_BURN_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 16;
        @Config.Comment(value={"Controls how much damage a spinning blade will do to an entity.", "Default: 3"})
        @Config.RangeDouble(min=0.0)
        public double ENTITY_DAMAGE_FROM_BLADE = 3.0;
        @Config.Comment(value={"Set to false to disable damaging blades.", "Default: true"})
        public boolean DAMAGE_BLADES = true;
        @Config.Comment(value={"Valid sawmill blades.", "NOTE: Items listed here are assumed to have durability.", "Item string format is (domain):(path)"})
        public String[] SAWMILL_BLADES = new String[]{"pyrotech:sawmill_blade_stone", "pyrotech:sawmill_blade_flint", "pyrotech:sawmill_blade_bone"};
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.0"})
        public double AIRFLOW_MODIFIER = 1.0;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.02;
        @Config.Comment(value={"If true, all the chopping block recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_CHOPPING_BLOCK_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited recipes.", "Default: 1.0"})
        public double INHERITED_CHOPPING_BLOCK_RECIPE_DURATION_MODIFIER = 1.0;
    }

    public static class BrickOven {
        @Config.Comment(value={"If true, the device will use a skin that looks like parts of it are made", "from iron. Making the device from iron fits with the default mod progression,", "but may not fit with your modpack. Disabling this will use a different", "skin that looks like only the refractory bricks."})
        public boolean USE_IRON_SKIN = true;
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: true"})
        public boolean KEEP_HEAT = true;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 2.0"})
        public double FUEL_BURN_TIME_MODIFIER = 2.0;
        @Config.Comment(value={"Time to cook the entire input stack in ticks.", "Default: 2400"})
        @Config.RangeInt(min=1)
        public int COOK_TIME_TICKS = 2400;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 32"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 32;
        @Config.Comment(value={"If true, all the stone tier recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_STONE_TIER_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited recipes.", "Default: 1.0"})
        public double INHERITED_STONE_TIER_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.5"})
        public double AIRFLOW_MODIFIER = 1.5;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.01;
    }

    public static class StoneOven {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: false"})
        public boolean KEEP_HEAT = false;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 1.0"})
        public double FUEL_BURN_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Time to cook the entire input stack in ticks.", "Default: 2400"})
        @Config.RangeInt(min=1)
        public int COOK_TIME_TICKS = 2400;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 16;
        @Config.Comment(value={"If true, all the drying rack recipes will also be available in the oven.", "Default: true"})
        public boolean INHERIT_DRYING_RACK_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited drying rack recipes.", "Default: 0.25"})
        public double INHERITED_DRYING_RACK_RECIPE_DURATION_MODIFIER = 0.25;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.0"})
        public double AIRFLOW_MODIFIER = 1.0;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.02;
    }

    public static class BrickKiln {
        @Config.Comment(value={"If true, the device will use a skin that looks like parts of it are made", "from iron. Making the device from iron fits with the default mod progression,", "but may not fit with your modpack. Disabling this will use a different", "skin that looks like only the refractory bricks."})
        public boolean USE_IRON_SKIN = true;
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: true"})
        public boolean KEEP_HEAT = true;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 2.0"})
        public double FUEL_BURN_TIME_MODIFIER = 2.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 32"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 32;
        @Config.Comment(value={"If true, all the stone tier recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_STONE_TIER_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for all inherited recipes.", "Default: 1.0"})
        public double INHERITED_STONE_TIER_RECIPE_DURATION_MODIFIER = 1.0;
        @Config.Comment(value={"The failure chance modifier for all inherited recipes.", "Default: 0.25"})
        public double INHERITED_STONE_TIER_RECIPE_FAILURE_CHANCE_MODIFIER = 0.25;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.5"})
        public double AIRFLOW_MODIFIER = 1.5;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.01;
    }

    public static class StoneKiln {
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"Set to true to deactivate when a recipe completes.", "The worker will need to be re-lit when it deactivates.", "Default: false"})
        public boolean KEEP_HEAT = false;
        @Config.Comment(value={"Modifies the burn time values of the fuel used.", "Default: 1.0"})
        public double FUEL_BURN_TIME_MODIFIER = 1.0;
        @Config.Comment(value={"Controls the number of recipe items that can be inserted.", "Default: 8"})
        @Config.RangeInt(min=1, max=64)
        public int INPUT_SLOT_SIZE = 8;
        @Config.Comment(value={"Controls the number of fuel items that can be inserted.", "Default: 16"})
        @Config.RangeInt(min=1, max=64)
        public int FUEL_SLOT_SIZE = 16;
        @Config.Comment(value={"If true, all the pit kiln recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_PIT_KILN_RECIPES = true;
        @Config.Comment(value={"The recipe duration modifier for the inherited recipes.", "Default: 0.5"})
        public double INHERITED_PIT_KILN_RECIPE_DURATION_MODIFIER = 0.5;
        @Config.Comment(value={"The failure chance modifier for the inherited recipes.", "Default: 0.25"})
        public double INHERITED_PIT_KILN_RECIPE_FAILURE_CHANCE_MODIFIER = 0.25;
        @Config.Comment(value={"Multiplicative modifier applied to the airflow from a block like the", "bellows.", "Default: 1.0"})
        public double AIRFLOW_MODIFIER = 1.0;
        @Config.Comment(value={"Percentage of retained airflow lost per tick.", "Default: 0.02"})
        public double AIRFLOW_DRAG_MODIFIER = 0.02;
    }

    public static class MechanicalMulchSpreader {
        @Config.Comment(value={"A list of valid cogs for the device.", "NOTE: Items provided here are assumed to have durability.", "String format is (domain):(path) for the item (range);(attempts) for the", "range of the mulch [0, 5] and the number of attempts per", "work cycle [1, 121]."})
        public Map<String, String> COGS = new LinkedHashMap<String, String>(){
            {
                this.put("pyrotech:cog_wood", "0;1");
                this.put("pyrotech:cog_stone", "1;1");
                this.put("pyrotech:cog_flint", "2;2");
                this.put("pyrotech:cog_bone", "2;2");
                this.put("pyrotech:cog_iron", "3;2");
                this.put("pyrotech:cog_gold", "0;1");
                this.put("pyrotech:cog_obsidian", "4;4");
                this.put("pyrotech:cog_diamond", "5;8");
            }
        };
        @Config.Comment(value={"Set this to false to prevent piping contents in / out.", "Default: true"})
        public boolean ALLOW_AUTOMATION = true;
        @Config.Comment(value={"If set to PerItem, damage will be done to the cog for every block", "mulched. If set to PerOperation, damage will be done to the cog", "each time it does work, regardless of the number of blocks mulched.", "Default: PerItem"})
        public EnumCogDamageType COG_DAMAGE_TYPE = EnumCogDamageType.PerItem;
        @Config.Comment(value={"How many ticks before making an attempt to apply mulch.", "Default: 200"})
        public int WORK_INTERVAL_TICKS = 200;
        @Config.Comment(value={"The number of stacks of mulch the device can hold.", "Default: 5"})
        public int CAPACITY = 5;

        public int[] getCogData(@Nullable ResourceLocation resourceLocation, int[] result) {
            String data;
            if (resourceLocation != null && (data = this.COGS.get(resourceLocation.toString())) != null) {
                try {
                    String[] split = data.split(";");
                    result[0] = MathHelper.func_76125_a((int)Integer.parseInt(split[0]), (int)0, (int)5);
                    result[1] = MathHelper.func_76125_a((int)Integer.parseInt(split[1]), (int)1, (int)121);
                    return result;
                }
                catch (Exception e) {
                    ModuleTechMachine.LOGGER.error("Invalid mulch spreader cog data in config", (Throwable)e);
                }
            }
            result[0] = -1;
            result[1] = -1;
            return result;
        }

        public static enum EnumCogDamageType {
            PerItem,
            PerOperation;

        }
    }

    public static class MechanicalCompactingBin {
        @Config.Comment(value={"A list of valid cogs for the device.", "NOTE: Items provided here are assumed to have durability.", "String format is (domain):(path) for the item and (double) for the", "amount of recipe progress added per work cycle. The range is [0,1]."})
        public Map<String, Double> COGS = new LinkedHashMap<String, Double>(){
            {
                this.put("pyrotech:cog_wood", 0.1);
                this.put("pyrotech:cog_stone", 0.2);
                this.put("pyrotech:cog_flint", 0.25);
                this.put("pyrotech:cog_bone", 0.25);
                this.put("pyrotech:cog_iron", 0.35);
                this.put("pyrotech:cog_gold", 0.1);
                this.put("pyrotech:cog_obsidian", 0.35);
                this.put("pyrotech:cog_diamond", 0.5);
            }
        };
        @Config.Comment(value={"If true, all the compacting bin recipes will also be available in this device.", "Default: true"})
        public boolean INHERIT_COMPACTING_BIN_RECIPES = true;
        @Config.Comment(value={"How many ticks before advancing the compacting recipe.", "Default: 40"})
        public int WORK_INTERVAL_TICKS = 40;
        @Config.Comment(value={"The number of output blocks the compacting bin can hold.", "Default: 16"})
        @Config.RangeInt(min=1)
        public int INPUT_CAPACITY = 16;
        @Config.Comment(value={"The number of items the output slot can hold.", "Default: 64"})
        public int OUTPUT_CAPACITY = 64;

        public double getCogRecipeProgress(@Nullable ResourceLocation resourceLocation) {
            Double result;
            if (resourceLocation != null && (result = this.COGS.get(resourceLocation.toString())) != null) {
                return result;
            }
            return -1.0;
        }
    }

    public static class MechanicalBellows {
        @Config.Comment(value={"The number of ticks that the device takes to return to the up position.", "NOTE: Must be smaller than the travel time down.", "Default: 10"})
        @Config.RangeInt(min=1)
        public int TRAVEL_TIME_UP_TICKS = 10;
        @Config.Comment(value={"The number of ticks that the device takes to reach the down position.", "NOTE: Must be larger than the travel time up.", "Default: 100"})
        @Config.RangeInt(min=1)
        public int TRAVEL_TIME_DOWN_TICKS = 100;
        @Config.Comment(value={"The unmodulated, base airflow pushed per tick the device is active.", "Default: 0.1"})
        public double BASE_AIRFLOW = 0.1;
        @Config.Comment(value={"The amount of damage applied to a cog each time the machine pushes.", "Default: 8"})
        public int COG_DAMAGE = 8;
        @Config.Comment(value={"A list of valid cogs for the device.", "NOTE: Items provided here are assumed to have durability.", "String format is (domain):(path)"})
        public String[] COGS = new String[]{"pyrotech:cog_wood", "pyrotech:cog_stone", "pyrotech:cog_flint", "pyrotech:cog_bone", "pyrotech:cog_iron", "pyrotech:cog_gold", "pyrotech:cog_obsidian", "pyrotech:cog_diamond"};

        public boolean isValidCog(@Nullable ResourceLocation resourceLocation) {
            if (resourceLocation != null) {
                return ArrayHelper.contains((Object[])this.COGS, (Object)resourceLocation.toString());
            }
            return false;
        }
    }

    public static class TripHammer {
        @Config.Comment(value={"The number of ticks between tool swings.", "Default: 100"})
        @Config.RangeInt(min=40)
        public int INTERVAL_TICKS = 100;
        @Config.Comment(value={"A list of valid cogs for the device.", "NOTE: Items provided here are assumed to have durability.", "String format is (domain):(path)"})
        public String[] COGS = new String[]{"pyrotech:cog_wood", "pyrotech:cog_stone", "pyrotech:cog_flint", "pyrotech:cog_bone", "pyrotech:cog_iron", "pyrotech:cog_gold", "pyrotech:cog_obsidian", "pyrotech:cog_diamond"};

        public boolean isValidCog(@Nullable ResourceLocation resourceLocation) {
            if (resourceLocation != null) {
                return ArrayHelper.contains((Object[])this.COGS, (Object)resourceLocation.toString());
            }
            return false;
        }
    }

    public static class Bellows {
        @Config.Comment(value={"The number of ticks that the device takes to return to the up position.", "Default: 10"})
        @Config.RangeInt(min=1)
        public int TRAVEL_TIME_UP_TICKS = 10;
        @Config.Comment(value={"The number of ticks that the device takes to reach the down position.", "Default: 100"})
        @Config.RangeInt(min=1)
        public int TRAVEL_TIME_DOWN_TICKS = 100;
        @Config.Comment(value={"The unmodulated, base airflow pushed per tick the device is active.", "Default: 0.1"})
        public double BASE_AIRFLOW = 0.1;
    }

    public static class StoneHopper {
        @Config.Comment(value={"A list of valid cogs for the hopper.", "NOTE: Items provided here are assumed to have durability.", "String format is (domain):(path) for the item and (integer) for the", "number of items that the cog will transfer in one attempt."})
        public Map<String, Integer> COGS = new LinkedHashMap<String, Integer>(){
            {
                this.put("pyrotech:cog_wood", 1);
                this.put("pyrotech:cog_stone", 4);
                this.put("pyrotech:cog_flint", 8);
                this.put("pyrotech:cog_bone", 8);
                this.put("pyrotech:cog_iron", 16);
                this.put("pyrotech:cog_gold", 1);
                this.put("pyrotech:cog_obsidian", 32);
                this.put("pyrotech:cog_diamond", 64);
            }
        };
        @Config.Comment(value={"If set to PerItem, damage will be done to the cog for every item", "transferred. If set to PerOperation, damage will be done to the cog", "each time it makes a transfer, regardless of the size of the transfer.", "Default: PerItem"})
        public EnumCogDamageType COG_DAMAGE_TYPE = EnumCogDamageType.PerItem;
        @Config.Comment(value={"How many ticks between transfer attempts.", "Default: 40"})
        public int TRANSFER_INTERVAL_TICKS = 40;

        public int getCogTransferAmount(@Nullable ResourceLocation resourceLocation) {
            Integer result;
            if (resourceLocation != null && (result = this.COGS.get(resourceLocation.toString())) != null) {
                return result;
            }
            return -1;
        }

        public static enum EnumCogDamageType {
            PerItem,
            PerOperation;

        }
    }

    public static class Cogs {
        @Config.Comment(value={"Durability of the wooden cog.", "Default: 64"})
        @Config.RangeInt(min=1, max=32767)
        public int WOOD_DURABILITY = 64;
        @Config.Comment(value={"Durability of the stone cog.", "Default: 256"})
        @Config.RangeInt(min=1, max=32767)
        public int STONE_DURABILITY = 256;
        @Config.Comment(value={"Durability of the flint cog.", "Default: 1024"})
        @Config.RangeInt(min=1, max=32767)
        public int FLINT_DURABILITY = 1024;
        @Config.Comment(value={"Durability of the bone cog.", "Default: 1024"})
        @Config.RangeInt(min=1, max=32767)
        public int BONE_DURABILITY = 1024;
        @Config.Comment(value={"Durability of the iron cog.", "Default: 4096"})
        @Config.RangeInt(min=1, max=32767)
        public int IRON_DURABILITY = 4096;
        @Config.Comment(value={"Durability of the gold cog.", "Default: 33"})
        @Config.RangeInt(min=1, max=32767)
        public int GOLD_DURABILITY = 33;
        @Config.Comment(value={"Durability of the diamond cog.", "Default: 16384"})
        @Config.RangeInt(min=1, max=32767)
        public int DIAMOND_DURABILITY = 16384;
        @Config.Comment(value={"Durability of the obsidian cog.", "Default: 14693"})
        @Config.RangeInt(min=1, max=32767)
        public int OBSIDIAN_DURABILITY = 14693;
        @Config.Comment(value={"Cog items listed here will not be damaged", "String format is (domain):(path)"})
        public String[] INDESTRUCTIBLE_COGS = new String[0];
    }

    public static class SawmillBlades {
        @Config.Comment(value={"Durability of the stone sawmill blade.", "Default: 32"})
        @Config.RangeInt(min=1, max=32767)
        public int STONE_DURABILITY = 32;
        @Config.Comment(value={"Durability of the flint sawmill blade.", "Default: 150"})
        @Config.RangeInt(min=1, max=32767)
        public int FLINT_DURABILITY = 150;
        @Config.Comment(value={"Durability of the bone sawmill blade.", "Default: 150"})
        @Config.RangeInt(min=1, max=32767)
        public int BONE_DURABILITY = 150;
        @Config.Comment(value={"Durability of the iron sawmill blade.", "Default: 500"})
        @Config.RangeInt(min=1, max=32767)
        public int IRON_DURABILITY = 500;
        @Config.Comment(value={"Durability of the gold sawmill blade.", "Default: 500"})
        @Config.RangeInt(min=1, max=32767)
        public int GOLD_DURABILITY = 32;
        @Config.Comment(value={"Durability of the diamond sawmill blade.", "Default: 1500"})
        @Config.RangeInt(min=1, max=32767)
        public int DIAMOND_DURABILITY = 1500;
        @Config.Comment(value={"Durability of the obsidian sawmill blade.", "Default: 1345"})
        @Config.RangeInt(min=1, max=32767)
        public int OBSIDIAN_DURABILITY = 1345;
        @Config.Comment(value={"Sawblade items listed here will not be damaged by the Sawmills", "String format is (domain):(path)"})
        public String[] INDESTRUCTIBLE_SAWBLADES = new String[0];
    }

    public static class SawmillSounds {
        @Config.Comment(value={"Set to false to disable the sawmill's recipe complete sound.", "Default: true"})
        public boolean RECIPE_COMPLETE_SOUND_ENABLED = true;
        @Config.Comment(value={"Control the volume of the sawmill's recipe complete sound.", "Default: 0.75"})
        @Config.RangeInt(min=0)
        public double RECIPE_COMPLETE_SOUND_VOLUME = 0.75;
        @Config.Comment(value={"Set to false to disable the sawmill's idle sound.", "Default: true"})
        public boolean IDLE_SOUND_ENABLED = true;
        @Config.Comment(value={"Control the volume of the sawmill's idle sound.", "Default: 0.5"})
        @Config.RangeInt(min=0)
        public double IDLE_SOUND_VOLUME = 0.5;
    }

    public static class General {
        @Config.Comment(value={"The light level of stone machines when lit.", "Default: 9"})
        @Config.RangeInt(min=0, max=15)
        public int STONE_MACHINE_LIGHT_LEVEL = 9;
    }
}

