/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.util.FacingHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.athenaeum.util.WeightedPicker;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.WitherForgeRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileWitherForge
extends TileBloomery {
    private int soundTickCounter;

    @Override
    public int getMaxFuelCount() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.FUEL_CAPACITY_ITEMS;
    }

    @Override
    public int getMaxBurnTime() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.FUEL_CAPACITY_BURN_TIME;
    }

    @Override
    public boolean hasSpeedCap() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.HAS_SPEED_CAP;
    }

    @Override
    protected float getAirflowDragModifier() {
        return (float)ModuleTechBloomeryConfig.WITHER_FORGE.AIRFLOW_DRAG_MODIFIER;
    }

    @Override
    protected float getAirflowModifier() {
        return (float)ModuleTechBloomeryConfig.WITHER_FORGE.AIRFLOW_MODIFIER;
    }

    @Override
    protected double getAshConversionChance() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.ASH_CONVERSION_CHANCE;
    }

    @Override
    public int getMaxAshCapacity() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.MAX_ASH_CAPACITY;
    }

    @Override
    protected double getSpeedScalar() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.SPEED_SCALAR;
    }

    @Override
    protected double getSpecialFuelBurnTimeModifier(ItemStack stack) {
        return ModuleTechBloomeryConfig.WITHER_FORGE.getSpecialFuelBurnTimeModifier(stack);
    }

    @Override
    protected int getInputCapacity() {
        return Math.min(64, Math.max(0, ModuleTechBloomeryConfig.WITHER_FORGE.CAPACITY));
    }

    @Override
    protected boolean dropSlagWhenBroken() {
        return ModuleTechBloomeryConfig.WITHER_FORGE.DROP_SLAG_WHEN_BROKEN;
    }

    @Override
    protected List<BlockPos> getAirflowCheckPositions() {
        IBlockState tileBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing tileFacing = this.getTileFacing(this.field_145850_b, this.field_174879_c, tileBlockState);
        BlockPos offset = this.field_174879_c.func_177972_a(tileFacing);
        return Lists.newArrayList((Object[])new BlockPos[]{offset, this.field_174879_c.func_177972_a(FacingHelper.rotateFacingCW((EnumFacing)tileFacing)), this.field_174879_c.func_177972_a(FacingHelper.rotateFacingCW((EnumFacing)tileFacing, (int)3))});
    }

    @Override
    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleTechBloomery.Blocks.WITHER_FORGE) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return EnumFacing.NORTH;
    }

    @Override
    protected void createSlag() {
        int count = this.getInputStackHandler().getStackInSlot(0).func_190916_E();
        EnumFacing facing = this.getTileFacing(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        BlockPos[] positions = new BlockPos[]{this.field_174879_c.func_177972_a(facing), this.field_174879_c.func_177972_a(FacingHelper.rotateFacingCW((EnumFacing)facing)), this.field_174879_c.func_177972_a(FacingHelper.rotateFacingCW((EnumFacing)facing, (int)3))};
        for (int i = 0; i < count; ++i) {
            int index = this.field_145850_b.field_73012_v.nextInt(positions.length);
            this.createSlag(positions[index]);
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            Random rand = RandomHelper.random();
            if (this.isActive()) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
                if (rand.nextDouble() < 0.5) {
                    this.spawnDrip(rand, FacingHelper.rotateFacingCW((EnumFacing)facing));
                }
                if (rand.nextDouble() < 0.5) {
                    this.spawnDrip(rand, FacingHelper.rotateFacingCW((EnumFacing)facing, (int)3));
                }
            }
        } else if (ModuleTechBloomeryConfig.WITHER_FORGE.ENABLE_SCARY_SOUNDS) {
            if (this.isActive()) {
                --this.soundTickCounter;
                if (this.soundTickCounter <= 0) {
                    Random random = RandomHelper.random();
                    int variance = (int)((random.nextFloat() * 2.0f - 1.0f) * (float)ModuleTechBloomeryConfig.WITHER_FORGE.SCARY_SOUND_INTERVAL_VARIANCE_TICKS);
                    this.soundTickCounter = variance + ModuleTechBloomeryConfig.WITHER_FORGE.SCARY_SOUND_INTERVAL_TICKS;
                    WeightedPicker picker = new WeightedPicker();
                    picker.add(1, (Object)SoundEvents.field_189105_bM);
                    picker.add(5, (Object)SoundEvents.field_187551_bH);
                    picker.add(5, (Object)SoundEvents.field_187559_bL);
                    picker.add(5, (Object)SoundEvents.field_190038_hc);
                    picker.add(5, (Object)SoundEvents.field_187851_gB);
                    picker.add(10, (Object)SoundEvents.field_190036_ha);
                    picker.add(25, (Object)SoundEvents.field_187925_gy);
                    picker.add(50, (Object)SoundEvents.field_190039_hd);
                    SoundHelper.playSoundServer((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)((SoundEvent)picker.get()), (SoundCategory)SoundCategory.BLOCKS, (float)(random.nextFloat() * 0.2f + 0.4f), (float)(0.4f + random.nextFloat() * 1.0f));
                }
            } else {
                this.soundTickCounter = 0;
            }
        }
    }

    protected WitherForgeRecipe getRecipe(ItemStack stackInSlot) {
        return WitherForgeRecipe.getRecipe(stackInSlot);
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleTechBloomeryConfig.STAGES_WITHER_FORGE;
    }
}

