/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.athenaeum.util.RandomHelper;
import com.codetaylor.mc.athenaeum.util.WeightedPicker;
import com.codetaylor.mc.pyrotech.library.spi.recipe.IRecipeTimed;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomeryConfig;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class BloomeryRecipeBase<T extends BloomeryRecipeBase<T>>
extends IForgeRegistryEntry.Impl<T>
implements IRecipeSingleOutput,
IRecipeTimed {
    protected final Ingredient input;
    protected final ItemStack output;
    protected ItemStack outputBloom;
    protected final int burnTimeTicks;
    protected final float experience;
    protected final float failureChance;
    protected final int bloomYieldMin;
    protected final int bloomYieldMax;
    protected final int slagCount;
    protected final FailureItem[] failureItems;
    protected final ItemStack slagItem;
    protected final AnvilRecipe.EnumTier[] anvilTiers;
    protected final String langKey;

    public BloomeryRecipeBase(Ingredient input, ItemStack output, int burnTimeTicks, float experience, float failureChance, int bloomYieldMin, int bloomYieldMax, int slagCount, FailureItem[] failureItems, ItemStack slagItem, AnvilRecipe.EnumTier[] anvilTiers, @Nullable String langKey) {
        this.input = input;
        this.output = output;
        this.burnTimeTicks = burnTimeTicks;
        this.experience = experience;
        this.failureChance = MathHelper.func_76131_a((float)failureChance, (float)0.0f, (float)1.0f);
        this.bloomYieldMin = bloomYieldMin;
        this.bloomYieldMax = bloomYieldMax;
        this.slagCount = slagCount;
        this.failureItems = failureItems;
        this.slagItem = slagItem;
        this.anvilTiers = anvilTiers;
        this.langKey = langKey != null ? langKey : this.getLangKeyFrom(this.input);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public ItemStack getOutputBloom() {
        ResourceLocation resourceLocation;
        if (this.outputBloom == null && (resourceLocation = this.getRegistryName()) != null) {
            this.outputBloom = BloomHelper.createBloomAsItemStack(this.bloomYieldMax, this.experience, resourceLocation.toString(), this.langKey);
        }
        return this.outputBloom.func_77946_l();
    }

    public int getBloomYieldMin() {
        return this.bloomYieldMin;
    }

    public int getBloomYieldMax() {
        return this.bloomYieldMax;
    }

    public AnvilRecipe.EnumTier[] getAnvilTiers() {
        return this.anvilTiers;
    }

    public ItemStack getUniqueBloomFromOutput(int quantity) {
        int integrity = 0;
        int iterations = Math.max(1, quantity);
        for (int i = 0; i < iterations; ++i) {
            integrity += MathHelper.func_76136_a((Random)RandomHelper.random(), (int)this.bloomYieldMin, (int)this.bloomYieldMax);
        }
        float experiencePerComplete = this.experience * (float)quantity;
        ResourceLocation resourceLocation = this.getRegistryName();
        if (resourceLocation != null) {
            return BloomHelper.createBloomAsItemStack(integrity, experiencePerComplete, resourceLocation.toString().replaceAll("\\.slag", ""), this.langKey);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlagCount() {
        return this.slagCount;
    }

    @Override
    public int getTimeTicks() {
        return this.burnTimeTicks;
    }

    public float getFailureChance() {
        return this.failureChance;
    }

    public FailureItem[] getFailureItems() {
        return this.failureItems;
    }

    public ItemStack getSlagItemStack() {
        return this.slagItem;
    }

    @Nullable
    public String getLangKey() {
        return this.langKey;
    }

    public boolean matches(ItemStack input) {
        return this.input.apply(input);
    }

    public ItemStack getRandomOutput(ItemStack toolItemStack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)toolItemStack);
        double modifier = 1.0;
        if (enchantments.containsKey(Enchantments.field_185306_r)) {
            modifier = MathHelper.func_151237_a((double)ModuleTechBloomeryConfig.BLOOM.SILK_TOUCH_FAILURE_MODIFIER, (double)0.0, (double)1.0);
        }
        if (RandomHelper.random().nextDouble() < (double)this.failureChance * modifier) {
            return this.selectRandomFailureItemStack();
        }
        return this.getOutput();
    }

    private ItemStack selectRandomFailureItemStack() {
        if (this.failureItems.length == 0) {
            return ItemStack.field_190927_a;
        }
        WeightedPicker picker = new WeightedPicker();
        for (FailureItem failureItem : this.failureItems) {
            picker.add(failureItem.getWeight(), (Object)failureItem.getItemStack());
        }
        ItemStack result = ((ItemStack)picker.get()).func_77946_l();
        result.func_190920_e(1);
        return result;
    }

    protected String getLangKeyFrom(Ingredient input) {
        ItemStack[] matchingStacks = input.func_193365_a();
        if (matchingStacks.length == 0) {
            return "error.missing.lang.key";
        }
        return matchingStacks[0].func_77977_a();
    }

    public static class FailureItem {
        private final ItemStack itemStack;
        private final int weight;

        public FailureItem(ItemStack itemStack, int weight) {
            this.itemStack = itemStack;
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

