/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.waila.provider;

import com.codetaylor.mc.pyrotech.library.spi.plugin.waila.BodyProviderAdapter;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.library.util.plugin.waila.WailaUtil;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.waila.delegate.BloomeryProviderDelegate;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class BloomeryProvider
extends BodyProviderAdapter
implements BloomeryProviderDelegate.IBloomeryDisplay {
    private final BloomeryProviderDelegate delegate = new BloomeryProviderDelegate(this);
    private List<String> tooltip;

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileBloomery || tileEntity instanceof TileBloomery.Top) {
            TileBloomery tile = null;
            if (tileEntity instanceof TileBloomery) {
                tile = (TileBloomery)tileEntity;
            } else {
                World world = tileEntity.func_145831_w();
                TileEntity candidate = world.func_175625_s(tileEntity.func_174877_v().func_177977_b());
                if (candidate instanceof TileBloomery) {
                    tile = (TileBloomery)candidate;
                }
            }
            if (tile == null) {
                return tooltip;
            }
            this.tooltip = tooltip;
            this.delegate.display(tile);
            this.tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void setRecipeProgress(ItemStack input, ItemStack output, int progress, int maxProgress) {
        String renderString = WailaUtil.getStackRenderString(input) + WailaUtil.getProgressRenderString(progress, maxProgress) + WailaUtil.getStackRenderString(output);
        this.tooltip.add(renderString);
    }

    @Override
    public void setInput(ItemStack input) {
        this.tooltip.add(WailaUtil.getStackRenderString(input));
    }

    @Override
    public void setOutputItems(ItemStackHandler stackHandler) {
        StringBuilder renderString = new StringBuilder();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = stackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            renderString.append(WailaUtil.getStackRenderString(stackInSlot));
        }
        this.tooltip.add(renderString.toString());
    }

    @Override
    public void setFuelItems(ItemStackHandler stackHandler) {
        StringBuilder renderString = new StringBuilder();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stackInSlot = stackHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            renderString.append(WailaUtil.getStackRenderString(stackInSlot));
        }
        this.tooltip.add(renderString.toString());
    }

    @Override
    public void setSpeed(String langKey, int speed) {
        this.tooltip.add(Util.translateFormatted(langKey, speed));
    }

    @Override
    public void setAirflow(String langKey, int airflow) {
        this.tooltip.add(Util.translateFormatted(langKey, airflow));
    }

    @Override
    public void setFuelCount(String langKey, int fuelCount, int maxFuelCount) {
        this.tooltip.add(Util.translateFormatted(langKey, fuelCount, maxFuelCount));
    }
}

