/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.util.BloomHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;

public class BloomProviderDelegate
extends ProviderDelegateBase<IBloomDisplay, TileBloom> {
    public BloomProviderDelegate(IBloomDisplay display) {
        super(display);
    }

    @Override
    public void display(TileBloom tile) {
        throw new UnsupportedOperationException();
    }

    public void display(TileBloom tile, EntityPlayer player) {
        int integrity = (int)((float)tile.getIntegrity() / (float)tile.getMaxIntegrity() * 100.0f);
        ((IBloomDisplay)this.display).setIntegrity("gui.pyrotech.waila.bloom.integrity", integrity);
        int recipeProgress = (int)(tile.getRecipeProgress() * 100.0f);
        ((IBloomDisplay)this.display).setHammered("gui.pyrotech.waila.bloom.hammered", recipeProgress);
        Vec3d hammerPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() * 0.5, player.field_70161_v);
        ItemStack toolItemStack = player.func_184614_ca();
        int hammerPower = (int)(BloomHelper.calculateHammerPower(tile.func_174877_v(), hammerPos, toolItemStack, player) * 100.0);
        if (hammerPower > 0) {
            ((IBloomDisplay)this.display).setHammerPower("gui.pyrotech.waila.bloom.hammer.power", hammerPower);
        } else {
            ((IBloomDisplay)this.display).setHammerPower(TextFormatting.RED, "gui.pyrotech.waila.bloom.hammer.power", hammerPower);
        }
    }

    public static interface IBloomDisplay {
        public void setIntegrity(String var1, int var2);

        public void setHammered(String var1, int var2);

        public void setHammerPower(String var1, int var2);

        public void setHammerPower(TextFormatting var1, String var2, int var3);
    }
}

