/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.init;

import com.codetaylor.mc.athenaeum.util.CloneStateMapper;
import com.codetaylor.mc.athenaeum.util.ModelRegistrationHelper;
import com.codetaylor.mc.pyrotech.library.JsonInitializer;
import com.codetaylor.mc.pyrotech.modules.core.init.CompatInitializerOre;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.ModuleTechBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockPileSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.JsonSlagList;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.ItemSlag;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class SlagInitializer {
    public static final Map<String, ItemSlag> SLAG_BY_OREDICT = new HashMap<String, ItemSlag>();
    public static final Map<String, BlockPileSlag> SLAG_PILE_BY_OREDICT = new HashMap<String, BlockPileSlag>();

    public static void initializeSlag(File configurationDirectory) {
        Path configurationPath = Paths.get(configurationDirectory.toString(), "pyrotech");
        JsonSlagList jsonSlagList = JsonInitializer.generateAndReadCustom(configurationPath, "module.tech.Bloomery.Slag-Generated.json", "module.tech.Bloomery.Slag-Custom.json", JsonSlagList.class, () -> SlagInitializer.createGeneratedDataSlagList(new JsonSlagList()), ModuleTechBloomery.LOGGER);
        if (jsonSlagList == null) {
            return;
        }
        for (JsonSlagList.JsonSlagListEntry entry : jsonSlagList.getList()) {
            int color;
            String colorString = entry.getColor();
            if (colorString.length() != 6) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Malformed hex-color code %s in %s", "pyrotech", colorString, configurationPath));
                continue;
            }
            try {
                color = Integer.decode("0x" + colorString);
            }
            catch (Exception e) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Unable to decode hex-color string %s in %s", "pyrotech", colorString, configurationPath), (Throwable)e);
                continue;
            }
            String registryName = entry.getRegistryName().replace("[^A-Za-z0-9_]", "_");
            String langKey = entry.getLangKey();
            ItemSlag itemSlag = SlagInitializer.generateSlagItem(registryName + "_custom", langKey, color);
            SlagInitializer.generateSlagBlock(registryName + "_custom", langKey, color, itemSlag);
        }
    }

    public static void initializeSlagFromOreCompat(Path configurationPath) {
        CompatInitializerOre.OreCompatData data = CompatInitializerOre.read(configurationPath);
        if (data == null) {
            ModuleTechBloomery.LOGGER.error(String.format("[%s] Missing ore compat data from %s, SKIPPING ALL", "pyrotech", configurationPath));
            return;
        }
        for (Map.Entry<String, CompatInitializerOre.OreCompatEntry> entry : data.oredict.entrySet()) {
            int color;
            String oreDictKey = entry.getKey();
            CompatInitializerOre.OreCompatEntry oreDictEntry = entry.getValue();
            if (oreDictEntry.langKey == null || oreDictEntry.langKey.length == 0) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Null or zero length oreDict key in %s, SKIPPING", "pyrotech", configurationPath));
                continue;
            }
            ArrayList<String> langKeysToTest = new ArrayList<String>(oreDictEntry.langKey.length);
            for (String itemString : oreDictEntry.langKey) {
                String[] split = itemString.split(":");
                StringBuilder langKey = new StringBuilder();
                if (split.length > 2) {
                    for (int i = 1; i < split.length; ++i) {
                        langKey.append(":").append(split[i]);
                    }
                } else if (split.length == 2) {
                    langKey.append(split[1]);
                } else {
                    langKey.append(split[0]);
                }
                langKeysToTest.add(langKey.toString());
            }
            String langKey = SlagInitializer.getFirstValidLangKey(langKeysToTest);
            if (langKey == null) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Missing valid ore compat lang key for %s in %s, SKIPPING", "pyrotech", oreDictKey, configurationPath));
                continue;
            }
            String colorString = oreDictEntry.slagColor;
            if (colorString.length() != 6) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Malformed ore compat slag hex-color code %s for oreDictKey %s in %s, SKIPPING", "pyrotech", colorString, oreDictKey, configurationPath));
                continue;
            }
            try {
                color = Integer.decode("0x" + colorString);
            }
            catch (Exception e) {
                ModuleTechBloomery.LOGGER.error(String.format("[%s] Unable to decode ore compat slag hex-color code %s for oreDictKey %s in %s, SKIPPING", "pyrotech", colorString, oreDictKey, configurationPath));
                continue;
            }
            String registryName = oreDictKey.replaceAll("ore", "").toLowerCase().replace("[^a-z0-9_]", "_");
            ItemSlag itemSlag = SlagInitializer.generateSlagItem(registryName, langKey, color);
            ModuleTechBloomery.LOGGER.info(String.format("[%s] Generated slag item for %s with langKey %s and color %s", "pyrotech", itemSlag.getRegistryName(), langKey, color));
            SLAG_BY_OREDICT.put(oreDictKey, itemSlag);
            BlockPileSlag blockPileSlag = SlagInitializer.generateSlagBlock(registryName, langKey, color, itemSlag);
            ModuleTechBloomery.LOGGER.info(String.format("[%s] Generated slag pile block for %s with langKey %s and color %s", "pyrotech", blockPileSlag.getRegistryName(), langKey, color));
            SLAG_PILE_BY_OREDICT.put(oreDictKey, blockPileSlag);
        }
    }

    @Nullable
    public static String getFirstValidLangKey(List<String> langKeysToTest) {
        for (String langKey : langKeysToTest) {
            if (I18n.func_94522_b((String)langKey)) {
                return langKey;
            }
            if (!I18n.func_94522_b((String)(langKey + ".name"))) continue;
            return langKey + ".name";
        }
        return null;
    }

    private static JsonSlagList createGeneratedDataSlagList(JsonSlagList jsonSlagList) {
        return jsonSlagList;
    }

    private static ItemSlag generateSlagItem(String registryName, String langKey, int color) {
        ItemSlag slagItem = new ItemSlag();
        ResourceLocation resourceLocation = new ResourceLocation("pyrotech", "generated_slag_" + registryName);
        String unlocalizedName = "pyrotech.slag";
        SlagInitializer.registerItem(slagItem, resourceLocation, unlocalizedName);
        ModuleTechBloomery.Items.GENERATED_SLAG.put(slagItem, new ItemSlag.Properties(langKey, color));
        return slagItem;
    }

    private static BlockPileSlag generateSlagBlock(String registryName, String langKey, int color, ItemSlag slagItem) {
        BlockPileSlag slagBlock = new BlockPileSlag();
        ResourceLocation resourceLocation = new ResourceLocation("pyrotech", "generated_pile_slag_" + registryName);
        String unlocalizedName = "pyrotech.pile_slag";
        BlockPileSlag.ItemBlockPileSlag item = new BlockPileSlag.ItemBlockPileSlag(slagBlock);
        SlagInitializer.registerItem((Item)item, resourceLocation, unlocalizedName);
        SlagInitializer.registerBlock((Block)slagBlock, resourceLocation, unlocalizedName);
        ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG.put(slagBlock, new BlockPileSlag.Properties(langKey, color, slagItem));
        return slagBlock;
    }

    private static void registerItem(Item item, ResourceLocation registryName, String unlocalizedName) {
        item.setRegistryName(registryName);
        item.func_77655_b(unlocalizedName);
        item.func_77637_a(ModuleTechBloomery.CREATIVE_TAB);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    private static void registerBlock(Block block, ResourceLocation registryName, String unlocalizedName) {
        block.setRegistryName(registryName);
        block.func_149663_c(unlocalizedName);
        block.func_149647_a(ModuleTechBloomery.CREATIVE_TAB);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initializeSlagModels() {
        ModuleTechBloomery.Items.GENERATED_SLAG.forEach((itemSlag, properties) -> {
            ResourceLocation resourceLocation = new ResourceLocation("pyrotech", "slag");
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, null);
            ModelRegistrationHelper.registerItemModel((Item)itemSlag, (int)0, (ModelResourceLocation)modelResourceLocation);
        });
        ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG.forEach((blockPileSlag, properties) -> {
            ModelRegistrationHelper.registerItemModel((Item)Item.func_150898_a((Block)blockPileSlag), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("pyrotech", "pile_slag"), ModelRegistrationHelper.PROPERTY_STRING_MAPPER.func_178131_a((Map)blockPileSlag.func_176223_P().func_177228_b())));
            ModelLoader.setCustomStateMapper((Block)blockPileSlag, (IStateMapper)CloneStateMapper.forBlock((Block)ModuleTechBloomery.Blocks.PILE_SLAG));
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void initializeSlagColors() {
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemColors itemColors = minecraft.getItemColors();
        BlockColors blockColors = minecraft.func_184125_al();
        ModuleTechBloomery.Items.GENERATED_SLAG.forEach((itemSlag, properties) -> itemColors.func_186730_a((IItemColor)new ItemColor(properties.color, 1), new Item[]{itemSlag}));
        ModuleTechBloomery.Blocks.GENERATED_PILE_SLAG.forEach((blockPileSlag, properties) -> {
            Item itemBlock = Item.func_150898_a((Block)blockPileSlag);
            itemColors.func_186730_a((IItemColor)new ItemColor(properties.color, 0), new Item[]{itemBlock});
            blockColors.func_186722_a((IBlockColor)new BlockColor(properties.color), new Block[]{blockPileSlag});
        });
        int defaultColor = Integer.decode("0x676767");
        itemColors.func_186730_a((IItemColor)new ItemColor(defaultColor, 1), new Item[]{ModuleTechBloomery.Items.SLAG});
        itemColors.func_186730_a((IItemColor)new ItemColor(defaultColor, 0), new Item[]{Item.func_150898_a((Block)ModuleTechBloomery.Blocks.PILE_SLAG)});
        blockColors.func_186722_a((IBlockColor)new BlockColor(defaultColor), new Block[]{ModuleTechBloomery.Blocks.PILE_SLAG});
    }

    private SlagInitializer() {
    }

    @SideOnly(value=Side.CLIENT)
    private static class BlockColor
    implements IBlockColor {
        private final int color;

        private BlockColor(int color) {
            this.color = color;
        }

        public int func_186720_a(@Nonnull IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
            if (tintIndex == 0) {
                return this.color;
            }
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ItemColor
    implements IItemColor {
        private final int color;
        private final int tintIndex;

        private ItemColor(int color, int tintIndex) {
            this.color = color;
            this.tintIndex = tintIndex;
        }

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            if (tintIndex == this.tintIndex) {
                return this.color;
            }
            return 0xFFFFFF;
        }
    }
}

