/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery.client.render;

import com.codetaylor.mc.athenaeum.interaction.api.InteractionRenderers;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionRenderer;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.tile.TileBloomery;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BloomeryFuelRenderer
implements IInteractionRenderer<TileBloomery.InteractionFuel> {
    public static final BloomeryFuelRenderer INSTANCE = new BloomeryFuelRenderer();
    private static final float PX = 0.0625f;
    private static final float INSET = 0.1875f;

    public void renderSolidPass(TileBloomery.InteractionFuel interaction, World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
        boolean shouldRender;
        TileBloomery.FuelStackHandler fuelStackHandler = interaction.getFuelStackHandler();
        boolean hasFuel = !fuelStackHandler.getFirstNonEmptyItemStack().func_190926_b();
        TileBloomery tile = interaction.getTile();
        boolean isActive = tile.isActive();
        boolean hasAsh = tile.getAshCount() > 0;
        boolean bl = shouldRender = hasFuel || hasAsh || isActive;
        if (shouldRender) {
            float fuelLevel = (float)tile.getFuelCount() / (float)tile.getMaxFuelCount();
            float ashLevel = (float)tile.getAshCount() / (float)tile.getMaxAshCapacity();
            TextureAtlasSprite sprite = hasFuel ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150402_ci.func_176223_P()) : (hasAsh ? Minecraft.func_71410_x().func_147117_R().func_110572_b("pyrotech:blocks/ash_block") : Minecraft.func_71410_x().func_147117_R().func_110572_b("pyrotech:blocks/active_pile"));
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            int i = world.func_175667_e(blockpos.func_177984_a()) ? world.func_175626_b(blockpos.func_177984_a(), 0) : 0;
            int j = i >> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            float level = Math.max(fuelLevel, ashLevel);
            float adjustedLevel = 0.5625f * level + 0.875f;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_181662_b(0.1875, (double)adjustedLevel, 0.1875).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.8125, (double)adjustedLevel, 0.1875).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.8125, (double)adjustedLevel, 0.8125).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.1875, (double)adjustedLevel, 0.8125).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_187314_a(j, k).func_181675_d();
            tessellator.func_78381_a();
            if (isActive) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.1875, (double)adjustedLevel, (double)0.1875);
                float airflow = tile.getAirflow();
                if (airflow > 1.0f) {
                    GlStateManager.func_179094_E();
                    double scaleY = 2.0 * ((0.25 * (double)(airflow + 3.0f) - 1.0) / (0.25 * (double)(airflow + 3.0f)));
                    GlStateManager.func_179139_a((double)0.5, (double)MathHelper.func_151237_a((double)scaleY, (double)0.0, (double)1.0), (double)0.5);
                    GlStateManager.func_179137_b((double)0.1875, (double)0.0, (double)0.1875);
                    GlStateManager.func_179089_o();
                    BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
                    IBlockState fireState = Blocks.field_150480_ab.func_176223_P();
                    IBakedModel model = renderer.func_184389_a(fireState);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    renderer.func_175019_b().func_178267_a((IBlockAccess)world, model, fireState, BlockPos.field_177992_a, buffer, true);
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179139_a((double)0.625, (double)0.625, (double)0.625);
                GlStateManager.func_179089_o();
                BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
                IBlockState fireState = Blocks.field_150480_ab.func_176223_P();
                IBakedModel model = renderer.func_184389_a(fireState);
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                renderer.func_175019_b().func_178267_a((IBlockAccess)world, model, fireState, BlockPos.field_177992_a, buffer, true);
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            RenderHelper.func_74519_b();
        }
    }

    public void renderSolidPassText(TileBloomery.InteractionFuel interaction, World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
    }

    public boolean renderAdditivePass(TileBloomery.InteractionFuel interaction, World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        TileBloomery tile = interaction.getTile();
        if (!tile.isFuelFull() && StackHelper.getItemBurnTime((ItemStack)heldItemMainHand) + tile.getBurnTime() <= tile.getMaxBurnTime() && interaction.shouldRenderAdditivePassForHeldItem(heldItemMainHand) && interaction.isItemStackValid(heldItemMainHand)) {
            Transform transform = interaction.getTransform(world, hitPos, blockState, heldItemMainHand, partialTicks);
            InteractionRenderers.setupAdditiveGLState();
            InteractionRenderers.renderItemModelCustom((RenderItem)renderItem, (ItemStack)heldItemMainHand, (Transform)transform);
            InteractionRenderers.cleanupAdditiveGLState();
            return true;
        }
        return false;
    }
}

