/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.bloomery;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.athenaeum.util.Injector;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockBloom;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockBloomery;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockPileSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.block.BlockWitherForge;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.event.ItemTooltipEventHandler;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.BlockInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.EntityInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.ItemInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.SlagInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe.BloomeryRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe.CompactingBinRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe.VanillaFurnaceRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.init.recipe.WitherForgeRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.ItemSlag;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsEmptyBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.item.spi.ItemTongsFullBase;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.BloomeryRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.bloomery.recipe.WitherForgeRecipe;
import java.io.File;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleTechBloomery
extends ModuleBase {
    public static final String MODULE_ID = "module.tech.bloomery";
    public static final String MOD_ID = "pyrotech";
    public static final CreativeTabs CREATIVE_TAB = ModPyrotech.CREATIVE_TAB;
    public static final Logger LOGGER = LogManager.getLogger((String)("pyrotech." + ModuleTechBloomery.class.getSimpleName()));
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;
    private File modConfigurationDirectory;

    public ModuleTechBloomery() {
        super(0, MOD_ID);
        String[] craftTweakerPlugins;
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (String plugin : craftTweakerPlugins = new String[]{"ZenBloomery"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.crafttweaker." + plugin);
        }
        this.registerIntegrationPlugin("jei", "com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.jei.PluginJEI");
    }

    @SubscribeEvent
    public void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "bloomery_recipe")).setType(BloomeryRecipe.class).allowModification().create();
        new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "wither_forge_recipe")).setType(WitherForgeRecipe.class).allowModification().create();
        Injector injector = new Injector();
        injector.inject(Registries.class, "BLOOMERY_RECIPE", (Object)GameRegistry.findRegistry(BloomeryRecipe.class));
        injector.inject(Registries.class, "WITHER_FORGE_RECIPE", (Object)GameRegistry.findRegistry(WitherForgeRecipe.class));
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        this.modConfigurationDirectory = event.getModConfigurationDirectory();
        super.onPreInitializationEvent(event);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.top.PluginTOP$Callback");
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.codetaylor.mc.pyrotech.modules.tech.bloomery.plugin.waila.PluginWaila.wailaCallback");
        MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipEventHandler());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent event) {
        TextureMap map = event.getMap();
        map.func_174942_a(new ResourceLocation("pyrotech:blocks/active_pile"));
        map.func_174942_a(new ResourceLocation("pyrotech:blocks/ash_block"));
    }

    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        super.onRegisterRecipesEvent(event);
        VanillaFurnaceRecipesAdd.apply();
        BloomeryRecipesAdd.applyCompatRecipes(this.getConfigurationDirectory().toPath(), Registries.BLOOMERY_RECIPE);
        WitherForgeRecipesAdd.apply(Registries.WITHER_FORGE_RECIPE);
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechBasic.class)) {
            CompactingBinRecipesAdd.apply(ModuleTechBasic.Registries.COMPACTING_BIN_RECIPE);
        }
        WitherForgeRecipesAdd.registerInheritedRecipes(Registries.BLOOMERY_RECIPE, Registries.WITHER_FORGE_RECIPE);
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechBasic.class)) {
            WitherForgeRecipesAdd.registerBloomAnvilRecipes(Registries.WITHER_FORGE_RECIPE, ModuleTechBasic.Registries.ANVIL_RECIPE);
            BloomeryRecipesAdd.registerBloomAnvilRecipes(Registries.BLOOMERY_RECIPE, ModuleTechBasic.Registries.ANVIL_RECIPE);
        }
    }

    public void onRegister(Registry registry) {
        BlockInitializer.onRegister(registry);
        ItemInitializer.onRegister(registry);
        registry.registerItemRegistrationStrategy(forgeRegistry -> {
            SlagInitializer.initializeSlag(this.modConfigurationDirectory);
            SlagInitializer.initializeSlagFromOreCompat(this.getConfigurationDirectory().toPath());
        });
        EntityInitializer.onRegister(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        BlockInitializer.onClientRegister(registry);
        ItemInitializer.onClientRegister(registry);
        registry.registerClientModelRegistrationStrategy(SlagInitializer::initializeSlagModels);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientInitializationEvent(FMLInitializationEvent event) {
        super.onClientInitializationEvent(event);
        SlagInitializer.initializeSlagColors();
    }

    public static class Registries {
        public static final IForgeRegistryModifiable<BloomeryRecipe> BLOOMERY_RECIPE = null;
        public static final IForgeRegistryModifiable<WitherForgeRecipe> WITHER_FORGE_RECIPE = null;
    }

    public static class Items {
        public static final Map<ItemSlag, ItemSlag.Properties> GENERATED_SLAG = new IdentityHashMap<ItemSlag, ItemSlag.Properties>();
        @GameRegistry.ObjectHolder(value="pyrotech:slag")
        public static final Item SLAG = null;
        @GameRegistry.ObjectHolder(value="pyrotech:bloom")
        public static final Item BLOOM = null;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_stone")
        public static final ItemTongsEmptyBase TONGS_STONE = null;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_stone_full")
        public static final ItemTongsFullBase TONGS_STONE_FULL = null;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_flint")
        public static final ItemTongsEmptyBase TONGS_FLINT;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_flint_full")
        public static final ItemTongsFullBase TONGS_FLINT_FULL;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_bone")
        public static final ItemTongsEmptyBase TONGS_BONE;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_bone_full")
        public static final ItemTongsFullBase TONGS_BONE_FULL;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_iron")
        public static final ItemTongsEmptyBase TONGS_IRON;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_iron_full")
        public static final ItemTongsFullBase TONGS_IRON_FULL;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_gold")
        public static final ItemTongsEmptyBase TONGS_GOLD;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_gold_full")
        public static final ItemTongsFullBase TONGS_GOLD_FULL;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_diamond")
        public static final ItemTongsEmptyBase TONGS_DIAMOND;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_diamond_full")
        public static final ItemTongsFullBase TONGS_DIAMOND_FULL;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_obsidian")
        public static final ItemTongsEmptyBase TONGS_OBSIDIAN;
        @GameRegistry.ObjectHolder(value="pyrotech:tongs_obsidian_full")
        public static final ItemTongsFullBase TONGS_OBSIDIAN_FULL;

        static {
            TONGS_BONE = null;
            TONGS_BONE_FULL = null;
            TONGS_FLINT = null;
            TONGS_FLINT_FULL = null;
            TONGS_IRON = null;
            TONGS_IRON_FULL = null;
            TONGS_GOLD = null;
            TONGS_GOLD_FULL = null;
            TONGS_DIAMOND = null;
            TONGS_DIAMOND_FULL = null;
            TONGS_OBSIDIAN = null;
            TONGS_OBSIDIAN_FULL = null;
        }
    }

    public static class Blocks {
        public static final Map<BlockPileSlag, BlockPileSlag.Properties> GENERATED_PILE_SLAG = new IdentityHashMap<BlockPileSlag, BlockPileSlag.Properties>();
        @GameRegistry.ObjectHolder(value="pyrotech:pile_slag")
        public static final BlockPileSlag PILE_SLAG = null;
        @GameRegistry.ObjectHolder(value="pyrotech:bloomery")
        public static final BlockBloomery BLOOMERY = null;
        @GameRegistry.ObjectHolder(value="pyrotech:wither_forge")
        public static final BlockWitherForge WITHER_FORGE = null;
        @GameRegistry.ObjectHolder(value="pyrotech:bloom")
        public static final BlockBloom BLOOM = null;
    }
}

