/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.tile;

import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.api.InteractionBounds;
import com.codetaylor.mc.athenaeum.interaction.api.Transform;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionUseItemBase;
import com.codetaylor.mc.athenaeum.inventory.LargeDynamicStackHandler;
import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataContainerBase;
import com.codetaylor.mc.athenaeum.util.BlockHelper;
import com.codetaylor.mc.athenaeum.util.OreDictHelper;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileBurnableBase;
import com.codetaylor.mc.pyrotech.library.util.Util;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.core.tile.IProgressProvider;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockKilnPit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.KilnPitRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.refractory.ModuleTechRefractory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileKilnPit
extends TileBurnableBase
implements ITickable,
IProgressProvider,
ITileInteractable {
    private static final int DEFAULT_TOTAL_BURN_TIME_TICKS = 1000;
    private final InputStackHandler stackHandler = new InputStackHandler();
    private final OutputStackHandler outputStackHandler;
    private final LogStackHandler logStackHandler;
    private int rainTimeRemaining;
    private int totalBurnTimeTicks;
    private boolean active;
    private final TileDataFloat progress;
    private final IInteraction<?>[] interactions;

    public TileKilnPit() {
        super(ModuleTechBasic.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> {
            this.updateBurnTime(handler.getStackInSlot(slot));
            this.func_70296_d();
        });
        this.outputStackHandler = new OutputStackHandler();
        this.logStackHandler = new LogStackHandler();
        this.totalBurnTimeTicks = 1000;
        this.setNeedStructureValidation();
        this.reset();
        this.progress = new TileDataFloat(0.0f, 20);
        ModuleTechBasic.TILE_DATA_SERVICE.register((TileEntityDataContainerBase)this, new ITileData[]{new TileDataItemStackHandler((ItemStackHandler)this.stackHandler), new TileDataItemStackHandler((ItemStackHandler)this.logStackHandler), new TileDataLargeItemStackHandler((ItemStackHandler)this.outputStackHandler), this.progress});
        this.interactions = new IInteraction[]{new InteractionThatch(), new InteractionLog(this, (ItemStackHandler)this.logStackHandler, 0), new InteractionLog(this, (ItemStackHandler)this.logStackHandler, 1), new InteractionLog(this, (ItemStackHandler)this.logStackHandler, 2), new Interaction(this, new ItemStackHandler[]{this.stackHandler, this.outputStackHandler})};
    }

    public ItemStackHandler getLogStackHandler() {
        return this.logStackHandler;
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    public ItemStackHandler getOutputStackHandler() {
        return this.outputStackHandler;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.rainTimeRemaining = this.getRainDeactivateTime();
        this.func_70296_d();
        if (active) {
            this.logStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
            this.logStackHandler.setStackInSlot(1, ItemStack.field_190927_a);
            this.logStackHandler.setStackInSlot(2, ItemStack.field_190927_a);
        }
    }

    private void setTotalBurnTimeTicks(int totalBurnTimeTicks) {
        this.totalBurnTimeTicks = totalBurnTimeTicks;
        this.reset();
        this.func_70296_d();
    }

    @Override
    public float getProgress() {
        return this.progress.get();
    }

    @Override
    protected boolean isActive() {
        return this.active;
    }

    @Override
    protected int getTotalBurnTimeTicks() {
        return this.totalBurnTimeTicks;
    }

    @Override
    protected int getBurnStages() {
        return 1;
    }

    protected int getRainDeactivateTime() {
        return ModuleTechBasicConfig.PIT_KILN.TICKS_BEFORE_EXTINGUISHED;
    }

    private float calculateProgress() {
        if (!this.isActive()) {
            return 0.0f;
        }
        int totalBurnTimeTicks = this.getTotalBurnTimeTicks();
        int totalStages = this.getBurnStages();
        int burnTimePerStage = totalBurnTimeTicks / totalStages;
        float progress = (float)((this.remainingStages - 1) * burnTimePerStage + this.burnTimeTicksPerStage) / (float)totalBurnTimeTicks;
        return 1.0f - progress;
    }

    private void updateBurnTime(ItemStack itemStack) {
        KilnPitRecipe recipe;
        if (!itemStack.func_190926_b() && (recipe = KilnPitRecipe.getRecipe(itemStack)) != null) {
            int burnTimeTicks = Math.max(1, recipe.getTimeTicks());
            double n = ModuleTechBasicConfig.PIT_KILN.VARIABLE_SPEED_MODIFIER;
            double x = itemStack.func_190916_E() == 1 ? 0.0 : (double)(itemStack.func_190916_E() - 1) / ((double)ModuleTechBasicConfig.PIT_KILN.MAX_STACK_SIZE - 1.0);
            double scalar = (1.0 - n) * x + n;
            this.setTotalBurnTimeTicks((int)((double)burnTimeTicks * scalar));
        }
    }

    @Override
    protected void onUpdate() {
        BlockPos up = this.field_174879_c.func_177984_a();
        if (ModuleTechBasicConfig.PIT_KILN.EXTINGUISHED_BY_RAIN && this.field_145850_b.func_175727_C(up)) {
            --this.rainTimeRemaining;
            if (this.rainTimeRemaining <= 0) {
                IBlockState blockState = ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.THATCH));
                this.field_145850_b.func_175656_a(this.field_174879_c, blockState);
                if (this.field_145850_b.func_180495_p(up).func_177230_c() == Blocks.field_150480_ab) {
                    this.field_145850_b.func_175698_g(up);
                }
                this.setActive(false);
            }
        } else {
            this.rainTimeRemaining = this.getRainDeactivateTime();
        }
        this.progress.set(this.calculateProgress());
    }

    @Override
    protected void onUpdateValid() {
        if (!this.isActive()) {
            return;
        }
        BlockPos up = this.field_174879_c.func_177984_a();
        IBlockState blockState = this.field_145850_b.func_180495_p(up);
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150480_ab && (block.isAir(blockState, (IBlockAccess)this.field_145850_b, up) || block.func_176200_f((IBlockAccess)this.field_145850_b, up))) {
            this.field_145850_b.func_175656_a(up, Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    protected void onUpdateInvalid() {
        this.reset();
    }

    @Override
    protected void onInvalidDelayExpired() {
        ItemStack input = this.stackHandler.getStackInSlot(0);
        KilnPitRecipe recipe = KilnPitRecipe.getRecipe(input);
        if (!input.func_190926_b() && recipe != null) {
            ItemStack[] failureItems = recipe.getFailureItems();
            if (failureItems.length > 0) {
                for (int i = 0; i < input.func_190916_E(); ++i) {
                    ItemStack failureItemStack = failureItems[Util.RANDOM.nextInt(failureItems.length)].func_77946_l();
                    failureItemStack.func_190920_e(1);
                    this.insertOutputItem(failureItemStack);
                }
            } else {
                this.insertOutputItem(ItemMaterial.EnumType.PIT_ASH.asStack(input.func_190916_E()));
            }
            ItemStack output = recipe.getOutput();
            output.func_190920_e(input.func_190916_E());
            this.stackHandler.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
        }
        this.setActive(false);
        IBlockState blockState = ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.COMPLETE));
        this.field_145850_b.func_175656_a(this.field_174879_c, blockState);
        this.field_145850_b.func_175698_g(this.field_174879_c.func_177984_a());
    }

    @Override
    protected void onBurnStageComplete() {
    }

    @Override
    protected boolean isStructureValid() {
        IBlockState selfBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (selfBlockState.func_177229_b(BlockKilnPit.VARIANT) != BlockKilnPit.EnumType.WOOD && selfBlockState.func_177229_b(BlockKilnPit.VARIANT) != BlockKilnPit.EnumType.ACTIVE) {
            return false;
        }
        BlockPos up = this.field_174879_c.func_177984_a();
        IBlockState upBlockState = this.field_145850_b.func_180495_p(up);
        Block upBlock = upBlockState.func_177230_c();
        if (!upBlock.isAir(upBlockState, (IBlockAccess)this.field_145850_b, up) && !upBlock.func_176200_f((IBlockAccess)this.field_145850_b, up) && upBlock != Blocks.field_150480_ab) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            if (this.isValidStructureBlock(this.field_145850_b, offset, this.field_145850_b.func_180495_p(offset), facing.func_176734_d())) continue;
            return false;
        }
        return this.isValidStructureBlock(this.field_145850_b, this.field_174879_c.func_177977_b(), this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()), EnumFacing.UP);
    }

    @Override
    protected boolean isValidStructureBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        if (this.isRefractoryBlock(blockState)) {
            return true;
        }
        return super.isValidStructureBlock(world, pos, blockState, facing);
    }

    @Override
    protected void onAllBurnStagesComplete() {
        ItemStack input = this.stackHandler.getStackInSlot(0);
        KilnPitRecipe recipe = KilnPitRecipe.getRecipe(input);
        if (recipe != null) {
            ItemStack output = recipe.getOutput();
            this.stackHandler.setStackInSlot(0, ItemStack.field_190927_a);
            ItemStack[] failureItems = recipe.getFailureItems();
            float failureChance = recipe.getFailureChance();
            failureChance *= 1.0f - (float)this.countAdjacentRefractoryBlocks() / 5.0f;
            for (int i = 0; i < input.func_190916_E(); ++i) {
                if (Util.RANDOM.nextFloat() < failureChance) {
                    if (failureItems.length > 0) {
                        ItemStack failureItemStack = failureItems[Util.RANDOM.nextInt(failureItems.length)].func_77946_l();
                        failureItemStack.func_190920_e(1);
                        this.insertOutputItem(failureItemStack);
                        continue;
                    }
                    this.insertOutputItem(ItemMaterial.EnumType.PIT_ASH.asStack(input.func_190916_E()));
                    continue;
                }
                this.insertOutputItem(output.func_77946_l());
            }
        }
        int ashCount = Util.RANDOM.nextInt(3) + 1;
        this.insertOutputItem(ItemMaterial.EnumType.PIT_ASH.asStack(ashCount));
        this.setActive(false);
        IBlockState blockState = ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.COMPLETE));
        this.field_145850_b.func_175656_a(this.field_174879_c, blockState);
        this.field_145850_b.func_175698_g(this.field_174879_c.func_177984_a());
    }

    private int countAdjacentRefractoryBlocks() {
        int result = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            if (!this.isRefractoryBlock(this.field_145850_b.func_180495_p(offset))) continue;
            ++result;
        }
        if (this.isRefractoryBlock(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
            ++result;
        }
        return result;
    }

    private boolean isRefractoryBlock(IBlockState blockState) {
        if (ModPyrotech.INSTANCE.isModuleEnabled(ModuleTechRefractory.class)) {
            for (Predicate<IBlockState> matcher : ModuleTechRefractory.Registries.REFRACTORY_BLOCK_LIST) {
                if (!matcher.test(blockState)) continue;
                return true;
            }
        }
        return false;
    }

    private void insertOutputItem(ItemStack output) {
        this.outputStackHandler.insertItem(output, false);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        compound.func_74782_a("outputStackHandler", (NBTBase)this.outputStackHandler.serializeNBT());
        compound.func_74782_a("logStackHandler", (NBTBase)this.logStackHandler.serializeNBT());
        compound.func_74768_a("totalBurnTimeTicks", this.totalBurnTimeTicks);
        compound.func_74757_a("active", this.active);
        return compound;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
        this.outputStackHandler.deserializeNBT(compound.func_74775_l("outputStackHandler"));
        this.logStackHandler.deserializeNBT(compound.func_74775_l("logStackHandler"));
        this.totalBurnTimeTicks = compound.func_74762_e("totalBurnTimeTicks");
        this.active = compound.func_74767_n("active");
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        BlockHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Nullable
    public Stages getStages() {
        return ModuleTechBasicConfig.STAGES_PIT_KILN;
    }

    public IInteraction<?>[] getInteractions() {
        return this.interactions;
    }

    private static class LogStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        LogStackHandler() {
            super(3);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    }

    private static class OutputStackHandler
    extends LargeDynamicStackHandler
    implements ITileDataItemStackHandler {
        OutputStackHandler() {
            super(9);
        }
    }

    private static class InputStackHandler
    extends ObservableStackHandler
    implements ITileDataItemStackHandler {
        InputStackHandler() {
            super(1);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return ModuleTechBasicConfig.PIT_KILN.MAX_STACK_SIZE;
        }
    }

    private static class Interaction
    extends InteractionItemStack<TileKilnPit> {
        private final TileKilnPit tile;

        public Interaction(TileKilnPit tile, ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, EnumFacing.field_82609_l, InteractionBounds.BLOCK, new Transform(Transform.translate((double)0.5, (double)0.4, (double)0.5), Transform.rotate(), Transform.scale((double)0.5, (double)0.5, (double)0.5)));
            this.tile = tile;
        }

        public boolean isEnabled() {
            IBlockState blockState = this.tile.field_145850_b.func_180495_p(this.tile.field_174879_c);
            return blockState.func_177229_b(BlockKilnPit.VARIANT) == BlockKilnPit.EnumType.EMPTY;
        }

        public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
            if (!this.stackHandlers[0].getStackInSlot(0).func_190926_b()) {
                super.renderSolidPassText(world, fontRenderer, yaw, offset, pos, blockState, partialTicks);
            }
        }

        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            return blockState.func_177230_c().func_185496_a(blockState, (IBlockAccess)world, pos);
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return KilnPitRecipe.getRecipe(itemStack) != null;
        }

        protected boolean doExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos tilePos) {
            if (!world.field_72995_K) {
                ItemStackHandler outputStackHandler = this.stackHandlers[1];
                int slots = outputStackHandler.getSlots();
                for (int i = 1; i < slots; ++i) {
                    ItemStack extractItem = outputStackHandler.extractItem(i, outputStackHandler.getStackInSlot(i).func_190916_E(), false);
                    if (extractItem.func_190926_b()) continue;
                    StackHelper.addToInventoryOrSpawn((World)world, (EntityPlayer)player, (ItemStack)extractItem, (BlockPos)tilePos, (double)1.0, (boolean)false, (type == IInteraction.EnumType.MouseClick ? 1 : 0) != 0);
                }
            }
            return super.doExtract(type, world, player, tilePos);
        }
    }

    private static class InteractionLog
    extends InteractionItemStack<TileKilnPit> {
        private static final double ONE_THIRD = 0.3333333333333333;
        private static final double ONE_SIXTH = 0.16666666666666666;
        private final TileKilnPit tile;

        public InteractionLog(TileKilnPit tile, ItemStackHandler stackHandler, int slot) {
            super(new ItemStackHandler[]{stackHandler}, slot, EnumFacing.field_82609_l, new AxisAlignedBB((double)slot * 0.3333333333333333, 0.6666666666666666, 0.0, (double)slot * 0.3333333333333333 + 0.3333333333333333, 1.0, 1.0), new Transform(Transform.translate((double)((double)slot * 0.3333333333333333 + 0.16666666666666666), (double)0.8333333333333333, (double)0.5), Transform.rotate((double)1.0, (double)0.0, (double)0.0, (double)90.0), Transform.scale((double)0.3333333333333333, (double)1.0, (double)0.3333333333333333)));
            this.tile = tile;
        }

        protected boolean doItemStackValidation(ItemStack itemStack) {
            return OreDictHelper.contains((String)"logWood", (ItemStack)itemStack);
        }

        public boolean isEnabled() {
            World world = this.tile.func_145831_w();
            IBlockState blockState = world.func_180495_p(this.tile.func_174877_v());
            BlockKilnPit.EnumType type = (BlockKilnPit.EnumType)((Object)blockState.func_177229_b(BlockKilnPit.VARIANT));
            return type == BlockKilnPit.EnumType.THATCH || type == BlockKilnPit.EnumType.WOOD;
        }

        protected void onInsert(IInteraction.EnumType type, ItemStack itemStack, World world, EntityPlayer player, BlockPos pos) {
            ItemStackHandler stackHandler;
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (!((stackHandler = this.stackHandlers[0]).getStackInSlot(0).func_190926_b() || stackHandler.getStackInSlot(1).func_190926_b() || stackHandler.getStackInSlot(2).func_190926_b() || world.field_72995_K)) {
                world.func_175656_a(pos, ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.WOOD)));
            }
        }

        protected void onExtract(IInteraction.EnumType type, World world, EntityPlayer player, BlockPos pos) {
            if (!world.field_72995_K && world.func_180495_p(pos).func_177229_b(BlockKilnPit.VARIANT) == BlockKilnPit.EnumType.WOOD) {
                world.func_175656_a(pos, ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.THATCH)));
            }
        }
    }

    private static class InteractionThatch
    extends InteractionUseItemBase<TileKilnPit> {
        InteractionThatch() {
            super(EnumFacing.field_82609_l, InteractionBounds.BLOCK);
        }

        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            return blockState.func_177230_c().func_185496_a(blockState, (IBlockAccess)world, pos);
        }

        protected boolean allowInteraction(TileKilnPit tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            return player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)ModuleCore.Blocks.THATCH);
        }

        protected boolean doInteraction(TileKilnPit tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (world.func_180495_p(hitPos).func_177229_b(BlockKilnPit.VARIANT) != BlockKilnPit.EnumType.EMPTY) {
                return false;
            }
            if (!world.field_72995_K) {
                ItemStack heldItem = player.func_184614_ca();
                heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                world.func_175656_a(hitPos, ModuleTechBasic.Blocks.KILN_PIT.func_176223_P().func_177226_a(BlockKilnPit.VARIANT, (Comparable)((Object)BlockKilnPit.EnumType.THATCH)));
                world.func_184133_a(null, hitPos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }

        protected int getItemDamage(ItemStack itemStack) {
            return 0;
        }
    }
}

