/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.potion;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.CapabilityFocused;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.IFocusedPlayerData;
import com.codetaylor.mc.pyrotech.modules.tech.basic.potion.PotionCampfireBase;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionResting
extends PotionCampfireBase {
    public static final String NAME = "resting";
    private static final ResourceLocation TEXTURE = new ResourceLocation("pyrotech", "textures/potions/resting.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("pyrotech", "textures/potions/resting2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("pyrotech", "textures/potions/resting3.png");

    public PotionResting() {
        super(Color.BLACK.getRGB());
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public static void addEffect(EntityPlayer player) {
        PotionResting.addEffect(player, 0);
    }

    private static void addEffect(EntityPlayer player, int tier) {
        player.func_70690_d(new PotionEffect((Potion)ModuleTechBasic.Potions.RESTING, Short.MAX_VALUE, tier, true, true));
    }

    @Override
    public void func_76394_a(@Nonnull EntityLivingBase entity, int amplifier) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            int regenRate = Math.max(1, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.RESTING_REGEN_INTERVAL_TICKS);
            int levelUpRate = Math.max(1, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.RESTING_LEVEL_UP_INTERVAL_TICKS);
            PotionEffect potionEffect = entity.func_70660_b((Potion)ModuleTechBasic.Potions.RESTING);
            if (potionEffect != null) {
                int duration = potionEffect.func_76459_b();
                this.doHeal(entity, regenRate, duration);
                if ((Short.MAX_VALUE - duration + 1) % levelUpRate == 0) {
                    if (potionEffect.func_76458_c() < 2) {
                        PotionResting.addEffect((EntityPlayer)entity, potionEffect.func_76458_c() + 1);
                        if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                            String message = "Upgraded resting effect to level " + (potionEffect.func_76458_c() + 1) + " after " + (Short.MAX_VALUE - duration + 1) + " ticks";
                            ModuleCore.LOGGER.debug(message);
                            entity.func_145747_a((ITextComponent)new TextComponentString(message));
                        }
                    } else if (potionEffect.func_76458_c() == 2 && ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_RESTED_EFFECT_ENABLED) {
                        String message;
                        int wellRestedDuration = Math.max(0, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.WELL_RESTED_DURATION_TICKS);
                        if (wellRestedDuration > 0) {
                            entity.func_70690_d(new PotionEffect((Potion)ModuleTechBasic.Potions.WELL_RESTED, wellRestedDuration, 0, false, true));
                            if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                                message = "Upgraded Resting effect to Well Rested after " + (Short.MAX_VALUE - duration + 1) + " ticks";
                                ModuleCore.LOGGER.debug(message);
                                entity.func_145747_a((ITextComponent)new TextComponentString(message));
                            }
                        }
                        PotionResting.addEffect((EntityPlayer)entity, potionEffect.func_76458_c());
                        if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                            message = "Refreshed Resting effect after " + (Short.MAX_VALUE - duration + 1) + " ticks";
                            ModuleCore.LOGGER.debug(message);
                            entity.func_145747_a((ITextComponent)new TextComponentString(message));
                        }
                        if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_EFFECT_ENABLED && entity.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.COMFORT) && entity.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.WELL_RESTED) && entity.func_193076_bZ().containsKey((Object)ModuleTechBasic.Potions.WELL_FED)) {
                            entity.func_70690_d(new PotionEffect((Potion)ModuleTechBasic.Potions.FOCUSED, Short.MAX_VALUE, 0, false, true));
                            IFocusedPlayerData focusedCapability = CapabilityFocused.get((EntityPlayer)entity);
                            double toAdd = Math.max(0.0, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_ACCUMULATED_BONUS);
                            focusedCapability.setRemainingBonus(focusedCapability.getRemainingBonus() + toAdd);
                            if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                                String message2 = "Added XP bonus: " + toAdd;
                                ModuleCore.LOGGER.debug(message2);
                                entity.func_145747_a((ITextComponent)new TextComponentString(message2));
                            }
                        }
                    }
                }
            }
        }
    }

    private void doHeal(@Nonnull EntityLivingBase entity, int regenRate, int duration) {
        int amount;
        if ((regenRate == 1 || (Short.MAX_VALUE - duration + 1) % regenRate == 0) && entity.func_110143_aJ() < entity.func_110138_aP() && (amount = Math.max(0, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.RESTING_REGEN_HALF_HEARTS)) > 0) {
            entity.func_70691_i((float)amount);
            if (ModuleTechBasicConfig.CAMPFIRE_EFFECTS.DEBUG) {
                String message = "Resting effect healed";
                ModuleCore.LOGGER.debug(message);
                entity.func_145747_a((ITextComponent)new TextComponentString(message));
            }
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(@Nonnull PotionEffect effect, Gui gui, int x, int y, float z) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r != null) {
            if (effect.func_76458_c() == 0) {
                minecraft.func_110434_K().func_110577_a(TEXTURE);
            } else if (effect.func_76458_c() == 1) {
                minecraft.func_110434_K().func_110577_a(TEXTURE_2);
            } else if (effect.func_76458_c() == 2) {
                minecraft.func_110434_K().func_110577_a(TEXTURE_3);
            }
            Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
            int left = x + 6;
            int top = y + 8 + 17;
            int right = left + 108;
            int bottom = top + 2;
            Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Color.BLACK.getRGB());
            left = x + 6;
            top = y + 8 + 17;
            int levelUpRate = Math.max(1, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.RESTING_LEVEL_UP_INTERVAL_TICKS);
            float percentage = (float)((Short.MAX_VALUE - effect.func_76459_b()) % levelUpRate) / (float)levelUpRate;
            int right2 = (int)Math.max((float)(left + 1), (float)left + 108.0f * percentage);
            int bottom2 = top + 1;
            Gui.func_73734_a((int)left, (int)top, (int)right2, (int)bottom2, (int)Color.GREEN.getRGB());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(@Nonnull PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (effect.func_76458_c() == 0) {
            minecraft.func_110434_K().func_110577_a(TEXTURE);
        } else if (effect.func_76458_c() == 1) {
            minecraft.func_110434_K().func_110577_a(TEXTURE_2);
        } else if (effect.func_76458_c() == 2) {
            minecraft.func_110434_K().func_110577_a(TEXTURE_3);
        }
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        int left = x + 3;
        int top = y + 20;
        int right = left + 18;
        int bottom = top + 2;
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Color.BLACK.getRGB());
        left = x + 3;
        top = y + 20;
        int levelUpRate = Math.max(1, ModuleTechBasicConfig.CAMPFIRE_EFFECTS.RESTING_LEVEL_UP_INTERVAL_TICKS);
        float percentage = (float)((Short.MAX_VALUE - effect.func_76459_b()) % levelUpRate) / (float)levelUpRate;
        int right2 = (int)Math.max((float)(left + 1), (float)left + 18.0f * percentage);
        int bottom2 = top + 1;
        Gui.func_73734_a((int)left, (int)top, (int)right2, (int)bottom2, (int)Color.GREEN.getRGB());
    }

    @Nonnull
    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }
}

