/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.potion;

import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.capability.CapabilityFocused;
import com.codetaylor.mc.pyrotech.modules.tech.basic.potion.PotionCampfireBase;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionFocused
extends PotionCampfireBase {
    public static final String NAME = "focused";
    private static final ResourceLocation TEXTURE = new ResourceLocation("pyrotech", "textures/potions/focused.png");

    public PotionFocused() {
        super(Color.BLACK.getRGB());
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void func_76394_a(@Nonnull EntityLivingBase entity, int amplifier) {
        entity.func_70690_d(new PotionEffect((Potion)ModuleTechBasic.Potions.FOCUSED, Short.MAX_VALUE, 0, false, true));
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(@Nonnull PotionEffect effect, Gui gui, int x, int y, float z) {
        super.renderInventoryEffect(effect, gui, x, y, z);
        int left = x + 6;
        int top = y + 8 + 17;
        int right = left + 108;
        int bottom = top + 2;
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Color.BLACK.getRGB());
        left = x + 6;
        top = y + 8 + 17;
        double percentage = CapabilityFocused.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getRemainingBonus() / ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_MAXIMUM_ACCUMULATED_BONUS;
        int right2 = (int)Math.max((double)(left + 1), (double)left + 108.0 * percentage);
        int bottom2 = top + 1;
        Gui.func_73734_a((int)left, (int)top, (int)right2, (int)bottom2, (int)Color.GREEN.getRGB());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(@Nonnull PotionEffect effect, Gui gui, int x, int y, float z, float alpha) {
        super.renderHUDEffect(effect, gui, x, y, z, alpha);
        int left = x + 3;
        int top = y + 20;
        int right = left + 18;
        int bottom = top + 2;
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Color.BLACK.getRGB());
        left = x + 3;
        top = y + 20;
        double percentage = CapabilityFocused.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getRemainingBonus() / ModuleTechBasicConfig.CAMPFIRE_EFFECTS.FOCUSED_MAXIMUM_ACCUMULATED_BONUS;
        int right2 = (int)Math.max((double)(left + 1), (double)left + 18.0 * percentage);
        int bottom2 = top + 1;
        Gui.func_73734_a((int)left, (int)top, (int)right2, (int)bottom2, (int)Color.GREEN.getRGB());
    }
}

