/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.core.block.BlockRock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileCompostBin;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemStackHandler;

public class CompostBinProviderDelegate
extends ProviderDelegateBase<ICompostBinDisplay, TileCompostBin> {
    private float[] progress = new float[4];
    private EntityPlayer player;

    public CompostBinProviderDelegate(ICompostBinDisplay display) {
        super(display);
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public void display(TileCompostBin tile) {
        ItemStack currentRecipeOutput = tile.getCurrentRecipeOutput();
        if (currentRecipeOutput.func_190926_b()) {
            return;
        }
        Arrays.fill(this.progress, 0.0f);
        this.progress = tile.getMostCompleteActiveLayerProgress(this.progress);
        TileCompostBin.InputStackHandler inputStackHandler = tile.getInputStackHandler();
        TileCompostBin.OutputStackHandler outputStackHandler = tile.getOutputStackHandler();
        if (this.player.func_70093_af()) {
            for (int i = this.progress.length - 1; i >= 0; --i) {
                if (!(this.progress[i] > 0.0f)) continue;
                ((ICompostBinDisplay)this.display).setRecipeProgress(currentRecipeOutput, (int)(100.0f * this.progress[i]), 100);
            }
        } else if (this.progress[0] > 0.0f) {
            ((ICompostBinDisplay)this.display).setRecipeProgress(currentRecipeOutput, (int)(100.0f * this.progress[0]), 100);
        }
        String langKey = "gui.pyrotech.waila.moisture.level";
        if ((double)tile.getMoistureLevel() > 0.1) {
            ((ICompostBinDisplay)this.display).setMoistureLevel(null, langKey, (int)(tile.getMoistureLevel() * 100.0f));
        } else {
            ((ICompostBinDisplay)this.display).setMoistureLevel(TextFormatting.RED, langKey, (int)(tile.getMoistureLevel() * 100.0f));
        }
        if (inputStackHandler.getTotalItemCount() > 0 || outputStackHandler.getTotalItemCount() > 0) {
            ItemStack stackedOutput = tile.getCurrentRecipeOutput().func_77946_l();
            stackedOutput.func_190920_e(outputStackHandler.getTotalItemCount());
            ((ICompostBinDisplay)this.display).setContents((ItemStackHandler)inputStackHandler, BlockRock.EnumType.DIRT.asStack(tile.getStoredCompostValue()), stackedOutput);
        }
    }

    public static interface ICompostBinDisplay {
        public void setContents(ItemStackHandler var1, ItemStack var2, ItemStack var3);

        public void setRecipeProgress(ItemStack var1, int var2, int var3);

        public void setMoistureLevel(@Nullable TextFormatting var1, String var2, int var3);
    }
}

