/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.delegate;

import com.codetaylor.mc.pyrotech.library.waila.ProviderDelegateBase;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.BarrelRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.tile.TileBarrel;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelProviderDelegate
extends ProviderDelegateBase<IBarrelDisplay, TileBarrel> {
    public BarrelProviderDelegate(IBarrelDisplay display) {
        super(display);
    }

    @Override
    public void display(TileBarrel tile) {
        BarrelRecipe currentRecipe = tile.getCurrentRecipe();
        TileBarrel.InputStackHandler inputStackHandler = tile.getInputStackHandler();
        TileBarrel.InputFluidTank inputFluidTank = tile.getInputFluidTank();
        FluidStack inputFluid = inputFluidTank.getFluid();
        if (currentRecipe != null) {
            float progress = tile.getRecipeProgress();
            FluidStack outputFluid = currentRecipe.getOutput();
            ((IBarrelDisplay)this.display).setRecipeProgress((ItemStackHandler)inputStackHandler, inputFluid, outputFluid, (int)(100.0f * progress), 100);
        } else {
            ((IBarrelDisplay)this.display).setRecipeProgress((ItemStackHandler)inputStackHandler, inputFluid, null, 0, 100);
        }
        if (inputFluid != null) {
            ((IBarrelDisplay)this.display).setFluid(inputFluid, inputFluidTank.getCapacity());
        }
    }

    public static interface IBarrelDisplay {
        public void setRecipeProgress(ItemStackHandler var1, FluidStack var2, FluidStack var3, int var4, int var5);

        public void setFluid(FluidStack var1, int var2);
    }
}

