/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.wrapper;

import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import com.codetaylor.mc.athenaeum.util.RenderHelper;
import com.codetaylor.mc.pyrotech.library.spi.plugin.jei.IPyrotechRecipeWrapper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.ChoppingBlockRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JEIRecipeWrapperChoppingBlock
implements IPyrotechRecipeWrapper {
    private final ResourceLocation registryName;
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final int[] chops;
    private final int[] quantities;

    public JEIRecipeWrapperChoppingBlock(ChoppingBlockRecipe recipe) {
        this.registryName = recipe.getRegistryName();
        this.inputs = Collections.singletonList(Arrays.asList(recipe.getInput().func_193365_a()));
        this.output = recipe.getOutput();
        this.chops = recipe.getChops();
        this.quantities = recipe.getQuantities();
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int levels = Math.max(this.chops.length, this.quantities.length);
        int index = (int)(minecraft.field_71441_e.func_82737_E() / 39L % (long)levels);
        int chops = ArrayHelper.getOrLast((int[])this.chops, (int)index);
        int quantity = ArrayHelper.getOrLast((int[])this.quantities, (int)index);
        String locationString = (String)ArrayHelper.getOrLast((Object[])ModuleTechBasicConfig.CHOPPING_BLOCK.JEI_HARVEST_LEVEL_ITEM, (int)index);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(locationString));
        if (item != null) {
            RenderItem renderItem = minecraft.func_175599_af();
            ItemStack stack = new ItemStack(item);
            IBakedModel model = renderItem.func_184393_a(stack, null, null);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            int stage = (int)(minecraft.field_71441_e.func_82737_E() % 39L / 20L);
            GlStateManager.func_179109_b((float)8.0f, (float)(5 + stage * 4), (float)100.0f);
            GlStateManager.func_179114_b((float)(-90 + stage * -90), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
            RenderHelper.renderItemModel((ItemStack)stack, (IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false, (boolean)false);
            GlStateManager.func_179121_F();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)250.0f);
        minecraft.field_71466_p.func_175065_a("x" + chops, 18.0f, 2.0f, -1, true);
        String quantityLabel = String.valueOf(quantity);
        minecraft.field_71466_p.func_175065_a(quantityLabel, (float)(80 - minecraft.field_71466_p.func_78256_a(quantityLabel)), 30.0f, -1, true);
        GlStateManager.func_179121_F();
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

