/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.core.plugin.crafttweaker.ZenStages;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.TanningRackRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.TanningRack")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/tanning_rack.example.md"})
@ZenClass(value="mods.pyrotech.TanningRack")
public class ZenTanningRack {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="output", info="recipe output"), @ZenDocArg(arg="input", info="recipe input"), @ZenDocArg(arg="failureItem", info="rain failure item"), @ZenDocArg(arg="timeTicks", info="recipe duration in ticks")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient input, IItemStack failureItem, int timeTicks) {
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, CraftTweakerMC.getItemStack((IItemStack)output), CraftTweakerMC.getIngredient((IIngredient)input), CraftTweakerMC.getItemStack((IItemStack)failureItem), timeTicks));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(IIngredient output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(CraftTweakerMC.getIngredient((IIngredient)output)));
    }

    @ZenDocMethod(order=3)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<TanningRackRecipe>(ModuleTechBasic.Registries.TANNING_RACK_RECIPE, "tanning rack"));
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="stages", info="game stages")}, description={"Sets game stage logic required to use the device."})
    @ZenMethod
    public static void setGameStages(ZenStages stages) {
        ModuleTechBasicConfig.STAGES_TANNING_RACK = stages.getStages();
    }

    public static class AddRecipe
    implements IAction {
        private final ItemStack output;
        private final String name;
        private final Ingredient input;
        private final ItemStack failureItem;
        private final int timeTicks;

        public AddRecipe(String name, ItemStack output, Ingredient input, ItemStack failureItem, int timeTicks) {
            this.name = name;
            this.input = input;
            this.output = output;
            this.timeTicks = timeTicks;
            this.failureItem = failureItem;
        }

        public void apply() {
            TanningRackRecipe recipe = new TanningRackRecipe(this.output, this.input, this.failureItem, this.timeTicks);
            ModuleTechBasic.Registries.TANNING_RACK_RECIPE.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        public String describe() {
            return "Adding tanning rack recipe for " + this.output;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final Ingredient output;

        public RemoveRecipe(Ingredient output) {
            this.output = output;
        }

        public void apply() {
            TanningRackRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing tanning rack recipes for " + this.output;
        }
    }
}

