/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.crafttweaker;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTInputHelper;
import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTLogHelper;
import com.codetaylor.mc.athenaeum.tools.ZenDocAppend;
import com.codetaylor.mc.athenaeum.tools.ZenDocArg;
import com.codetaylor.mc.athenaeum.tools.ZenDocClass;
import com.codetaylor.mc.athenaeum.tools.ZenDocMethod;
import com.codetaylor.mc.athenaeum.tools.ZenDocPrepend;
import com.codetaylor.mc.pyrotech.library.crafttweaker.RemoveAllRecipesAction;
import com.codetaylor.mc.pyrotech.modules.core.plugin.crafttweaker.ZenStages;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.BarrelRecipe;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.pyrotech.Barrel")
@ZenDocPrepend(value={"docs/include/header.md"})
@ZenDocAppend(value={"docs/include/barrel.example.md"})
@ZenClass(value="mods.pyrotech.Barrel")
public class ZenBarrel {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="unique recipe name"), @ZenDocArg(arg="outputFluid", info="output fluid"), @ZenDocArg(arg="inputFluid", info="input fluid"), @ZenDocArg(arg="inputItems", info="input items"), @ZenDocArg(arg="timeTicks", info="recipe duration in ticks")})
    @ZenMethod
    public static void addRecipe(String name, ILiquidStack outputFluid, ILiquidStack inputFluid, IIngredient[] inputItems, int timeTicks) {
        if (inputItems.length > 4) {
            CTLogHelper.logErrorFromZenMethod((String)("Recipe named '" + name + "' can't have more than 4 input ingredient items"));
            return;
        }
        FluidStack outputFluidStack = CraftTweakerMC.getLiquidStack((ILiquidStack)outputFluid);
        outputFluidStack.amount = 1000;
        FluidStack inputFluidStack = CraftTweakerMC.getLiquidStack((ILiquidStack)inputFluid);
        inputFluidStack.amount = 1000;
        CraftTweaker.LATE_ACTIONS.add(new AddRecipe(name, outputFluidStack, inputFluidStack, CTInputHelper.toIngredientArray((IIngredient[])inputItems), timeTicks));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="output ingredient to match")})
    @ZenMethod
    public static void removeRecipes(ILiquidStack output) {
        FluidStack fluidStack = CraftTweakerMC.getLiquidStack((ILiquidStack)output);
        fluidStack.amount = 1000;
        CraftTweaker.LATE_ACTIONS.add(new RemoveRecipe(fluidStack));
    }

    @ZenDocMethod(order=4)
    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAllRecipesAction<BarrelRecipe>(ModuleTechBasic.Registries.BARREL_RECIPE, "barrel"));
    }

    @ZenDocMethod(order=5, args={@ZenDocArg(arg="stages", info="game stages")}, description={"Sets game stage logic required to use the device."})
    @ZenMethod
    public static void setGameStages(ZenStages stages) {
        ModuleTechBasicConfig.STAGES_BARREL = stages.getStages();
    }

    public static class AddRecipe
    implements IAction {
        private final String name;
        private final FluidStack outputFluid;
        private final FluidStack inputFluid;
        private final Ingredient[] inputItems;
        private final int timeTicks;

        public AddRecipe(String name, FluidStack outputFluid, FluidStack inputFluid, Ingredient[] inputItems, int timeTicks) {
            this.name = name;
            this.outputFluid = outputFluid;
            this.inputItems = inputItems;
            this.inputFluid = inputFluid;
            this.timeTicks = timeTicks;
        }

        public void apply() {
            BarrelRecipe recipe = new BarrelRecipe(this.outputFluid, this.inputItems, this.inputFluid, this.timeTicks);
            ModuleTechBasic.Registries.BARREL_RECIPE.register(recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        public String describe() {
            return "Adding barrel recipe for " + this.inputFluid;
        }
    }

    public static class RemoveRecipe
    implements IAction {
        private final FluidStack output;

        public RemoveRecipe(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            BarrelRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing barrel recipes for " + this.output;
        }
    }
}

