/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic.item;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMarshmallow
extends ItemFood {
    public static final String NAME = "marshmallow";

    public ItemMarshmallow() {
        super(ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_HUNGER, (float)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_SATURATION, false);
        this.func_77848_i();
    }

    public ItemMarshmallow(int amount, float saturation, boolean isWolfFood) {
        super(amount, saturation, isWolfFood);
    }

    public static void setRoastedAtTimestamp(ItemStack itemStack, long timestamp) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        tag.func_74772_a("RoastedAtTimestamp", timestamp);
        itemStack.func_77982_d(tag);
    }

    public static long getRoastedAtTimestamp(ItemStack itemStack) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        if (!tag.func_74764_b("RoastedAtTimestamp")) {
            return 0L;
        }
        return tag.func_74763_f("RoastedAtTimestamp");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
        if (world != null && stack.func_77973_b() == ModuleTechBasic.Items.MARSHMALLOW_ROASTED) {
            long roastedAtTimestamp = ItemMarshmallow.getRoastedAtTimestamp(stack);
            double potency = ItemMarshmallow.calculatePotency(world, roastedAtTimestamp);
            int displayPotency = (int)Math.round(potency * 100.0);
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.pyrotech.tooltip.potency", (Object[])new Object[]{displayPotency}));
        }
    }

    public int func_150905_g(ItemStack stack) {
        return ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_HUNGER;
    }

    public float func_150906_h(ItemStack stack) {
        return (float)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_SATURATION;
    }

    protected int getEffectDurationTicks(World world, long roastedAtTimestamp) {
        return ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MARSHMALLOW_SPEED_DURATION_TICKS;
    }

    protected int getMaxEffectDurationTicks() {
        return ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.MAX_MARSHMALLOW_SPEED_DURATION_TICKS;
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, @Nonnull World world, EntityLivingBase entityLiving) {
        ItemMarshmallow.applyMarshmallowEffects(this.getEffectDurationTicks(world, ItemMarshmallow.getRoastedAtTimestamp(stack)), this.getMaxEffectDurationTicks(), entityLiving, this.getEffect(), this.stackEffect());
        if (entityLiving instanceof EntityPlayer) {
            this.setCooldownOnMarshmallows((EntityPlayer)entityLiving);
        }
        return super.func_77654_b(stack, world, entityLiving);
    }

    protected Potion getEffect() {
        return MobEffects.field_76424_c;
    }

    protected boolean stackEffect() {
        return true;
    }

    protected void setCooldownOnMarshmallows(EntityPlayer player) {
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_STICK_EMPTY, 10);
        player.func_184811_cZ().func_185145_a((Item)this, 10);
        player.func_184811_cZ().func_185145_a((Item)ModuleTechBasic.Items.MARSHMALLOW_ROASTED, 10);
    }

    public static void applyMarshmallowEffects(int durationTicks, int maxDurationTicks, EntityLivingBase entityLiving, Potion effect, boolean stackEffect) {
        if (durationTicks > 0) {
            int duration = durationTicks;
            PotionEffect activePotionEffect = entityLiving.func_70660_b(effect);
            if (stackEffect && activePotionEffect != null) {
                duration = Math.min(maxDurationTicks, duration + activePotionEffect.func_76459_b());
            }
            entityLiving.func_70690_d(new PotionEffect(effect, duration));
        }
    }

    public static double calculatePotency(World world, long roastedAtTimestamp) {
        return Math.max(0.0, 1.0 - (double)(world.func_82737_E() - roastedAtTimestamp) / (double)ModuleTechBasicConfig.CAMPFIRE_MARSHMALLOWS.ROASTED_MARSHMALLOW_EFFECT_POTENCY_DURATION_TICKS) + 1.0;
    }
}

